/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.enums;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.keycloak.common.ClientConnection;

public enum SslRequired {
    ALL,
    EXTERNAL,
    NONE;


    public boolean isRequired(ClientConnection connection) {
        return this.isRequired(connection.getRemoteAddr());
    }

    public boolean isRequired(String address) {
        switch (this) {
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
            case EXTERNAL: {
                return !this.isLocal(address);
            }
        }
        return true;
    }

    private boolean isLocal(String remoteAddress) {
        try {
            InetAddress inetAddress = InetAddress.getByName(remoteAddress);
            return inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isSiteLocalAddress() || inetAddress.isLinkLocalAddress() || this.isUniqueLocal(inetAddress);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    private boolean isUniqueLocal(InetAddress address) {
        if (address instanceof Inet6Address) {
            byte[] addr = address.getAddress();
            return (byte)(addr[0] & 0xFE) == -4;
        }
        return false;
    }
}

