/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.keycloak.common.util.Time;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;

public class PathCache {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final Map<String, CacheEntry> cache;
    private final AtomicBoolean writing = new AtomicBoolean(false);
    private final long maxAge;
    private final boolean enabled;
    private final Map<String, PolicyEnforcerConfig.PathConfig> paths;

    public PathCache(final int maxEntries, long maxAge, Map<String, PolicyEnforcerConfig.PathConfig> paths) {
        this.cache = new LinkedHashMap<String, CacheEntry>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return PathCache.this.cache.size() > maxEntries;
            }
        };
        this.maxAge = maxAge;
        this.enabled = maxAge >= -1L && (maxAge <= -1L || maxAge > 0L);
        this.paths = paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String uri, PolicyEnforcerConfig.PathConfig newValue) {
        if (!this.enabled) {
            if (newValue != null) {
                this.markForInvalidation(newValue);
            }
            return;
        }
        try {
            if (this.parkForWriteAndCheckInterrupt()) {
                return;
            }
            CacheEntry cacheEntry = this.cache.get(uri);
            if (cacheEntry == null) {
                this.cache.put(uri, new CacheEntry(uri, newValue, this.maxAge));
            }
        }
        finally {
            this.writing.lazySet(false);
        }
    }

    private void markForInvalidation(PolicyEnforcerConfig.PathConfig newValue) {
        PolicyEnforcerConfig.PathConfig pathConfig = this.paths.get(newValue.getPath());
        if (pathConfig != null && !pathConfig.isStatic()) {
            pathConfig.invalidate();
        }
    }

    public boolean containsKey(String uri) {
        return this.cache.containsKey(uri);
    }

    public PolicyEnforcerConfig.PathConfig get(String uri) {
        if (this.parkForReadAndCheckInterrupt()) {
            return null;
        }
        CacheEntry cached = this.cache.get(uri);
        if (cached != null) {
            return this.removeIfExpired(cached);
        }
        return null;
    }

    public void remove(String key) {
        try {
            if (this.parkForWriteAndCheckInterrupt()) {
                return;
            }
            this.cache.remove(key);
        }
        finally {
            this.writing.lazySet(false);
        }
    }

    private PolicyEnforcerConfig.PathConfig removeIfExpired(CacheEntry cached) {
        if (cached == null) {
            return null;
        }
        PolicyEnforcerConfig.PathConfig config = cached.value();
        if (cached.isExpired()) {
            this.remove(cached.key());
            if (config != null && config.getPath() != null) {
                this.markForInvalidation(config);
            }
            return null;
        }
        return config;
    }

    private boolean parkForWriteAndCheckInterrupt() {
        while (!this.writing.compareAndSet(false, true)) {
            LockSupport.parkNanos(1L);
            if (!Thread.interrupted()) continue;
            return true;
        }
        return false;
    }

    private boolean parkForReadAndCheckInterrupt() {
        while (this.writing.get()) {
            LockSupport.parkNanos(1L);
            if (!Thread.interrupted()) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.cache.size();
    }

    private static final class CacheEntry {
        final String key;
        final PolicyEnforcerConfig.PathConfig value;
        final long expiration;

        CacheEntry(String key, PolicyEnforcerConfig.PathConfig value, long maxAge) {
            this.key = key;
            this.value = value;
            this.expiration = maxAge == -1L ? -1L : Time.currentTimeMillis() + maxAge;
        }

        String key() {
            return this.key;
        }

        PolicyEnforcerConfig.PathConfig value() {
            return this.value;
        }

        boolean isExpired() {
            return this.expiration != -1L ? Time.currentTimeMillis() > this.expiration : false;
        }
    }
}

