/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.inheritance;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.outline.PackageOutline;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.plugin.inheritance.Customizations;
import org.jvnet.jaxb2_commons.plugin.inheritance.ExtendsClass;
import org.jvnet.jaxb2_commons.plugin.inheritance.ImplementsInterface;
import org.jvnet.jaxb2_commons.plugin.inheritance.ObjectFactoryCustomization;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritancePlugin
extends AbstractParameterizablePlugin {
    public String getOptionName() {
        return "Xinheritance";
    }

    public String getUsage() {
        return "TBD";
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.EXTENDS_ELEMENT_NAME, Customizations.IMPLEMENTS_ELEMENT_NAME, Customizations.OBJECT_FACTORY_ELEMENT_NAME);
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClassOutline(classOutline);
        }
        for (EnumOutline enumOutline : outline.getEnums()) {
            this.processEnumOutline(enumOutline);
        }
        for (CElementInfo elementInfo : outline.getModel().getAllElements()) {
            ElementOutline elementOutline = outline.getElement(elementInfo);
            if (elementOutline == null) continue;
            this.processElementOutline(elementOutline);
        }
        this.processPackageOutlines(outline);
        return true;
    }

    private void processClassOutline(ClassOutline classOutline) {
        this.generateExtends(classOutline);
        this.generateImplements(classOutline);
    }

    private void processEnumOutline(EnumOutline enumOutline) {
        this.generateExtends(enumOutline);
        this.generateImplements(enumOutline);
    }

    private void processElementOutline(ElementOutline elementOutline) {
        this.generateExtends(elementOutline);
        this.generateImplements(elementOutline);
    }

    private void processPackageOutlines(Outline outline) {
        List customizations = CustomizationUtils.findCustomizations((Outline)outline, (QName)Customizations.OBJECT_FACTORY_ELEMENT_NAME);
        for (CPluginCustomization customization : customizations) {
            ObjectFactoryCustomization objectFactoryCustomization = (ObjectFactoryCustomization)CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)customization);
            String packageName = objectFactoryCustomization.getPackageName();
            if (packageName == null) continue;
            for (PackageOutline packageOutline : outline.getAllPackageContexts()) {
                List<ImplementsInterface> implementsInterfaces;
                JDefinedClass theClass = packageOutline.objectFactory();
                if (!packageName.equals(packageOutline._package().name())) continue;
                ExtendsClass extendsClass = objectFactoryCustomization.getExtendsClass();
                if (extendsClass != null) {
                    this.generateExtends(theClass, extendsClass);
                }
                if ((implementsInterfaces = objectFactoryCustomization.getImplementsInterface()) == null) continue;
                for (ImplementsInterface implementsInterface : implementsInterfaces) {
                    if (implementsInterface == null) continue;
                    this.generateImplements(theClass, implementsInterface);
                }
            }
        }
    }

    private void generateExtends(ClassOutline classOutline) {
        JDefinedClass theClass = classOutline.implClass;
        CPluginCustomization extendsClassCustomization = CustomizationUtils.findCustomization((ClassOutline)classOutline, (QName)Customizations.EXTENDS_ELEMENT_NAME);
        this.generateExtends(theClass, extendsClassCustomization);
    }

    private void generateExtends(EnumOutline enumOutline) {
        JDefinedClass theClass = enumOutline.clazz;
        CPluginCustomization extendsClassCustomization = CustomizationUtils.findCustomization((EnumOutline)enumOutline, (QName)Customizations.EXTENDS_ELEMENT_NAME);
        this.generateExtends(theClass, extendsClassCustomization);
    }

    private void generateExtends(ElementOutline elementOutline) {
        JDefinedClass theClass = elementOutline.implClass;
        CPluginCustomization extendsClassCustomization = CustomizationUtils.findCustomization((ElementOutline)elementOutline, (QName)Customizations.EXTENDS_ELEMENT_NAME);
        this.generateExtends(theClass, extendsClassCustomization);
    }

    private void generateExtends(JDefinedClass theClass, CPluginCustomization extendsClassCustomization) throws AssertionError {
        if (extendsClassCustomization != null) {
            ExtendsClass extendsClass = (ExtendsClass)CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)extendsClassCustomization);
            this.generateExtends(theClass, extendsClass);
        }
    }

    private void generateExtends(JDefinedClass theClass, ExtendsClass extendsClass) {
        if (extendsClass.getClassName() != null) {
            String name = extendsClass.getClassName();
            JClass targetClass = theClass.owner().ref(name);
            theClass._extends(targetClass);
        }
    }

    private void generateImplements(ClassOutline classOutline) {
        JDefinedClass theClass = classOutline.implClass;
        List implementsInterfaceCustomizations = CustomizationUtils.findCustomizations((ClassOutline)classOutline, (QName)Customizations.IMPLEMENTS_ELEMENT_NAME);
        this.generateImplements(theClass, implementsInterfaceCustomizations);
    }

    private void generateImplements(EnumOutline enumOutline) {
        JDefinedClass theClass = enumOutline.clazz;
        List implementsInterfaceCustomizations = CustomizationUtils.findCustomizations((EnumOutline)enumOutline, (QName)Customizations.IMPLEMENTS_ELEMENT_NAME);
        this.generateImplements(theClass, implementsInterfaceCustomizations);
    }

    private void generateImplements(ElementOutline elementOutline) {
        JDefinedClass theClass = elementOutline.implClass;
        List implementsInterfaceCustomizations = CustomizationUtils.findCustomizations((ElementOutline)elementOutline, (QName)Customizations.IMPLEMENTS_ELEMENT_NAME);
        this.generateImplements(theClass, implementsInterfaceCustomizations);
    }

    private void generateImplements(JDefinedClass theClass, List<CPluginCustomization> implementsInterfaceCustomizations) throws AssertionError {
        for (CPluginCustomization implementsInterfaceCustomization : implementsInterfaceCustomizations) {
            if (implementsInterfaceCustomization == null) continue;
            ImplementsInterface implementsInterface = (ImplementsInterface)CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)implementsInterfaceCustomization);
            this.generateImplements(theClass, implementsInterface);
        }
    }

    private void generateImplements(JDefinedClass theClass, ImplementsInterface implementsInterface) {
        if (implementsInterface.getInterfaceName() != null) {
            JClass targetClass = theClass.owner().ref(implementsInterface.getInterfaceName());
            theClass._implements(targetClass);
        }
    }
}

