/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.parser.parboiled;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jtwig.parser.addon.AddonParserProvider;
import org.jtwig.parser.config.JtwigParserConfiguration;
import org.jtwig.parser.config.SyntaxConfiguration;
import org.jtwig.parser.parboiled.DocumentParser;
import org.jtwig.parser.parboiled.base.BasicParser;
import org.jtwig.parser.parboiled.base.BooleanParser;
import org.jtwig.parser.parboiled.base.LexicParser;
import org.jtwig.parser.parboiled.base.LimitsParser;
import org.jtwig.parser.parboiled.base.PositionTrackerParser;
import org.jtwig.parser.parboiled.base.SpacingParser;
import org.jtwig.parser.parboiled.expression.AnyExpressionParser;
import org.jtwig.parser.parboiled.expression.BinaryOperationExpressionParser;
import org.jtwig.parser.parboiled.expression.BinaryOperationSuffixExpressionParser;
import org.jtwig.parser.parboiled.expression.BinaryOrPrimaryExpressionParser;
import org.jtwig.parser.parboiled.expression.BooleanExpressionParser;
import org.jtwig.parser.parboiled.expression.ComprehensionListExpressionParser;
import org.jtwig.parser.parboiled.expression.ConstantExpressionParser;
import org.jtwig.parser.parboiled.expression.EnumerationListExpressionParser;
import org.jtwig.parser.parboiled.expression.FunctionExpressionParser;
import org.jtwig.parser.parboiled.expression.MapExpressionParser;
import org.jtwig.parser.parboiled.expression.MapSelectionExpressionParser;
import org.jtwig.parser.parboiled.expression.NullExpressionParser;
import org.jtwig.parser.parboiled.expression.NumberExpressionParser;
import org.jtwig.parser.parboiled.expression.PrimaryExpressionParser;
import org.jtwig.parser.parboiled.expression.SimpleExpressionParser;
import org.jtwig.parser.parboiled.expression.StringExpressionParser;
import org.jtwig.parser.parboiled.expression.TernaryOperationExpressionParser;
import org.jtwig.parser.parboiled.expression.TestOperationExpressionParser;
import org.jtwig.parser.parboiled.expression.UnaryOperationExpressionParser;
import org.jtwig.parser.parboiled.expression.VariableExpressionParser;
import org.jtwig.parser.parboiled.expression.operator.BinaryOperatorParser;
import org.jtwig.parser.parboiled.expression.operator.UnaryOperatorParser;
import org.jtwig.parser.parboiled.expression.test.AnyTestExpressionParser;
import org.jtwig.parser.parboiled.expression.test.TestExpressionParser;
import org.jtwig.parser.parboiled.node.AutoEscapeNodeParser;
import org.jtwig.parser.parboiled.node.BlockNodeParser;
import org.jtwig.parser.parboiled.node.CommentParser;
import org.jtwig.parser.parboiled.node.CompositeNodeParser;
import org.jtwig.parser.parboiled.node.ContentEscapeNodeParser;
import org.jtwig.parser.parboiled.node.DoNodeParser;
import org.jtwig.parser.parboiled.node.EmbedNodeParser;
import org.jtwig.parser.parboiled.node.ExtendsNodeParser;
import org.jtwig.parser.parboiled.node.FilterNodeParser;
import org.jtwig.parser.parboiled.node.FlushNodeParser;
import org.jtwig.parser.parboiled.node.ForLoopNodeParser;
import org.jtwig.parser.parboiled.node.IfNodeParser;
import org.jtwig.parser.parboiled.node.ImportNodeParser;
import org.jtwig.parser.parboiled.node.ImportSelfNodeParser;
import org.jtwig.parser.parboiled.node.IncludeNodeParser;
import org.jtwig.parser.parboiled.node.MacroNodeParser;
import org.jtwig.parser.parboiled.node.OutputNodeParser;
import org.jtwig.parser.parboiled.node.OverrideBlockNodeParser;
import org.jtwig.parser.parboiled.node.SetNodeParser;
import org.jtwig.parser.parboiled.node.TextNodeParser;
import org.jtwig.parser.parboiled.node.VerbatimNodeParser;
import org.jtwig.render.expression.calculator.operation.binary.BinaryOperator;
import org.jtwig.render.expression.calculator.operation.unary.UnaryOperator;
import org.jtwig.resource.reference.ResourceReference;
import org.parboiled.BaseParser;
import org.parboiled.Parboiled;

public class ParserContext {
    private final ResourceReference resource;
    private final JtwigParserConfiguration configuration;
    private final Map<Class, BaseParser> parsers;
    private final Collection<AddonParserProvider> addOnParsers;

    public static ParserContext instance(ResourceReference resource, JtwigParserConfiguration configuration, Collection<AddonParserProvider> addOnParsers, Collection<UnaryOperator> unaryOperators, Collection<BinaryOperator> binaryOperators, List<Class<? extends TestExpressionParser>> testExpressionParsers) {
        ParserContext context = new ParserContext(resource, configuration, addOnParsers);
        Parboiled.createParser(BooleanParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(PositionTrackerParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(SpacingParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(LexicParser.class, (Object[])new Object[]{context, ParserContext.extraKeywords(addOnParsers)});
        Parboiled.createParser(LimitsParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(CommentParser.class, (Object[])new Object[]{context});
        for (Class<? extends TestExpressionParser> testExpressionParser : testExpressionParsers) {
            Parboiled.createParser(testExpressionParser, (Object[])new Object[]{context});
        }
        Parboiled.createParser(AnyTestExpressionParser.class, (Object[])new Object[]{context, testExpressionParsers});
        Parboiled.createParser(MapSelectionExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(UnaryOperatorParser.class, (Object[])new Object[]{context, unaryOperators});
        Parboiled.createParser(BinaryOperatorParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(BinaryOrPrimaryExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(EnumerationListExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(ComprehensionListExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(MapExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(StringExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(NumberExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(BooleanExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(NullExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(ConstantExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(VariableExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(FunctionExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(TestOperationExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(UnaryOperationExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(BinaryOperationExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(BinaryOperationSuffixExpressionParser.class, (Object[])new Object[]{context, binaryOperators});
        Parboiled.createParser(TernaryOperationExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(PrimaryExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(SimpleExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(AnyExpressionParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(SetNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(DoNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(FlushNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(IncludeNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(BlockNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(OverrideBlockNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(IfNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(ForLoopNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(ImportSelfNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(ImportNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(TextNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(MacroNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(ExtendsNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(EmbedNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(OutputNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(AutoEscapeNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(ContentEscapeNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(VerbatimNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(FilterNodeParser.class, (Object[])new Object[]{context});
        for (AddonParserProvider provider : addOnParsers) {
            Parboiled.createParser(provider.parser(), (Object[])new Object[]{context});
        }
        Parboiled.createParser(CompositeNodeParser.class, (Object[])new Object[]{context});
        Parboiled.createParser(DocumentParser.class, (Object[])new Object[]{context});
        return context;
    }

    private static Collection<String> extraKeywords(Collection<AddonParserProvider> addOnParsers) {
        ArrayList<String> result = new ArrayList<String>();
        for (AddonParserProvider provider : addOnParsers) {
            result.addAll(provider.keywords());
        }
        return result;
    }

    public ParserContext(ResourceReference resource, JtwigParserConfiguration configuration, Collection<AddonParserProvider> addOnParsers) {
        this.resource = resource;
        this.configuration = configuration;
        this.parsers = new HashMap<Class, BaseParser>();
        this.addOnParsers = addOnParsers;
    }

    public <T extends BaseParser> ParserContext register(Class type, T parser) {
        this.parsers.put(type, parser);
        return this;
    }

    public Collection<AddonParserProvider> getAddOnParsers() {
        return this.addOnParsers;
    }

    public <T extends BasicParser> T parser(Class<T> type) {
        return (T)((Object)((BasicParser)this.parsers.get(type)));
    }

    public SyntaxConfiguration syntaxConfiguration() {
        return this.configuration.getSyntaxConfiguration();
    }

    public JtwigParserConfiguration getConfiguration() {
        return this.configuration;
    }

    public ResourceReference resource() {
        return this.resource;
    }
}

