/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.sqlite;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Check;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Meta;
import org.jooq.Query;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record12;
import org.jooq.Record4;
import org.jooq.Record5;
import org.jooq.Record6;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.conf.RenderQuotedNames;
import org.jooq.exception.DataDefinitionException;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.ParserException;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ResultQueryDatabase;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.XMLSchemaCollectionDefinition;
import org.jooq.meta.jaxb.SchemaMappingType;
import org.jooq.meta.sqlite.SQLiteTableDefinition;
import org.jooq.meta.sqlite.sqlite_master.SQLiteMaster;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public class SQLiteDatabase
extends AbstractDatabase
implements ResultQueryDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(SQLiteDatabase.class);
    private Meta snapshot;
    private Boolean existsSqliteSequence;

    public SQLiteDatabase() {
        SchemaMappingType schema = new SchemaMappingType();
        schema.setInputSchema("");
        schema.setOutputSchema("");
        ArrayList<SchemaMappingType> schemata = new ArrayList<SchemaMappingType>();
        schemata.add(schema);
        this.setConfiguredSchemata(schemata);
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.SQLITE);
    }

    @Override
    protected RenderQuotedNames getRenderQuotedNames() {
        return RenderQuotedNames.EXPLICIT_DEFAULT_UNQUOTED;
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        Field fIndexName = DSL.field((String)"il.name", String.class).as("index_name");
        Field fUnique = DSL.field((String)"il.\"unique\"", Boolean.TYPE).as(DSL.quotedName((String)"unique"));
        final Field fSeqno = DSL.field((String)"ii.seqno", Integer.TYPE).add((Field)DSL.one()).as("seqno");
        final Field fColumnName = DSL.field((String)"ii.name", String.class).as("column_name");
        Map indexes = this.create().select(SQLiteMaster.NAME, (SelectField)fIndexName, (SelectField)fUnique, (SelectField)fSeqno, (SelectField)fColumnName).from(new TableLike[]{SQLiteMaster.SQLITE_MASTER, DSL.table((String)"pragma_index_list({0})", (QueryPart[])new QueryPart[]{SQLiteMaster.NAME}).as("il"), DSL.table((String)"pragma_index_info(il.name)").as("ii")}).where(SQLiteMaster.TYPE.eq((Field)DSL.inline((String)"table"))).and(this.getIncludeSystemIndexes() ? DSL.noCondition() : DSL.field((String)"il.origin", (DataType)SQLDataType.VARCHAR).notIn(new Field[]{DSL.inline((String)"pk"), DSL.inline((String)"u")})).orderBy(new int[]{1, 2, 4}).fetchGroups(new Field[]{SQLiteMaster.NAME, fIndexName, fUnique}, new Field[]{fColumnName, fSeqno});
        block0: for (Map.Entry entry : indexes.entrySet()) {
            Record index = (Record)entry.getKey();
            final Result columns = (Result)entry.getValue();
            SchemaDefinition tableSchema = this.getSchemata().get(0);
            if (tableSchema == null) continue;
            String indexName = (String)index.get(fIndexName);
            String tableName = (String)index.get(SQLiteMaster.NAME);
            final TableDefinition table = this.getTable(tableSchema, tableName);
            if (table == null) continue;
            boolean unique = (Boolean)index.get(fUnique);
            for (Record column : columns) {
                if (table.getColumn((String)column.get(fColumnName)) != null) continue;
                continue block0;
            }
            result.add(new AbstractIndexDefinition(this, tableSchema, indexName, table, unique){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (Record column : columns) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn((String)column.get(fColumnName)), SortOrder.ASC, (Integer)column.get(fSeqno, Integer.TYPE)));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    private String keyName(UniqueKey<?> key) {
        String name = key.getName();
        return !StringUtils.isBlank((String)name) ? name : (key.isPrimary() ? "pk_" + key.getTable().getName() : "uk_" + key.getTable().getName() + "_" + Internal.hash((QueryPart)DSL.list((Collection)key.getFields())));
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Table t : this.snapshot().getTables()) {
            TableDefinition table;
            UniqueKey pk = t.getPrimaryKey();
            if (pk == null || (table = this.getTable(this.getSchemata().get(0), pk.getTable().getName())) == null) continue;
            for (Field f : pk.getFields()) {
                relations2.addPrimaryKey(this.keyName(pk), table, table.getColumn(f.getName()));
            }
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Table t : this.snapshot().getTables()) {
            for (UniqueKey uk : t.getUniqueKeys()) {
                TableDefinition table = this.getTable(this.getSchemata().get(0), uk.getTable().getName());
                if (table == null) continue;
                for (Field f : uk.getFields()) {
                    relations2.addUniqueKey(this.keyName(uk), table, table.getColumn(f.getName()));
                }
            }
        }
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        for (Table t : this.snapshot().getTables()) {
            for (ForeignKey fk : t.getReferences()) {
                UniqueKey uk = fk.getKey();
                if (uk == null) continue;
                TableDefinition fkTable = this.getTable(this.getSchemata().get(0), fk.getTable().getName(), true);
                TableDefinition ukTable = this.getTable(this.getSchemata().get(0), uk.getTable().getName(), true);
                if (fkTable == null || ukTable == null) continue;
                String ukName = this.keyName(uk);
                String fkName = StringUtils.isBlank((String)fk.getName()) ? "fk_" + fkTable.getName() + "_" + ukName : fk.getName();
                TableField[] fkFields = fk.getFieldsArray();
                TableField[] ukFields = fk.getKeyFieldsArray();
                for (int i = 0; i < fkFields.length; ++i) {
                    relations2.addForeignKey(fkName, fkTable, fkTable.getColumn(fkFields[i].getName(), true), ukName, ukTable, ukTable.getColumn(ukFields[i].getName(), true), true, fk.getDeleteRule(), fk.getUpdateRule());
                }
            }
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r) throws SQLException {
        DSLContext ctx = this.create().configuration().deriveSettings(s -> s.withInterpreterDelayForeignKeyDeclarations(Boolean.valueOf(true))).dsl();
        SchemaDefinition schema = this.getSchemata().get(0);
        for (Record record : ctx.select(SQLiteMaster.TBL_NAME, SQLiteMaster.SQL).from((TableLike)SQLiteMaster.SQLITE_MASTER).where((Condition)SQLiteMaster.SQL.likeIgnoreCase("%CHECK%")).orderBy(SQLiteMaster.TBL_NAME)) {
            TableDefinition table = this.getTable(schema, (String)record.get(SQLiteMaster.TBL_NAME));
            if (table == null) continue;
            String sql = (String)record.get(SQLiteMaster.SQL);
            try {
                Query query = ctx.parser().parseQuery(sql);
                for (Table t : ctx.meta(new Query[]{query}).getTables(table.getName())) {
                    for (Check check : t.getChecks()) {
                        r.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, check.getName(), ctx.renderInlined((QueryPart)check.condition()), check.enforced()));
                    }
                }
            }
            catch (ParserException e) {
                log.info((Object)("Cannot parse SQL: " + sql), (Throwable)e);
            }
            catch (DataDefinitionException e) {
                log.info((Object)("Cannot interpret SQL: " + sql), (Throwable)e);
            }
        }
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        result.add(new SchemaDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        return result;
    }

    @Override
    public ResultQuery<Record4<String, String, String, String>> sources(List<String> schemas) {
        return this.create().select((SelectField)DSL.inline(null, (DataType)SQLDataType.VARCHAR).as("catalog"), (SelectField)DSL.inline(null, (DataType)SQLDataType.VARCHAR).as("schema"), SQLiteMaster.NAME, SQLiteMaster.SQL).from((TableLike)SQLiteMaster.SQLITE_MASTER).orderBy(SQLiteMaster.NAME);
    }

    @Override
    public ResultQuery<Record5<String, String, String, String, String>> comments(List<String> schemas) {
        return null;
    }

    @Override
    public ResultQuery<Record12<String, String, String, String, Integer, Integer, Long, Long, BigDecimal, BigDecimal, Boolean, Long>> sequences(List<String> schemas) {
        return null;
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> enums(List<String> schemas) {
        return null;
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> primaryKeys(List<String> schemas) {
        return null;
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> uniqueKeys(List<String> schemas) {
        return null;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        CommonTableExpression virtualTables = DSL.name((String)"virtual_tables").fields("name").as((ResultQuery)DSL.select((SelectField)DSL.coalesce(SQLiteMaster.NAME, (Field[])new Field[]{DSL.inline((String)"")})).from((TableLike)SQLiteMaster.SQLITE_MASTER).where((Condition)SQLiteMaster.SQL.likeIgnoreCase((Field)DSL.inline((String)"%create virtual table%"))));
        for (Record record : this.create().with(new CommonTableExpression[]{virtualTables}).select(SQLiteMaster.NAME, (SelectField)DSL.when((Condition)SQLiteMaster.TYPE.eq((Field)DSL.inline((String)"view")), (Field)DSL.inline((String)TableOptions.TableType.VIEW.name())).else_((Field)DSL.inline((String)TableOptions.TableType.TABLE.name())).as("table_type"), SQLiteMaster.SQL).from((TableLike)SQLiteMaster.SQLITE_MASTER).where(SQLiteMaster.TYPE.in((Object[])new String[]{"table", "view"})).and(this.getIncludeSystemTables() ? DSL.noCondition() : SQLiteMaster.NAME.notIn(new Field[]{DSL.inline((String)"sqlite_sequence"), DSL.inline((String)"sqlite_master")}).and(SQLiteMaster.NAME.notLike((Field)DSL.inline((String)"sqlite!_stat%")).escape('!')).and(SQLiteMaster.NAME.notLike(DSL.all((Field[])new Field[]{DSL.inline((String)"%!_content"), DSL.inline((String)"%!_segments"), DSL.inline((String)"%!_segdir"), DSL.inline((String)"%!_docsize"), DSL.inline((String)"%!_stat")})).escape('!').or(SQLiteMaster.NAME.like((Field)DSL.inline((String)"%!_content")).escape('!').and(DSL.replace(SQLiteMaster.NAME, (Field)DSL.inline((String)"_content")).notIn((Select)DSL.selectFrom((TableLike)virtualTables)))).or(SQLiteMaster.NAME.like((Field)DSL.inline((String)"%!_segments")).escape('!').and(DSL.replace(SQLiteMaster.NAME, (Field)DSL.inline((String)"_segments")).notIn((Select)DSL.selectFrom((TableLike)virtualTables)))).or(SQLiteMaster.NAME.like((Field)DSL.inline((String)"%!_segdir")).escape('!').and(DSL.replace(SQLiteMaster.NAME, (Field)DSL.inline((String)"_segdir")).notIn((Select)DSL.selectFrom((TableLike)virtualTables)))).or(SQLiteMaster.NAME.like((Field)DSL.inline((String)"%!_docsize")).escape('!').and(DSL.replace(SQLiteMaster.NAME, (Field)DSL.inline((String)"_docsize")).notIn((Select)DSL.selectFrom((TableLike)virtualTables)))).or(SQLiteMaster.NAME.like((Field)DSL.inline((String)"%!_stat")).escape('!').and(DSL.replace(SQLiteMaster.NAME, (Field)DSL.inline((String)"_stat")).notIn((Select)DSL.selectFrom((TableLike)virtualTables)))))).orderBy(SQLiteMaster.NAME)) {
            String name = (String)record.get(SQLiteMaster.NAME);
            TableOptions.TableType tableType = (TableOptions.TableType)record.get("table_type", TableOptions.TableType.class);
            String source = (String)record.get(SQLiteMaster.SQL);
            result.add(new SQLiteTableDefinition(this.getSchemata().get(0), name, "", tableType, source));
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, String>> generators(List<String> schemas) {
        return null;
    }

    @Override
    protected List<XMLSchemaCollectionDefinition> getXMLSchemaCollections0() throws SQLException {
        ArrayList<XMLSchemaCollectionDefinition> result = new ArrayList<XMLSchemaCollectionDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    Meta snapshot() {
        if (this.snapshot == null) {
            this.snapshot = this.create().meta().snapshot();
        }
        return this.snapshot;
    }

    boolean existsSqliteSequence() {
        if (this.existsSqliteSequence == null) {
            this.existsSqliteSequence = (Boolean)this.create().selectCount().from((TableLike)SQLiteMaster.SQLITE_MASTER).where(DSL.lower(SQLiteMaster.NAME).eq((Object)"sqlite_sequence")).fetchOne(0, Boolean.TYPE);
        }
        return this.existsSqliteSequence;
    }
}

