/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.job;

import org.apache.commons.lang3.Validate;
import org.jodconverter.document.DocumentFormat;
import org.jodconverter.job.AbstractSourceDocumentSpecs;
import org.jodconverter.job.AbstractTargetDocumentSpecs;
import org.jodconverter.job.ConversionJob;
import org.jodconverter.job.ConversionJobWithOptionalTargetFormatUnspecified;
import org.jodconverter.office.OfficeException;

public abstract class AbstractConversionJob
implements ConversionJobWithOptionalTargetFormatUnspecified {
    protected AbstractSourceDocumentSpecs source;
    protected AbstractTargetDocumentSpecs target;

    protected AbstractConversionJob(AbstractSourceDocumentSpecs source, AbstractTargetDocumentSpecs target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public ConversionJob as(DocumentFormat format) {
        this.target.setDocumentFormat(format);
        return this;
    }

    @Override
    public final void execute() throws OfficeException {
        Validate.notNull((Object)this.target.getFormat(), (String)"The target format is missing or not supported", (Object[])new Object[0]);
        this.doExecute();
    }

    protected abstract void doExecute() throws OfficeException;
}

