/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money.format;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import org.joda.money.BigMoney;
import org.joda.money.format.GroupingStyle;
import org.joda.money.format.MoneyAmountStyle;
import org.joda.money.format.MoneyParseContext;
import org.joda.money.format.MoneyParser;
import org.joda.money.format.MoneyPrintContext;
import org.joda.money.format.MoneyPrinter;

final class AmountPrinterParser
implements MoneyPrinter,
MoneyParser,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MoneyAmountStyle style;

    AmountPrinterParser(MoneyAmountStyle style) {
        this.style = style;
    }

    @Override
    public void print(MoneyPrintContext context, Appendable appendable, BigMoney money) throws IOException {
        String str;
        MoneyAmountStyle activeStyle = this.style.localize(context.getLocale());
        if (money.isNegative()) {
            if (!activeStyle.isAbsValue()) {
                appendable.append(activeStyle.getNegativeSignCharacter().charValue());
            }
            str = money.negated().getAmount().toPlainString();
        } else {
            str = money.getAmount().toPlainString();
        }
        Character zeroChar = activeStyle.getZeroCharacter();
        if (zeroChar.charValue() != '0') {
            int diff = zeroChar.charValue() - 48;
            StringBuilder zeroConvert = new StringBuilder(str);
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (ch < '0' || ch > '9') continue;
                zeroConvert.setCharAt(i, (char)(ch + diff));
            }
            str = zeroConvert.toString();
        }
        int decPoint = str.indexOf(46);
        int afterDecPoint = decPoint + 1;
        if (activeStyle.getGroupingStyle() == GroupingStyle.NONE) {
            if (decPoint < 0) {
                appendable.append(str);
                if (activeStyle.isForcedDecimalPoint()) {
                    appendable.append(activeStyle.getDecimalPointCharacter().charValue());
                }
            } else {
                appendable.append(str.subSequence(0, decPoint)).append(activeStyle.getDecimalPointCharacter().charValue()).append(str.substring(afterDecPoint));
            }
        } else {
            int i;
            Integer groupingSize = activeStyle.getGroupingSize();
            Integer extendedGroupingSize = activeStyle.getExtendedGroupingSize();
            extendedGroupingSize = extendedGroupingSize == 0 ? groupingSize : extendedGroupingSize;
            Character groupingChar = activeStyle.getGroupingCharacter();
            int pre = decPoint < 0 ? str.length() : decPoint;
            int post = decPoint < 0 ? 0 : str.length() - decPoint - 1;
            appendable.append(str.charAt(0));
            for (i = 1; i < pre; ++i) {
                if (this.isPreGroupingPoint(pre - i, groupingSize, extendedGroupingSize)) {
                    appendable.append(groupingChar.charValue());
                }
                appendable.append(str.charAt(i));
            }
            if (decPoint >= 0 || activeStyle.isForcedDecimalPoint()) {
                appendable.append(activeStyle.getDecimalPointCharacter().charValue());
            }
            if (activeStyle.getGroupingStyle() == GroupingStyle.BEFORE_DECIMAL_POINT) {
                if (decPoint >= 0) {
                    appendable.append(str.substring(afterDecPoint));
                }
            } else {
                for (i = 0; i < post; ++i) {
                    appendable.append(str.charAt(i + afterDecPoint));
                    if (!this.isPostGroupingPoint(i, post, groupingSize, extendedGroupingSize)) continue;
                    appendable.append(groupingChar.charValue());
                }
            }
        }
    }

    private boolean isPreGroupingPoint(int remaining, int groupingSize, int extendedGroupingSize) {
        if (remaining >= groupingSize + extendedGroupingSize) {
            return (remaining - groupingSize) % extendedGroupingSize == 0;
        }
        return remaining % groupingSize == 0;
    }

    private boolean isPostGroupingPoint(int i, int post, int groupingSize, int extendedGroupingSize) {
        boolean atEnd;
        boolean bl = atEnd = i + 1 >= post;
        if (i > groupingSize) {
            return (i - groupingSize) % extendedGroupingSize == extendedGroupingSize - 1 && !atEnd;
        }
        return i % groupingSize == groupingSize - 1 && !atEnd;
    }

    @Override
    public void parse(MoneyParseContext context) {
        int len = context.getTextLength();
        MoneyAmountStyle activeStyle = this.style.localize(context.getLocale());
        char[] buf = new char[len - context.getIndex()];
        int bufPos = 0;
        boolean dpSeen = false;
        int pos = context.getIndex();
        if (pos < len) {
            char ch = context.getText().charAt(pos++);
            if (ch == activeStyle.getNegativeSignCharacter().charValue()) {
                buf[bufPos++] = 45;
            } else if (ch == activeStyle.getPositiveSignCharacter().charValue()) {
                buf[bufPos++] = 43;
            } else if (ch >= activeStyle.getZeroCharacter().charValue() && ch < activeStyle.getZeroCharacter().charValue() + 10) {
                buf[bufPos++] = (char)(48 + ch - activeStyle.getZeroCharacter().charValue());
            } else if (ch == activeStyle.getDecimalPointCharacter().charValue()) {
                buf[bufPos++] = 46;
                dpSeen = true;
            } else {
                context.setError();
                return;
            }
        }
        boolean lastWasGroup = false;
        while (pos < len) {
            char ch = context.getText().charAt(pos);
            if (ch >= activeStyle.getZeroCharacter().charValue() && ch < activeStyle.getZeroCharacter().charValue() + 10) {
                buf[bufPos++] = (char)(48 + ch - activeStyle.getZeroCharacter().charValue());
                lastWasGroup = false;
            } else if (ch == activeStyle.getDecimalPointCharacter().charValue() && !dpSeen) {
                buf[bufPos++] = 46;
                dpSeen = true;
                lastWasGroup = false;
            } else {
                if (ch != activeStyle.getGroupingCharacter().charValue() || lastWasGroup) break;
                lastWasGroup = true;
            }
            ++pos;
        }
        if (lastWasGroup) {
            --pos;
        }
        try {
            context.setAmount(new BigDecimal(buf, 0, bufPos));
            context.setIndex(pos);
        }
        catch (NumberFormatException ex) {
            context.setError();
        }
    }

    public String toString() {
        return "${amount}";
    }
}

