/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers.diagnostics;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Severity;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/AbstractDiagnosticForTests;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "element", "Lcom/intellij/psi/PsiElement;", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;)V", "getFactory", "getPsiElement", "getPsiFile", "Lcom/intellij/psi/PsiFile;", "getSeverity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "getTextRanges", "", "Lcom/intellij/openapi/util/TextRange;", "isValid", "", "frontend"})
public class AbstractDiagnosticForTests
implements Diagnostic {
    private final PsiElement element;
    private final DiagnosticFactory<?> factory;

    @Override
    @NotNull
    public DiagnosticFactory<?> getFactory() {
        return this.factory;
    }

    @Override
    @NotNull
    public Severity getSeverity() {
        return Severity.ERROR;
    }

    @Override
    @NotNull
    public PsiElement getPsiElement() {
        return this.element;
    }

    @Override
    @NotNull
    public List<TextRange> getTextRanges() {
        return CollectionsKt.listOf((Object)this.element.getTextRange());
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.element.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"element.containingFile");
        return psiFile;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public AbstractDiagnosticForTests(@NotNull PsiElement element, @NotNull DiagnosticFactory<?> factory2) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(factory2, (String)"factory");
        this.element = element;
        this.factory = factory2;
    }
}

