/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.process.instance.event.listeners.TriggerRulesEventListener;
import org.jbpm.runtime.manager.impl.ManagedAuditEventBuilderImpl;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.SimpleRegisterableItemsFactory;
import org.jbpm.services.task.audit.JPATaskLifeCycleEventListener;
import org.jbpm.services.task.wih.ExternalTaskEventListener;
import org.jbpm.services.task.wih.LocalHTWorkItemHandler;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.DisposeListener;
import org.kie.internal.task.api.EventService;

public class DefaultRegisterableItemsFactory
extends SimpleRegisterableItemsFactory {
    private AuditEventBuilder auditBuilder = new ManagedAuditEventBuilderImpl();

    @Override
    public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
        HashMap<String, WorkItemHandler> defaultHandlers = new HashMap<String, WorkItemHandler>();
        WorkItemHandler handler = this.getHTWorkItemHandler(runtime);
        defaultHandlers.put("Human Task", handler);
        defaultHandlers.putAll(super.getWorkItemHandlers(runtime));
        return defaultHandlers;
    }

    @Override
    public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
        ArrayList<ProcessEventListener> defaultListeners = new ArrayList<ProcessEventListener>();
        AbstractAuditLogger logger = AuditLoggerFactory.newJPAInstance((Environment)runtime.getKieSession().getEnvironment());
        logger.setBuilder(this.getAuditBuilder(runtime));
        defaultListeners.add((ProcessEventListener)logger);
        defaultListeners.addAll(super.getProcessEventListeners(runtime));
        return defaultListeners;
    }

    @Override
    public List<AgendaEventListener> getAgendaEventListeners(RuntimeEngine runtime) {
        ArrayList<AgendaEventListener> defaultListeners = new ArrayList<AgendaEventListener>();
        defaultListeners.add((AgendaEventListener)new TriggerRulesEventListener(runtime.getKieSession()));
        defaultListeners.addAll(super.getAgendaEventListeners(runtime));
        return defaultListeners;
    }

    @Override
    public List<RuleRuntimeEventListener> getRuleRuntimeEventListeners(RuntimeEngine runtime) {
        ArrayList<RuleRuntimeEventListener> defaultListeners = new ArrayList<RuleRuntimeEventListener>();
        defaultListeners.addAll(super.getRuleRuntimeEventListeners(runtime));
        return defaultListeners;
    }

    @Override
    public List<TaskLifeCycleEventListener> getTaskListeners() {
        ArrayList<TaskLifeCycleEventListener> defaultListeners = new ArrayList<TaskLifeCycleEventListener>();
        defaultListeners.add((TaskLifeCycleEventListener)new JPATaskLifeCycleEventListener());
        defaultListeners.addAll(super.getTaskListeners());
        return defaultListeners;
    }

    protected WorkItemHandler getHTWorkItemHandler(RuntimeEngine runtime) {
        ExternalTaskEventListener listener = new ExternalTaskEventListener();
        LocalHTWorkItemHandler humanTaskHandler = new LocalHTWorkItemHandler();
        humanTaskHandler.setRuntimeManager(((RuntimeEngineImpl)runtime).getManager());
        if (runtime.getTaskService() instanceof EventService) {
            ((EventService)runtime.getTaskService()).registerTaskEventListener((Object)listener);
        }
        if (runtime instanceof Disposable) {
            ((Disposable)runtime).addDisposeListener(new DisposeListener(){

                public void onDispose(RuntimeEngine runtime) {
                    if (runtime.getTaskService() instanceof EventService) {
                        ((EventService)runtime.getTaskService()).clearTaskEventListeners();
                    }
                }
            });
        }
        return humanTaskHandler;
    }

    public AuditEventBuilder getAuditBuilder() {
        return this.auditBuilder;
    }

    public AuditEventBuilder getAuditBuilder(RuntimeEngine engine) {
        if (this.auditBuilder != null && this.auditBuilder instanceof ManagedAuditEventBuilderImpl) {
            String identifier = ((RuntimeEngineImpl)engine).getManager().getIdentifier();
            ((ManagedAuditEventBuilderImpl)this.auditBuilder).setOwnerId(identifier);
        }
        return this.auditBuilder;
    }

    public void setAuditBuilder(AuditEventBuilder auditBuilder) {
        this.auditBuilder = auditBuilder;
    }
}

