/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.lang.reflect.UndeclaredThrowableException;

final class SynchronousHolder<T, X extends Exception> {
    private final Class<X> throwType;
    private T held;
    private Throwable problem;
    private boolean set = false;

    SynchronousHolder(Class<X> type) {
        this.throwType = type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T get() throws X {
        boolean intr = false;
        try {
            SynchronousHolder synchronousHolder = this;
            synchronized (synchronousHolder) {
                while (true) {
                    if (this.problem != null) {
                        try {
                            throw this.problem;
                        }
                        catch (RuntimeException e2) {
                            throw e2;
                        }
                        catch (Exception e3) {
                            throw (Exception)this.throwType.cast(e3);
                        }
                        catch (Error e4) {
                            throw e4;
                        }
                        catch (Throwable e522) {
                            throw new UndeclaredThrowableException(e522);
                        }
                    }
                    if (this.set) {
                        T e522 = this.held;
                        return e522;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e6) {
                        intr = true;
                    }
                }
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T value) {
        SynchronousHolder synchronousHolder = this;
        synchronized (synchronousHolder) {
            this.held = value;
            this.set = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProblem(X problem) {
        SynchronousHolder synchronousHolder = this;
        synchronized (synchronousHolder) {
            this.problem = (Throwable)this.throwType.cast(problem);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProblem(RuntimeException problem) {
        SynchronousHolder synchronousHolder = this;
        synchronized (synchronousHolder) {
            this.problem = problem;
            this.notify();
        }
    }
}

