/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.channels.SocketAddressBuffer;
import org.xnio.channels.UnsupportedOptionException;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioXnio;
import org.xnio.nio.NioXnioWorker;
import org.xnio.nio.SelectorUtils;
import org.xnio.nio.WorkerThread;

class NioUdpChannel
implements MulticastMessageChannel {
    private static final Logger log = Logger.getLogger((String)"org.xnio.nio.udp.server.channel");
    private final NioXnioWorker worker;
    private final NioHandle<NioUdpChannel> readHandle;
    private final NioHandle<NioUdpChannel> writeHandle;
    private final ChannelListener.SimpleSetter<NioUdpChannel> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<NioUdpChannel> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<NioUdpChannel> closeSetter = new ChannelListener.SimpleSetter();
    private final DatagramChannel datagramChannel;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.BROADCAST).add(Options.RECEIVE_BUFFER).add(Options.SEND_BUFFER).add(Options.IP_TRAFFIC_CLASS).create();

    NioUdpChannel(NioXnioWorker worker, DatagramChannel datagramChannel) throws ClosedChannelException {
        this.worker = worker;
        WorkerThread readThread = worker.chooseOptional(false);
        WorkerThread writeThread = worker.chooseOptional(true);
        this.readHandle = readThread == null ? null : readThread.addChannel(datagramChannel, this, 0, this.readSetter);
        this.writeHandle = writeThread == null ? null : writeThread.addChannel(datagramChannel, this, 0, this.writeSetter);
        this.datagramChannel = datagramChannel;
    }

    public SocketAddress getLocalAddress() {
        return this.datagramChannel.socket().getLocalSocketAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)(type.isInstance(this.getLocalAddress()) ? (SocketAddress)type.cast(this.getLocalAddress()) : null);
    }

    public int receiveFrom(SocketAddressBuffer addressBuffer, ByteBuffer buffer) throws IOException {
        SocketAddress sourceAddress;
        int o = buffer.remaining();
        try {
            sourceAddress = this.datagramChannel.receive(buffer);
        }
        catch (ClosedChannelException e) {
            return -1;
        }
        if (sourceAddress == null) {
            return 0;
        }
        int t = o - buffer.remaining();
        if (addressBuffer != null) {
            addressBuffer.setSourceAddress(sourceAddress);
            addressBuffer.setDestinationAddress(null);
        }
        return t;
    }

    public long receiveFrom(SocketAddressBuffer addressBuffer, ByteBuffer[] buffers) throws IOException {
        return this.receiveFrom(addressBuffer, buffers, 0, buffers.length);
    }

    public long receiveFrom(SocketAddressBuffer addressBuffer, ByteBuffer[] buffers, int offs, int len) throws IOException {
        SocketAddress sourceAddress;
        if (len == 0) {
            return 0L;
        }
        if (len == 1) {
            return this.receiveFrom(addressBuffer, buffers[offs]);
        }
        int o = (int)Math.min(Buffers.remaining((Buffer[])buffers, (int)offs, (int)len), 65536L);
        ByteBuffer buffer = ByteBuffer.allocate(o);
        try {
            sourceAddress = this.datagramChannel.receive(buffer);
        }
        catch (ClosedChannelException e) {
            return -1L;
        }
        if (sourceAddress == null) {
            return 0L;
        }
        int t = o - buffer.remaining();
        buffer.flip();
        Buffers.copy((ByteBuffer[])buffers, (int)offs, (int)len, (ByteBuffer)buffer);
        if (addressBuffer != null) {
            addressBuffer.setSourceAddress(sourceAddress);
            addressBuffer.setDestinationAddress(null);
        }
        return t;
    }

    public boolean sendTo(SocketAddress target, ByteBuffer buffer) throws IOException {
        return this.datagramChannel.send(buffer, target) != 0;
    }

    public boolean sendTo(SocketAddress target, ByteBuffer[] buffers) throws IOException {
        return this.sendTo(target, buffers, 0, buffers.length);
    }

    public boolean sendTo(SocketAddress target, ByteBuffer[] buffers, int offset, int length) throws IOException {
        if (length == 0) {
            return false;
        }
        if (length == 1) {
            return this.sendTo(target, buffers[offset]);
        }
        long o = Buffers.remaining((Buffer[])buffers, (int)offset, (int)length);
        if (o > 65535L) {
            throw new IllegalArgumentException("Too may bytes written");
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)o);
        Buffers.copy((ByteBuffer)buffer, (ByteBuffer[])buffers, (int)offset, (int)length);
        buffer.flip();
        return this.datagramChannel.send(buffer, target) != 0;
    }

    public ChannelListener.Setter<NioUdpChannel> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<NioUdpChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<NioUdpChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public boolean flush() throws IOException {
        return true;
    }

    public boolean isOpen() {
        return this.datagramChannel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.callFlag.getAndSet(true)) {
            log.tracef("Closing %s", (Object)this);
            try {
                this.datagramChannel.close();
            }
            finally {
                this.cancelKeys();
                ChannelListeners.invokeChannelListener((Channel)((Object)this), (ChannelListener)this.closeSetter.get());
            }
        }
    }

    private void cancelKeys() {
        if (this.readHandle != null) {
            this.readHandle.cancelKey();
        }
        if (this.writeHandle != null) {
            this.writeHandle.cancelKey();
        }
    }

    public void suspendReads() {
        NioHandle<NioUdpChannel> handle = this.readHandle;
        if (handle != null) {
            try {
                handle.suspend();
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
    }

    public void suspendWrites() {
        NioHandle<NioUdpChannel> handle = this.writeHandle;
        if (handle != null) {
            try {
                handle.suspend();
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
    }

    public void resumeReads() {
        NioHandle<NioUdpChannel> handle = this.readHandle;
        if (handle == null) {
            throw new IllegalArgumentException("No read thread configured");
        }
        try {
            handle.resume(1);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeWrites() {
        NioHandle<NioUdpChannel> handle = this.writeHandle;
        if (handle == null) {
            throw new IllegalArgumentException("No read thread configured");
        }
        try {
            handle.resume(4);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public boolean isReadResumed() {
        NioHandle<NioUdpChannel> handle = this.readHandle;
        return handle != null && handle.isResumed(1);
    }

    public boolean isWriteResumed() {
        NioHandle<NioUdpChannel> handle = this.writeHandle;
        return handle != null && handle.isResumed(4);
    }

    public void wakeupReads() {
        this.resumeReads();
        NioHandle<NioUdpChannel> readHandle = this.readHandle;
        if (readHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        readHandle.execute();
    }

    public void wakeupWrites() {
        this.resumeWrites();
        NioHandle<NioUdpChannel> writeHandle = this.writeHandle;
        if (writeHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        writeHandle.execute();
    }

    public void shutdownReads() throws IOException {
        throw new UnsupportedOperationException("Shutdown reads");
    }

    public boolean shutdownWrites() throws IOException {
        throw new UnsupportedOperationException("Shutdown writes");
    }

    public void awaitReadable() throws IOException {
        SelectorUtils.await(this.worker.getXnio(), this.datagramChannel, 1);
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.worker.getXnio(), this.datagramChannel, 1, time, timeUnit);
    }

    public XnioExecutor getReadThread() {
        NioHandle<NioUdpChannel> handle = this.readHandle;
        return handle == null ? null : handle.getWorkerThread();
    }

    public void awaitWritable() throws IOException {
        SelectorUtils.await(this.worker.getXnio(), this.datagramChannel, 4);
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.worker.getXnio(), this.datagramChannel, 4, time, timeUnit);
    }

    public XnioExecutor getWriteThread() {
        NioHandle<NioUdpChannel> handle = this.writeHandle;
        return handle == null ? null : handle.getWorkerThread();
    }

    public MulticastMessageChannel.Key join(InetAddress group, NetworkInterface iface) throws IOException {
        return new NioKey(this.datagramChannel.join(group, iface));
    }

    public MulticastMessageChannel.Key join(InetAddress group, NetworkInterface iface, InetAddress source) throws IOException {
        return new NioKey(this.datagramChannel.join(group, iface, source));
    }

    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        DatagramChannel channel = this.datagramChannel;
        DatagramSocket socket = channel.socket();
        if (option == Options.RECEIVE_BUFFER) {
            return (T)option.cast((Object)socket.getReceiveBufferSize());
        }
        if (option == Options.SEND_BUFFER) {
            return (T)option.cast((Object)socket.getSendBufferSize());
        }
        if (option == Options.BROADCAST) {
            return (T)option.cast((Object)socket.getBroadcast());
        }
        if (option == Options.IP_TRAFFIC_CLASS) {
            return (T)option.cast((Object)socket.getTrafficClass());
        }
        if (NioXnio.NIO2) {
            if (option == Options.MULTICAST_TTL) {
                return (T)option.cast((Object)channel.getOption(StandardSocketOptions.IP_MULTICAST_TTL));
            }
            return null;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        Object old;
        DatagramChannel channel = this.datagramChannel;
        DatagramSocket socket = channel.socket();
        if (option == Options.RECEIVE_BUFFER) {
            old = socket.getReceiveBufferSize();
            socket.setReceiveBufferSize((Integer)value);
            return (T)option.cast(old);
        } else if (option == Options.SEND_BUFFER) {
            old = socket.getSendBufferSize();
            socket.setSendBufferSize((Integer)value);
            return (T)option.cast(old);
        } else if (option == Options.IP_TRAFFIC_CLASS) {
            old = socket.getTrafficClass();
            socket.setTrafficClass((Integer)value);
            return (T)option.cast(old);
        } else if (option == Options.BROADCAST) {
            old = socket.getBroadcast();
            socket.setBroadcast((Boolean)value);
            return (T)option.cast(old);
        } else {
            if (!NioXnio.NIO2) return null;
            if (option != Options.MULTICAST_TTL) return null;
            old = option.cast((Object)channel.getOption(StandardSocketOptions.IP_MULTICAST_TTL));
            channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Integer)value);
        }
        return (T)option.cast(old);
    }

    public String toString() {
        return String.format("UDP socket channel (NIO) <%h>", this);
    }

    public XnioWorker getWorker() {
        return this.worker;
    }

    class NioKey
    implements MulticastMessageChannel.Key {
        private final MembershipKey key;

        NioKey(MembershipKey key) {
            this.key = key;
        }

        public MulticastMessageChannel.Key block(InetAddress source) throws IOException, UnsupportedOperationException, IllegalStateException, IllegalArgumentException {
            this.key.block(source);
            return this;
        }

        public MulticastMessageChannel.Key unblock(InetAddress source) throws IOException, IllegalStateException, UnsupportedOperationException {
            this.key.unblock(source);
            return this;
        }

        public MulticastMessageChannel getChannel() {
            return NioUdpChannel.this;
        }

        public InetAddress getGroup() {
            return this.key.group();
        }

        public NetworkInterface getNetworkInterface() {
            return this.key.networkInterface();
        }

        public InetAddress getSourceAddress() {
            return this.key.sourceAddress();
        }

        public boolean isOpen() {
            return this.key.isValid();
        }

        public void close() throws IOException {
            this.key.drop();
        }
    }
}

