/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.injection;

import java.util.ResourceBundle;
import org.jboss.ws.api.util.BundleUtils;

public final class InjectionMetaData {
    private static final ResourceBundle bundle = BundleUtils.getBundle(InjectionMetaData.class);
    private final String targetClass;
    private final String targetName;
    private final Class<?> valueClass;
    private final String envEntryName;
    private final boolean isValueSpecified;
    private String toString;

    public InjectionMetaData(String targetClass, String targetName, String valueClass, String envEntryName, boolean isValueSpecified) {
        if (targetClass == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"TARGETCLASS_NOT_SPECIFIED", (Object[])new Object[0]));
        }
        if (targetName == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"TARGETNAME_NOT_SPECIFIED", (Object[])new Object[0]));
        }
        if (envEntryName == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ENVENTRYNAME_NOT_SPECIFIED", (Object[])new Object[0]));
        }
        this.targetClass = targetClass;
        this.targetName = targetName;
        this.envEntryName = envEntryName;
        this.valueClass = this.valueOf(valueClass);
        this.isValueSpecified = isValueSpecified;
    }

    private Class<?> valueOf(String s) {
        if (s == null || s.trim().equals("")) {
            return null;
        }
        if (Boolean.class.getName().equals(s)) {
            return Boolean.class;
        }
        if (Byte.class.getName().equals(s)) {
            return Byte.class;
        }
        if (Character.class.getName().equals(s)) {
            return Character.class;
        }
        if (String.class.getName().equals(s)) {
            return String.class;
        }
        if (Short.class.getName().equals(s)) {
            return Short.class;
        }
        if (Integer.class.getName().equals(s)) {
            return Integer.class;
        }
        if (Long.class.getName().equals(s)) {
            return Long.class;
        }
        if (Float.class.getName().equals(s)) {
            return Float.class;
        }
        if (Double.class.getName().equals(s)) {
            return Double.class;
        }
        throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_ENV_ENTRY_TYPE", (Object[])new Object[]{s}));
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public String getEnvEntryName() {
        return this.envEntryName;
    }

    public boolean isEnvEntryValueSpecified() {
        return this.isValueSpecified;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append('\n').append(this.getClass().getName()).append('@').append(this.hashCode());
            sb.append("\n{\n").append("   targetClass=").append(this.targetClass).append(",\n");
            sb.append("   targetName=").append(this.targetName).append(",\n");
            sb.append("   envEntryName=").append(this.envEntryName).append(",\n");
            sb.append("   envEntryType=").append(this.valueClass).append(",\n");
            sb.append("   performInjection=").append(this.isValueSpecified).append("\n}");
            this.toString = sb.toString();
        }
        return this.toString;
    }
}

