/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.Container;
import org.jboss.weld.context.ForwardingContextual;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;

public class SerializableContextualFactory {
    private SerializableContextualFactory() {
    }

    public static <C extends Contextual<I>, I> SerializableContextual<C, I> create(C contextual, ContextualStore contextualStore) {
        if (contextual instanceof PassivationCapable) {
            return new PassivationCapableSerializableContextual(contextual, contextualStore);
        }
        return new DefaultSerializableContextual(contextual, contextualStore);
    }

    private static class PassivationCapableSerializableContextual<C extends Contextual<I> & PassivationCapable, I>
    extends AbstractSerializableContextual<C, I>
    implements PassivationCapable {
        private static final long serialVersionUID = -2753893863961869301L;

        public PassivationCapableSerializableContextual(C contextual, ContextualStore contextualStore) {
            super(contextual, contextualStore);
        }

        @Override
        protected String getId(C contextual, ContextualStore contextualStore) {
            return ((PassivationCapable)contextual).getId();
        }

        @Override
        public String getId() {
            return ((PassivationCapable)this.get()).getId();
        }
    }

    private static class DefaultSerializableContextual<C extends Contextual<I>, I>
    extends AbstractSerializableContextual<C, I> {
        private static final long serialVersionUID = -5102624795925717767L;

        public DefaultSerializableContextual(C contextual, ContextualStore contextualStore) {
            super(contextual, contextualStore);
        }

        @Override
        protected String getId(C contextual, ContextualStore contextualStore) {
            return contextualStore.putIfAbsent((Contextual<?>)contextual);
        }
    }

    private static abstract class AbstractSerializableContextual<C extends Contextual<I>, I>
    extends ForwardingContextual<I>
    implements SerializableContextual<C, I> {
        private static final long serialVersionUID = 107855630671709443L;
        private C serialiazable;
        @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="A cache which is lazily loaded")
        private transient C cached;
        private String id;
        private transient ContextualStore cachedContextualStore;

        @Override
        protected Contextual<I> delegate() {
            return this.get();
        }

        public AbstractSerializableContextual(C contextual, ContextualStore contextualStore) {
            this.cachedContextualStore = contextualStore;
            if (contextual instanceof Serializable) {
                this.serialiazable = contextual;
            } else {
                this.id = this.getId(contextual, contextualStore);
            }
            this.cached = contextual;
        }

        protected abstract String getId(C var1, ContextualStore var2);

        private ContextualStore getContextualStore() {
            if (this.cachedContextualStore == null) {
                this.cachedContextualStore = Container.instance().services().get(ContextualStore.class);
            }
            return this.cachedContextualStore;
        }

        @Override
        public C get() {
            if (this.cached == null) {
                this.loadContextual();
            }
            return this.cached;
        }

        private void loadContextual() {
            if (this.serialiazable != null) {
                this.cached = this.serialiazable;
            } else if (this.id != null) {
                this.cached = this.getContextualStore().getContextual(this.id);
            }
            if (this.cached == null) {
                throw new IllegalStateException("Error restoring serialized contextual with id " + this.id);
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof AbstractSerializableContextual) {
                return this.delegate().equals(((AbstractSerializableContextual)obj).get());
            }
            return this.delegate().equals(obj);
        }

        @Override
        public int hashCode() {
            return this.delegate().hashCode();
        }
    }
}

