/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.auth;

import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityUtil;
import org.jboss.security.SubjectSecurityManager;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.plugins.auth.JaasSecurityManagerBase;
import org.jboss.security.plugins.auth.SubjectActions;
import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedJaasSecurityManager
implements SubjectSecurityManager,
RealmMapping {
    private String securityDomain;
    private CachePolicy domainCache;
    private CallbackHandler handler;
    private transient Method setSecurityInfo;
    private boolean deepCopySubjectOption = false;
    protected Logger log;
    protected boolean trace;

    public SynchronizedJaasSecurityManager() {
        this("other", new JBossCallbackHandler());
    }

    public SynchronizedJaasSecurityManager(String securityDomain, CallbackHandler handler) {
        this.securityDomain = securityDomain;
        this.handler = handler;
        String categoryName = this.getClass().getName() + '.' + securityDomain;
        this.log = Logger.getLogger((String)categoryName);
        this.trace = this.log.isTraceEnabled();
        Class[] sig = new Class[]{Principal.class, Object.class};
        try {
            this.setSecurityInfo = handler.getClass().getMethod("setSecurityInfo", sig);
        }
        catch (Exception e) {
            String msg = "Failed to find setSecurityInfo(Princpal, Object) method in handler";
            throw new UndeclaredThrowableException(e, msg);
        }
        this.log.debug((Object)("CallbackHandler: " + handler));
    }

    public void setCachePolicy(CachePolicy domainCache) {
        this.domainCache = domainCache;
        this.log.debug((Object)("CachePolicy set to: " + domainCache));
    }

    public void setDeepCopySubjectOption(Boolean flag) {
        this.log.debug((Object)("setDeepCopySubjectOption=" + flag));
        this.deepCopySubjectOption = flag == Boolean.TRUE;
    }

    public void flushCache() {
        if (this.domainCache != null) {
            this.domainCache.flush();
        }
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public Subject getActiveSubject() {
        Subject subj = null;
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        if (sc != null) {
            subj = sc.getUtil().getSubject();
        }
        return subj;
    }

    public boolean isValid(Principal principal, Object credential) {
        return this.isValid(principal, credential, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(Principal principal, Object credential, Subject activeSubject) {
        JaasSecurityManagerBase.DomainInfo cacheInfo = this.getCacheInfo(principal, true);
        if (this.trace) {
            this.log.trace((Object)("Begin isValid, principal:" + principal + ", cache info: " + cacheInfo));
        }
        boolean isValid = false;
        if (principal != null && principal.getName() != null) {
            String string = principal.getName().intern();
            synchronized (string) {
                if (cacheInfo != null) {
                    isValid = this.validateCache(cacheInfo, credential, activeSubject);
                    cacheInfo.release();
                }
                if (!isValid) {
                    isValid = this.authenticate(principal, credential, activeSubject);
                }
            }
        } else {
            if (cacheInfo != null) {
                cacheInfo.release();
            }
            isValid = this.authenticate(principal, credential, activeSubject);
        }
        if (this.trace) {
            this.log.trace((Object)("End isValid, " + isValid));
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal getPrincipal(Principal principal) {
        if (this.domainCache == null) {
            return principal;
        }
        Principal result = principal;
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            JaasSecurityManagerBase.DomainInfo info = this.getCacheInfo(principal, false);
            if (this.trace) {
                this.log.trace((Object)("getPrincipal, cache info: " + info));
            }
            if (info != null) {
                result = info.callerPrincipal;
                if (result == null) {
                    result = principal;
                }
                info.release();
            }
        }
        return result;
    }

    public boolean doesUserHaveRole(Principal principal, Set<Principal> rolePrincipals) {
        AuthorizationManager am = SecurityUtil.getAuthorizationManager(this.securityDomain, "java:/jaas");
        return am.doesUserHaveRole(principal, rolePrincipals);
    }

    public Set<Principal> getUserRoles(Principal principal) {
        AuthorizationManager am = SecurityUtil.getAuthorizationManager(this.securityDomain, "java:/jaas");
        return am.getUserRoles(principal);
    }

    public Principal getTargetPrincipal(Principal anotherDomainPrincipal, Map<String, Object> contextMap) {
        throw new RuntimeException("Not implemented yet");
    }

    private boolean authenticate(Principal principal, Object credential, Subject theSubject) {
        Subject subject = null;
        boolean authenticated = false;
        LoginException authException = null;
        try {
            LoginContext lc = this.defaultLogin(principal, credential);
            subject = lc.getSubject();
            if (subject != null) {
                if (theSubject != null) {
                    SubjectActions.copySubject(subject, theSubject, false, this.deepCopySubjectOption);
                } else {
                    theSubject = subject;
                }
                authenticated = true;
                this.updateCache(lc, subject, principal, credential);
            }
        }
        catch (LoginException e) {
            if (principal != null && principal.getName() != null || this.trace) {
                this.log.trace((Object)"Login failure", (Throwable)e);
            }
            authException = e;
        }
        SubjectActions.setContextInfo("org.jboss.security.exception", authException);
        return authenticated;
    }

    private LoginContext defaultLogin(Principal principal, Object credential) throws LoginException {
        Object[] securityInfo = new Object[]{principal, credential};
        CallbackHandler theHandler = null;
        try {
            theHandler = (CallbackHandler)this.handler.getClass().newInstance();
            this.setSecurityInfo.invoke((Object)theHandler, securityInfo);
        }
        catch (Throwable e) {
            if (this.trace) {
                this.log.trace((Object)"Failed to create/setSecurityInfo on handler", e);
            }
            LoginException le = new LoginException("Failed to setSecurityInfo on handler");
            le.initCause(e);
            throw le;
        }
        Subject subject = new Subject();
        LoginContext lc = null;
        if (this.trace) {
            this.log.trace((Object)("defaultLogin, principal=" + principal));
        }
        lc = SubjectActions.createLoginContext(this.securityDomain, subject, theHandler);
        lc.login();
        if (this.trace) {
            this.log.trace((Object)("defaultLogin, lc=" + lc + ", subject=" + SubjectActions.toString(subject)));
        }
        return lc;
    }

    private boolean validateCache(JaasSecurityManagerBase.DomainInfo info, Object credential, Subject theSubject) {
        if (this.trace) {
            StringBuffer tmp = new StringBuffer("Begin validateCache, info=");
            tmp.append(info.toString());
            tmp.append(";credential.class=");
            if (credential != null) {
                Class<?> c = credential.getClass();
                tmp.append(c.getName());
                tmp.append('@');
                tmp.append(System.identityHashCode(c));
            } else {
                tmp.append("null");
            }
            this.log.trace((Object)tmp.toString());
        }
        Object subjectCredential = info.credential;
        boolean isValid = false;
        if (credential == null || subjectCredential == null) {
            isValid = credential == null && subjectCredential == null;
        } else if (subjectCredential.getClass().isAssignableFrom(credential.getClass())) {
            if (subjectCredential instanceof Comparable) {
                Comparable c = (Comparable)subjectCredential;
                isValid = c.compareTo(credential) == 0;
            } else if (subjectCredential instanceof char[]) {
                char[] a1 = (char[])subjectCredential;
                char[] a2 = (char[])credential;
                isValid = Arrays.equals(a1, a2);
            } else if (subjectCredential instanceof byte[]) {
                byte[] a1 = (byte[])subjectCredential;
                byte[] a2 = (byte[])credential;
                isValid = Arrays.equals(a1, a2);
            } else if (subjectCredential.getClass().isArray()) {
                Object[] a1 = (Object[])subjectCredential;
                Object[] a2 = (Object[])credential;
                isValid = Arrays.equals(a1, a2);
            } else {
                isValid = subjectCredential.equals(credential);
            }
        } else if (subjectCredential instanceof char[] && credential instanceof String) {
            char[] a1 = (char[])subjectCredential;
            char[] a2 = ((String)credential).toCharArray();
            isValid = Arrays.equals(a1, a2);
        } else if (subjectCredential instanceof String && credential instanceof char[]) {
            char[] a1 = ((String)subjectCredential).toCharArray();
            char[] a2 = (char[])credential;
            isValid = Arrays.equals(a1, a2);
        }
        if (isValid && theSubject != null) {
            SubjectActions.copySubject(info.subject, theSubject, false, this.deepCopySubjectOption);
        }
        if (this.trace) {
            this.log.trace((Object)("End validateCache, isValid=" + isValid));
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JaasSecurityManagerBase.DomainInfo getCacheInfo(Principal principal, boolean allowRefresh) {
        if (this.domainCache == null) {
            return null;
        }
        JaasSecurityManagerBase.DomainInfo cacheInfo = null;
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            cacheInfo = allowRefresh ? (JaasSecurityManagerBase.DomainInfo)this.domainCache.get((Object)principal) : (JaasSecurityManagerBase.DomainInfo)this.domainCache.peek((Object)principal);
            if (cacheInfo != null) {
                cacheInfo.acquire();
            }
        }
        return cacheInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subject updateCache(LoginContext lc, Subject subject, Principal principal, Object credential) {
        if (this.domainCache == null) {
            return subject;
        }
        long lifetime = 0L;
        if (this.domainCache instanceof TimedCachePolicy) {
            TimedCachePolicy cache = (TimedCachePolicy)this.domainCache;
            lifetime = cache.getDefaultLifetime();
        }
        JaasSecurityManagerBase.DomainInfo info = new JaasSecurityManagerBase.DomainInfo(lifetime);
        info.loginCtx = lc;
        info.subject = new Subject();
        SubjectActions.copySubject(subject, info.subject, true, this.deepCopySubjectOption);
        info.credential = credential;
        if (this.trace) {
            this.log.trace((Object)("updateCache, inputSubject=" + SubjectActions.toString(subject) + ", cacheSubject=" + SubjectActions.toString(info.subject)));
        }
        Set<Group> subjectGroups = subject.getPrincipals(Group.class);
        for (Group grp : subjectGroups) {
            Enumeration members;
            String name = grp.getName();
            if (!name.equals("CallerPrincipal") || !(members = grp.members()).hasMoreElements()) continue;
            info.callerPrincipal = (Principal)members.nextElement();
        }
        if (principal == null && info.callerPrincipal == null) {
            Set<Principal> subjectPrincipals = subject.getPrincipals(Principal.class);
            for (Principal p : subjectPrincipals) {
                if (p instanceof Group) continue;
                info.callerPrincipal = p;
            }
        }
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            if (this.domainCache.peek((Object)principal) != null) {
                this.domainCache.remove((Object)principal);
            }
            this.domainCache.insert((Object)principal, (Object)info);
            if (this.trace) {
                this.log.trace((Object)("Inserted cache info: " + info));
            }
        }
        return info.subject;
    }
}

