/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.web;

import com.sun.xacml.Policy;
import com.sun.xacml.ctx.RequestCtx;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import org.jboss.logging.Logger;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
import org.jboss.security.authorization.modules.web.WebXACMLUtil;
import org.jboss.security.authorization.resources.WebResource;
import org.jboss.security.authorization.sunxacml.JBossXACMLUtil;
import org.jboss.security.identity.RoleGroup;

public class WebXACMLPolicyModuleDelegate
extends AuthorizationModuleDelegate {
    public WebXACMLPolicyModuleDelegate() {
        log = Logger.getLogger(this.getClass());
        this.trace = log.isTraceEnabled();
    }

    public int authorize(Resource resource, Subject subject, RoleGroup role) {
        if (!(resource instanceof WebResource)) {
            throw new IllegalArgumentException("resource is not a WebResource");
        }
        WebResource webResource = (WebResource)resource;
        Map map = resource.getMap();
        if (map == null) {
            throw new IllegalStateException("Map from the Resource is null");
        }
        if (map.size() == 0) {
            throw new IllegalStateException("Map from the Resource is size zero");
        }
        HttpServletRequest request = (HttpServletRequest)webResource.getServletRequest();
        this.policyRegistration = (PolicyRegistration)map.get("policyRegistration");
        if (this.policyRegistration == null) {
            throw new IllegalStateException("PolicyRegistration passed is null");
        }
        Boolean userDataCheck = this.checkBooleanValue((Boolean)map.get("userDataPermissionCheck"));
        Boolean roleRefCheck = this.checkBooleanValue((Boolean)map.get("roleRefPermissionCheck"));
        if (userDataCheck.booleanValue() || roleRefCheck.booleanValue()) {
            return 1;
        }
        if (request == null) {
            throw new IllegalStateException("Request is null");
        }
        return this.process(request, role);
    }

    private Boolean checkBooleanValue(Boolean bool) {
        if (bool == null) {
            return Boolean.FALSE;
        }
        return bool;
    }

    private int process(HttpServletRequest request, RoleGroup callerRoles) {
        Principal userP = request.getUserPrincipal();
        if (userP == null) {
            throw new IllegalStateException("User Principal is null");
        }
        int result = -1;
        WebXACMLUtil util = new WebXACMLUtil();
        try {
            RequestCtx requestCtx = util.createXACMLRequest(request, callerRoles);
            String contextID = PolicyContext.getContextID();
            Policy policy = (Policy)this.policyRegistration.getPolicy(contextID, null);
            if (policy == null) {
                throw new IllegalStateException("Missing xacml policy for contextid:" + contextID);
            }
            result = JBossXACMLUtil.checkXACMLAuthorization(requestCtx, policy);
        }
        catch (Exception e) {
            if (this.trace) {
                log.trace((Object)"Exception in processing:", (Throwable)e);
            }
            result = -1;
        }
        return result;
    }
}

