/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.security.auth.spi.SecurityActions;

public class ProxyLoginModule
implements LoginModule {
    private String moduleName;
    private LoginModule delegate;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.moduleName = (String)options.get("moduleName");
        if (this.moduleName == null) {
            System.out.println("Required moduleName option not given");
            return;
        }
        ClassLoader loader = SecurityActions.getContextClassLoader();
        try {
            Class<?> clazz = loader.loadClass(this.moduleName);
            this.delegate = (LoginModule)clazz.newInstance();
        }
        catch (Throwable t) {
            System.out.println("ProxyLoginModule failed to load: " + this.moduleName);
            t.printStackTrace();
            return;
        }
        this.delegate.initialize(subject, callbackHandler, sharedState, options);
    }

    public boolean login() throws LoginException {
        if (this.moduleName == null) {
            throw new LoginException("Required moduleName option not given");
        }
        if (this.delegate == null) {
            throw new LoginException("Failed to load LoginModule: " + this.moduleName);
        }
        return this.delegate.login();
    }

    public boolean commit() throws LoginException {
        boolean ok = false;
        if (this.delegate != null) {
            ok = this.delegate.commit();
        }
        return ok;
    }

    public boolean abort() throws LoginException {
        boolean ok = true;
        if (this.delegate != null) {
            ok = this.delegate.abort();
        }
        return ok;
    }

    public boolean logout() throws LoginException {
        boolean ok = true;
        if (this.delegate != null) {
            ok = this.delegate.logout();
        }
        return ok;
    }
}

