/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.message.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.auth.message.module.ServerAuthModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossServerAuthContext
implements ServerAuthContext {
    private List<ServerAuthModule> modules = new ArrayList<ServerAuthModule>();
    private Map<String, Map> moduleOptionsByName = new HashMap<String, Map>();

    public JBossServerAuthContext(List<ServerAuthModule> modules, Map<String, Map> moduleNameToOptions, CallbackHandler cbh) throws AuthException {
        this.modules = modules;
        this.moduleOptionsByName = moduleNameToOptions;
        for (ServerAuthModule sam : modules) {
            sam.initialize(null, null, cbh, this.moduleOptionsByName.get(sam.getClass().getName()));
        }
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        for (ServerAuthModule sam : this.modules) {
            sam.cleanSubject(messageInfo, subject);
        }
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        AuthStatus status = null;
        for (ServerAuthModule sam : this.modules) {
            status = sam.secureResponse(messageInfo, serviceSubject);
        }
        return status;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        ServerAuthModule sam2;
        ArrayList<ServerAuthModule> supportingModules = new ArrayList<ServerAuthModule>();
        Class<?> requestType = messageInfo.getRequestMessage().getClass();
        Class<?>[] requestInterfaces = requestType.getInterfaces();
        List<Class<?>> intfaee = Arrays.asList(requestInterfaces);
        AuthStatus status = null;
        for (ServerAuthModule sam2 : this.modules) {
            List<Class> supportedTypes = Arrays.asList(sam2.getSupportedMessageTypes());
            for (Class<?> clazz : intfaee) {
                if (!supportedTypes.contains(clazz) || supportingModules.contains(sam2)) continue;
                supportingModules.add(sam2);
            }
            if (!supportedTypes.contains(requestType) || supportingModules.contains(sam2)) continue;
            supportingModules.add(sam2);
        }
        if (supportingModules.size() == 0) {
            throw new RuntimeException("No ServerAuthModule configured to support type:" + requestType);
        }
        Iterator<Object> i$ = supportingModules.iterator();
        while (i$.hasNext() && (status = (sam2 = (ServerAuthModule)i$.next()).validateRequest(messageInfo, clientSubject, serviceSubject)) != AuthStatus.FAILURE) {
        }
        return status;
    }
}

