/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.cache;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeCacheFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.cache.AbstractInfinispanCacheProvider;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Reflections;

@Name(value="org.jboss.seam.cache.cacheProvider")
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Install(value=false, precedence=0, classDependencies={"org.infinispan.tree.TreeCache", "org.jgroups.MembershipListener"})
@AutoCreate
public class InfinispanCacheProvider
extends AbstractInfinispanCacheProvider<TreeCache<Object, Object>> {
    private TreeCache cache;
    private static final LogProvider log = Logging.getLogProvider(InfinispanCacheProvider.class);
    private static Method GET;
    private static Method PUT;
    private static Method REMOVE;
    private static Method REMOVE_NODE;

    @Create
    public void create() {
        log.debug("Starting Infinispan Cache");
        try {
            DefaultCacheManager manager = new DefaultCacheManager(this.getConfigurationAsStream());
            Cache defaultCache = manager.getCache();
            this.cache = new TreeCacheFactory().createTreeCache(defaultCache);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting Infinispan Cache", e);
        }
    }

    @Destroy
    public void destroy() {
        log.debug("Stopping Infinispan Cache");
        try {
            this.cache.stop();
            this.cache = null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error stopping Infinispan Cache", e);
        }
    }

    @Override
    public Object get(String region, String key) {
        return Reflections.invokeAndWrap(GET, this.cache, this.getFqn(region), key);
    }

    @Override
    public void put(String region, String key, Object object) {
        Reflections.invokeAndWrap(PUT, this.cache, this.getFqn(region), key, object);
    }

    @Override
    public void remove(String region, String key) {
        Reflections.invokeAndWrap(REMOVE, this.cache, this.getFqn(region), key);
    }

    @Override
    public void clear() {
        Reflections.invokeAndWrap(REMOVE_NODE, this.cache, this.getFqn(null));
    }

    @Override
    public TreeCache getDelegate() {
        return this.cache;
    }

    static {
        try {
            GET = TreeCache.class.getDeclaredMethod("get", Fqn.class, Object.class);
            PUT = TreeCache.class.getDeclaredMethod("put", Fqn.class, Object.class, Object.class);
            REMOVE = TreeCache.class.getDeclaredMethod("remove", Fqn.class, Object.class);
            REMOVE_NODE = TreeCache.class.getDeclaredMethod("removeNode", Fqn.class);
        }
        catch (Exception e) {
            log.error(e);
            throw new IllegalStateException("Unable to use Infinispan Cache", e);
        }
    }
}

