/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;

public enum ScopeType {
    STATELESS,
    METHOD,
    EVENT,
    PAGE,
    CONVERSATION,
    SESSION,
    APPLICATION,
    BUSINESS_PROCESS,
    UNSPECIFIED;

    private final String prefix = "org.jboss.seam." + this.toString();

    public boolean isContextActive() {
        switch (this) {
            case STATELESS: {
                return true;
            }
            case METHOD: {
                return Contexts.isMethodContextActive();
            }
            case EVENT: {
                return Contexts.isEventContextActive();
            }
            case PAGE: {
                return Contexts.isPageContextActive();
            }
            case CONVERSATION: {
                return Contexts.isConversationContextActive();
            }
            case SESSION: {
                return Contexts.isSessionContextActive();
            }
            case APPLICATION: {
                return Contexts.isApplicationContextActive();
            }
            case BUSINESS_PROCESS: {
                return Contexts.isBusinessProcessContextActive();
            }
        }
        throw new IllegalArgumentException();
    }

    public Context getContext() {
        switch (this) {
            case STATELESS: {
                throw new UnsupportedOperationException("Stateless pseudo-scope does not have a Context object");
            }
            case METHOD: {
                if (!Contexts.isMethodContextActive()) {
                    throw new IllegalStateException("No method context active");
                }
                return Contexts.getMethodContext();
            }
            case EVENT: {
                if (!Contexts.isEventContextActive()) {
                    throw new IllegalStateException("No event context active");
                }
                return Contexts.getEventContext();
            }
            case PAGE: {
                if (!Contexts.isPageContextActive()) {
                    throw new IllegalStateException("No page context active");
                }
                return Contexts.getPageContext();
            }
            case CONVERSATION: {
                if (!Contexts.isConversationContextActive()) {
                    throw new IllegalStateException("No conversation context active");
                }
                return Contexts.getConversationContext();
            }
            case SESSION: {
                if (!Contexts.isSessionContextActive()) {
                    throw new IllegalStateException("No session context active");
                }
                return Contexts.getSessionContext();
            }
            case APPLICATION: {
                if (!Contexts.isApplicationContextActive()) {
                    throw new IllegalStateException("No application context active");
                }
                return Contexts.getApplicationContext();
            }
            case BUSINESS_PROCESS: {
                if (!Contexts.isBusinessProcessContextActive()) {
                    throw new IllegalStateException("No process context active");
                }
                return Contexts.getBusinessProcessContext();
            }
        }
        throw new IllegalArgumentException();
    }

    public String getPrefix() {
        return this.prefix;
    }
}

