/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins.helpers;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.scanning.plugins.helpers.ResourceOwnerFinder;

public class CachingResourceOwnerFinder
implements ResourceOwnerFinder {
    private Map<File, URL> cache = new HashMap<File, URL>();

    public void cleanup() {
        this.cache.clear();
    }

    public URL findOwnerURL(ResourceContext resource) {
        try {
            URL url = resource.getUrl();
            URLConnection conn = url.openConnection();
            if (conn instanceof JarURLConnection) {
                JarURLConnection jarConn = (JarURLConnection)url.openConnection();
                return jarConn.getJarFileURL();
            }
            File file = new File(url.getPath());
            if (file.exists()) {
                return url;
            }
            url = this.cache.get(file);
            if (url != null) {
                return url;
            }
            ArrayList<File> files = new ArrayList<File>();
            files.add(file);
            file = file.getParentFile();
            while (!file.exists() && (url = this.cache.get(file)) == null) {
                files.add(file);
                if ((file = file.getParentFile()) != null) continue;
                throw new IllegalArgumentException("Cannot find physical file: " + resource.getUrl());
            }
            if (url == null) {
                url = file.toURI().toURL();
                files.add(file);
            }
            for (File f : files) {
                this.cache.put(f, url);
            }
            return url;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

