/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.validation;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import org.hibernate.validator.method.MethodConstraintViolation;

public class ViolationsContainer<T>
implements Serializable {
    private static final long serialVersionUID = -5048958457582876197L;
    private Set<ConstraintViolation<T>> fieldViolations = new HashSet<ConstraintViolation<T>>();
    private Set<ConstraintViolation<T>> propertyViolations = new HashSet<ConstraintViolation<T>>();
    private Set<ConstraintViolation<T>> classViolations = new HashSet<ConstraintViolation<T>>();
    private Set<ConstraintViolation<T>> parameterViolations = new HashSet<ConstraintViolation<T>>();
    private Set<ConstraintViolation<T>> returnValueViolations = new HashSet<ConstraintViolation<T>>();

    public ViolationsContainer() {
    }

    public ViolationsContainer(Set<ConstraintViolation<T>> set) {
        this.addViolations(set);
    }

    public ViolationsContainer(String s) {
    }

    public void addViolations(Set<? extends ConstraintViolation<T>> set) {
        for (ConstraintViolation<T> violation : set) {
            switch (this.getConstraintType(violation)) {
                case FIELD: {
                    this.fieldViolations.add(violation);
                    break;
                }
                case PROPERTY: {
                    this.propertyViolations.add(violation);
                    break;
                }
                case CLASS: {
                    this.classViolations.add(violation);
                    break;
                }
                case PARAMETER: {
                    this.parameterViolations.add(violation);
                    break;
                }
                case RETURN_VALUE: {
                    this.returnValueViolations.add(violation);
                }
            }
        }
    }

    public void addFieldViolation(ConstraintViolation<T> v) {
        this.fieldViolations.add(v);
    }

    public void addPropertyViolation(ConstraintViolation<T> v) {
        this.propertyViolations.add(v);
    }

    public void addClassViolation(ConstraintViolation<T> v) {
        this.classViolations.add(v);
    }

    public void addParameterViolation(ConstraintViolation<T> v) {
        this.parameterViolations.add(v);
    }

    public void addReturnValueViolation(ConstraintViolation<T> v) {
        this.returnValueViolations.add(v);
    }

    public Set<ConstraintViolation<T>> getFieldViolations() {
        return this.fieldViolations;
    }

    public Set<ConstraintViolation<T>> getPropertyViolations() {
        return this.propertyViolations;
    }

    public Set<ConstraintViolation<T>> getClassViolations() {
        return this.classViolations;
    }

    public Set<ConstraintViolation<T>> getParameterViolations() {
        return this.parameterViolations;
    }

    public Set<ConstraintViolation<T>> getReturnValueViolations() {
        return this.returnValueViolations;
    }

    public int size() {
        return this.fieldViolations.size() + this.propertyViolations.size() + this.classViolations.size() + this.parameterViolations.size() + this.returnValueViolations.size();
    }

    public String toString() {
        StringBuffer sb = this.setToStringBuffer(this.fieldViolations);
        sb.append(this.setToStringBuffer(this.propertyViolations));
        sb.append(this.setToStringBuffer(this.classViolations));
        sb.append(this.setToStringBuffer(this.parameterViolations));
        sb.append(this.setToStringBuffer(this.returnValueViolations));
        return sb.toString();
    }

    private StringBuffer setToStringBuffer(Set<ConstraintViolation<T>> set) {
        StringBuffer sb = new StringBuffer();
        Iterator<ConstraintViolation<T>> it = set.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\r');
        }
        return sb;
    }

    private ConstraintType getConstraintType(ConstraintViolation<T> v) {
        if (v instanceof MethodConstraintViolation) {
            MethodConstraintViolation mv = (MethodConstraintViolation)MethodConstraintViolation.class.cast(v);
            return mv.getKind() == MethodConstraintViolation.Kind.PARAMETER ? ConstraintType.PARAMETER : ConstraintType.RETURN_VALUE;
        }
        Object o = v.getRootBean();
        Class<?> containingClass = v.getRootBeanClass();
        String fieldName = null;
        Field field = null;
        for (Path.Node node : v.getPropertyPath()) {
            fieldName = node.getName();
            if (fieldName == null) {
                return ConstraintType.CLASS;
            }
            try {
                o = this.unwrapCompoundObject(o, node);
                containingClass = o.getClass();
                field = this.getField(containingClass, fieldName);
                field.setAccessible(true);
                o = field.get(o);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Missing field", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to access " + fieldName, e);
            }
        }
        String getterName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            this.getMethod(containingClass, getterName);
            return ConstraintType.PROPERTY;
        }
        catch (NoSuchMethodException e) {
            return ConstraintType.FIELD;
        }
    }

    private Object unwrapCompoundObject(Object o, Path.Node node) {
        Class<?> clazz = o.getClass();
        if (Map.class.isAssignableFrom(clazz)) {
            o = ((Map)Map.class.cast(o)).get(node.getKey());
        } else if (Iterable.class.isAssignableFrom(clazz)) {
            o = ((List)List.class.cast(o)).get(node.getIndex());
        } else if (clazz.isArray()) {
            o = Array.get(o, node.getIndex());
        }
        return o;
    }

    private Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        while (field == null && (clazz = clazz.getSuperclass()) != null) {
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {}
        }
        if (field == null) {
            throw new NoSuchFieldException(fieldName);
        }
        return field;
    }

    private Method getMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        while (method == null && (clazz = clazz.getSuperclass()) != null) {
            try {
                method = clazz.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {}
        }
        if (method == null) {
            throw new NoSuchMethodException(methodName);
        }
        return method;
    }

    private static enum ConstraintType {
        CLASS,
        FIELD,
        PROPERTY,
        PARAMETER,
        RETURN_VALUE;

    }
}

