/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors.encoding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Configurable;
import org.jboss.resteasy.annotations.ContentEncoding;
import org.jboss.resteasy.plugins.interceptors.encoding.ClientContentEncodingAnnotationFilter;

@ConstrainedTo(value=ConstrainedTo.Type.SERVER)
public class ClientContentEncodingAnnotationFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, Configurable configurable) {
        Class declaring = resourceInfo.getResourceClass();
        Method method = resourceInfo.getResourceMethod();
        if (declaring == null || method == null) {
            return;
        }
        for (Annotation[] annotations : method.getParameterAnnotations()) {
            String encoding = this.getEncoding(annotations);
            if (encoding == null) continue;
            configurable.register((Object)new ClientContentEncodingAnnotationFilter(encoding));
            return;
        }
    }

    protected String getEncoding(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(ContentEncoding.class)) continue;
            return annotation.annotationType().getAnnotation(ContentEncoding.class).value();
        }
        return null;
    }
}

