/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors;

import java.io.IOException;
import javax.ws.rs.BindingPriority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.spi.ForbiddenException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@BindingPriority(value=3000)
public class RoleBasedSecurityFilter
implements ContainerRequestFilter {
    protected String[] rolesAllowed;
    protected boolean denyAll;
    protected boolean permitAll;

    public RoleBasedSecurityFilter(String[] rolesAllowed, boolean denyAll, boolean permitAll) {
        this.rolesAllowed = rolesAllowed;
        this.denyAll = denyAll;
        this.permitAll = permitAll;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        SecurityContext context;
        if (this.denyAll) {
            throw new ForbiddenException();
        }
        if (this.permitAll) {
            return;
        }
        if (this.rolesAllowed != null && (context = ResteasyProviderFactory.getContextData(SecurityContext.class)) != null) {
            for (String role : this.rolesAllowed) {
                if (!context.isUserInRole(role)) continue;
                return;
            }
            throw new ForbiddenException();
        }
    }
}

