/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.registry;

import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.registry.RootSegment;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.util.Encode;

public class SimpleSegment
extends RootSegment {
    protected String segment;

    public SimpleSegment(String segment) {
        this.segment = segment;
    }

    public String getSegment() {
        return this.segment;
    }

    public ResourceInvoker matchSimple(HttpRequest request, String path, int start) {
        ResteasyUriInfo uriInfo = request.getUri();
        if (start + this.segment.length() == path.length()) {
            ResourceInvoker invoker = this.match(request.getHttpMethod(), request);
            if (invoker == null) {
                throw new NotFoundException("Could not find resource for relative : " + path + " of full path: " + request.getUri().getRequestUri());
            }
            uriInfo.pushMatchedURI(path, Encode.decode(path));
            return invoker;
        }
        try {
            return this.matchChildren(request, path, start + this.segment.length() + 1);
        }
        catch (Failure e) {
            if (this.locator != null) {
                String matched = path.substring(0, start + this.segment.length());
                uriInfo.pushMatchedURI(matched, Encode.decode(matched));
                return this.locator;
            }
            throw e;
        }
    }
}

