/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResumeCallback;
import javax.ws.rs.container.TimeoutHandler;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;

public abstract class AbstractAsynchronousResponse
implements ResteasyAsynchronousResponse {
    protected SynchronousDispatcher dispatcher;
    protected ResourceMethod method;
    protected HttpRequest request;
    protected HttpResponse response;
    protected ContainerResponseFilter[] responseFilters;
    protected WriterInterceptor[] writerInterceptors;
    protected Annotation[] annotations;
    protected TimeoutHandler timeoutHandler;
    protected List<ResumeCallback> resumeCallbacks = new ArrayList<ResumeCallback>();

    protected AbstractAsynchronousResponse(SynchronousDispatcher dispatcher, HttpRequest request, HttpResponse response) {
        this.dispatcher = dispatcher;
        this.request = request;
        this.response = response;
    }

    public boolean register(Class<?> callback) throws NullPointerException {
        if (callback == null) {
            throw new NullPointerException("Callback was null");
        }
        Object cb = this.dispatcher.getProviderFactory().createProviderInstance(callback);
        return this.register(cb);
    }

    public boolean register(Object callback) throws NullPointerException {
        if (callback == null) {
            throw new NullPointerException("Callback was null");
        }
        boolean registered = false;
        if (callback instanceof ResumeCallback) {
            registered = true;
            this.resumeCallbacks.add((ResumeCallback)callback);
        }
        return registered;
    }

    public boolean[] register(Class<?> callback, Class<?> ... callbacks) throws NullPointerException {
        boolean[] results = new boolean[1 + callbacks.length];
        results[0] = this.register(callback);
        for (int i = 0; i < callbacks.length; ++i) {
            results[i + 1] = this.register(callbacks[i]);
        }
        return results;
    }

    public boolean[] register(Object callback, Object ... callbacks) throws NullPointerException {
        boolean[] results = new boolean[1 + callbacks.length];
        results[0] = this.register(callback);
        for (int i = 0; i < callbacks.length; ++i) {
            results[i + 1] = this.register(callbacks[i]);
        }
        return results;
    }

    public void setTimeoutHandler(TimeoutHandler handler) {
        this.timeoutHandler = handler;
    }

    @Override
    public ResourceMethod getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(ResourceMethod method) {
        this.method = method;
    }

    @Override
    public ContainerResponseFilter[] getResponseFilters() {
        return this.responseFilters;
    }

    @Override
    public void setResponseFilters(ContainerResponseFilter[] responseFilters) {
        this.responseFilters = responseFilters;
    }

    @Override
    public WriterInterceptor[] getWriterInterceptors() {
        return this.writerInterceptors;
    }

    @Override
    public void setWriterInterceptors(WriterInterceptor[] writerInterceptors) {
        this.writerInterceptors = writerInterceptors;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    protected void sendResponse(Response response) throws IllegalStateException {
        this.dispatcher.asynchronousDelivery(this.request, this.response, response);
    }

    protected void sendResponseObject(Object entity, int status) {
        if (entity == null) {
            this.sendResponse(Response.status((int)status).build());
        } else if (entity instanceof Response) {
            this.sendResponse((Response)entity);
        } else {
            if (this.method == null) {
                throw new IllegalStateException("Unknown media type for response entity");
            }
            MediaType type = this.method.resolveContentType(this.request, entity);
            this.sendResponse(Response.status((int)status).entity(entity).type(type).build());
        }
    }

    public void resume(Object entity) throws IllegalStateException {
        if (entity == null) {
            this.sendResponse(Response.noContent().build());
        } else if (entity instanceof Response) {
            this.sendResponse((Response)entity);
        } else {
            if (this.method == null) {
                throw new IllegalStateException("Unknown media type for response entity");
            }
            MediaType type = this.method.resolveContentType(this.request, entity);
            this.sendResponse(Response.ok((Object)entity, (MediaType)type).build());
        }
    }

    public void resume(Throwable exc) throws IllegalStateException {
        this.dispatcher.handleException(this.request, this.response, exc);
    }
}

