/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core.executors;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.client.core.SelfExpandingBufferredInputStream;
import org.jboss.resteasy.util.CaseInsensitiveMap;

@Deprecated
public class ApacheHttpClientExecutor
implements ClientExecutor {
    protected HttpClient httpClient;
    protected boolean createdHttpClient;
    protected boolean closed;

    public ApacheHttpClientExecutor() {
        this.httpClient = new HttpClient();
        this.createdHttpClient = true;
    }

    public ApacheHttpClientExecutor(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public static CaseInsensitiveMap<String> extractHeaders(HttpMethodBase baseMethod) {
        CaseInsensitiveMap<String> headers = new CaseInsensitiveMap<String>();
        for (Header header : baseMethod.getResponseHeaders()) {
            headers.add(header.getName(), header.getValue());
        }
        return headers;
    }

    @Override
    public ClientRequest createRequest(String uriTemplate) {
        return new ClientRequest(uriTemplate, (ClientExecutor)this);
    }

    @Override
    public ClientRequest createRequest(UriBuilder uriBuilder) {
        return new ClientRequest(uriBuilder, (ClientExecutor)this);
    }

    @Override
    public ClientResponse execute(ClientRequest request) throws Exception {
        String uri = request.getUri();
        final HttpMethodBase httpMethod = this.createHttpMethod(uri, request.getHttpMethod());
        this.loadHttpMethod(request, httpMethod);
        int status = this.httpClient.executeMethod((HttpMethod)httpMethod);
        BaseClientResponse response = new BaseClientResponse(new BaseClientResponse.BaseClientResponseStreamFactory(){
            InputStream stream;

            @Override
            public InputStream getInputStream() throws IOException {
                if (this.stream == null) {
                    this.stream = new SelfExpandingBufferredInputStream(httpMethod.getResponseBodyAsStream());
                }
                return this.stream;
            }

            @Override
            public void performReleaseConnection() {
                try {
                    httpMethod.releaseConnection();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    this.stream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, this);
        response.setAttributes(request.getAttributes());
        response.setStatus(status);
        response.setHeaders(ApacheHttpClientExecutor.extractHeaders(httpMethod));
        response.setProviderFactory(request.getProviderFactory());
        return response;
    }

    private HttpMethodBase createHttpMethod(String url, String restVerb) {
        if ("GET".equals(restVerb)) {
            return new GetMethod(url);
        }
        if ("POST".equals(restVerb)) {
            return new PostMethod(url);
        }
        if ("DELETE".equals(restVerb)) {
            return new DeleteMethod(url);
        }
        final String verb = restVerb;
        return new PostMethod(url){

            public String getName() {
                return verb;
            }
        };
    }

    public void loadHttpMethod(ClientRequest request, HttpMethodBase httpMethod) throws Exception {
        if (httpMethod instanceof GetMethod && request.followRedirects()) {
            httpMethod.setFollowRedirects(true);
        } else {
            httpMethod.setFollowRedirects(false);
        }
        if (request.getBody() != null && !request.getFormParameters().isEmpty()) {
            throw new RuntimeException("You cannot send both form parameters and an entity body");
        }
        if (!request.getFormParameters().isEmpty()) {
            this.commitHeaders(request, httpMethod);
            PostMethod post = (PostMethod)httpMethod;
            for (Map.Entry formParam : request.getFormParameters().entrySet()) {
                List values = (List)formParam.getValue();
                for (String value : values) {
                    post.addParameter((String)formParam.getKey(), value);
                }
            }
        } else if (request.getBody() != null) {
            if (!(httpMethod instanceof EntityEnclosingMethod)) {
                throw new RuntimeException("A GET request cannot have a body.");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            request.writeRequestBody(request.getHeadersAsObjects(), baos);
            this.commitHeaders(request, httpMethod);
            ClientRequestEntity requestEntity = new ClientRequestEntity(request.getBodyContentType().toString(), baos.toByteArray());
            EntityEnclosingMethod post = (EntityEnclosingMethod)httpMethod;
            post.setRequestEntity((RequestEntity)requestEntity);
        } else {
            this.commitHeaders(request, httpMethod);
        }
    }

    public void commitHeaders(ClientRequest request, HttpMethodBase httpMethod) {
        MultivaluedMap<String, String> headers = request.getHeaders();
        for (Map.Entry header : headers.entrySet()) {
            List values = (List)header.getValue();
            for (String value : values) {
                httpMethod.addRequestHeader((String)header.getKey(), value);
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        if (this.createdHttpClient) {
            HttpConnectionManager manager = this.httpClient.getHttpConnectionManager();
            if (manager == null) {
                return;
            }
            Method shutdown = null;
            try {
                shutdown = manager.getClass().getDeclaredMethod("shutdown", new Class[0]);
            }
            catch (Exception e) {
                return;
            }
            shutdown.invoke((Object)manager, new Object[0]);
            this.closed = true;
        }
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private static class ClientRequestEntity
    implements RequestEntity {
        private byte[] bytes;
        private String contentType;

        private ClientRequestEntity(String contentType, byte[] bytes) {
            this.contentType = contentType;
            this.bytes = bytes;
        }

        public boolean isRepeatable() {
            return true;
        }

        public void writeRequest(OutputStream outputStream) throws IOException {
            outputStream.write(this.bytes);
        }

        public long getContentLength() {
            return this.bytes.length;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

