/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.transformer;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import org.jboss.maven.plugins.transformer.Action;

public class TransformerUtils {
    private static final Logger log = Logger.getLogger(TransformerUtils.class.getName());
    private String filterPattern;
    private String transformerClassName;
    private ClassLoader classLoader;
    private LoaderClassPath loaderClassPath;
    private ClassPool classPool;
    private ClassFileTransformer transformer;

    protected Logger getLog() {
        return log;
    }

    public static void main(String[] args) {
        boolean outputJarArgSpecified;
        if (args == null || args.length < 2) {
            throw new IllegalArgumentException("Illegal args: " + Arrays.toString(args));
        }
        TransformerUtils tm = new TransformerUtils();
        tm.transformerClassName = args[1];
        tm.filterPattern = args.length > 2 ? args[2] : null;
        String jar = args[0];
        boolean bl = outputJarArgSpecified = args.length > 3;
        if (outputJarArgSpecified) {
            String outputJar = args[3];
            tm.transformJar(jar, outputJar);
        } else {
            tm.transformJar(jar);
        }
    }

    protected void transformJar(String jar) {
        this.transformJar(jar, jar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transformJar(String jar, String outputJar) {
        File original = new File(jar);
        if (!original.exists()) {
            throw new IllegalArgumentException("No such jar file: " + jar);
        }
        File parent = original.getParentFile();
        File temp = new File(parent, original.getName() + ".tmp");
        try {
            File transformedJar;
            File file = transformedJar = outputJar.equals(jar) ? new File(parent, "copy-" + original.getName()) : new File(outputJar);
            if (transformedJar.exists() && !transformedJar.delete()) {
                throw new IOException("Cannot delete copy jar: " + transformedJar);
            }
            TransformerUtils.delete(temp);
            if (!temp.mkdir()) {
                throw new IllegalArgumentException("Cannot create temp dir: " + temp);
            }
            JarFile jarFile = new JarFile(original);
            try {
                this.transformIntoTempDir(original, temp, jarFile);
                this.createJarFromTempDir(temp, transformedJar, jarFile);
            }
            finally {
                jarFile.close();
            }
            if (outputJar.equals(jar)) {
                File old = new File(parent, "old-" + original.getName());
                if (old.exists() && !old.delete()) {
                    throw new IOException("Cannot delete old: " + old);
                }
                if (!original.renameTo(old)) {
                    throw new IllegalArgumentException("Cannot rename original: " + original + " to old: " + old);
                }
                if (!transformedJar.renameTo(original)) {
                    throw new IllegalArgumentException("Cannot rename copy: " + transformedJar + " to actual original: " + original);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformIntoTempDir(File original, final File temp, final JarFile jarFile) throws Exception {
        final FileFilter filter = this.getFilter();
        ClassLoader parentCL = TransformerUtils.class.getClassLoader();
        URLClassLoader cl = new URLClassLoader(new URL[]{original.toURI().toURL()}, parentCL);
        try {
            this.execute(cl, new Action(){

                @Override
                public void execute() throws Exception {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        this.processJarEntry(entries.nextElement());
                    }
                }

                private void processJarEntry(JarEntry entry) throws Exception {
                    String name = entry.getName();
                    if (name.toUpperCase().contains("MANIFEST.MF")) {
                        return;
                    }
                    File file = new File(temp, name);
                    if (entry.isDirectory()) {
                        file.mkdirs();
                    } else {
                        file.getParentFile().mkdirs();
                        if (name.endsWith(".class") && (filter == null || filter.accept(file))) {
                            this.transform(name, file);
                        } else {
                            this.copy(entry, file);
                        }
                    }
                }

                private void transform(String name, File file) throws Exception {
                    TransformationTarget tt = new TransformationTarget(TransformerUtils.toClassName(name), file);
                    tt.writeOutChanges();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void copy(JarEntry entry, File file) throws IOException {
                    InputStream is = jarFile.getInputStream(entry);
                    FileOutputStream os = new FileOutputStream(file);
                    try {
                        TransformerUtils.copyStream(is, os);
                    }
                    finally {
                        TransformerUtils.safeClose(is);
                        TransformerUtils.safeClose(os);
                    }
                }
            });
        }
        finally {
            if (cl instanceof Closeable) {
                URLClassLoader closeable = cl;
                closeable.close();
            } else {
                log.warning("Cannot close classloader for " + original.getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJarFromTempDir(File temp, File copy, JarFile jarFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(copy);
        JarOutputStream jos = new JarOutputStream((OutputStream)fos, jarFile.getManifest());
        try {
            for (File f : temp.listFiles()) {
                this.writeJar(jos, f, "");
            }
        }
        finally {
            TransformerUtils.safeClose(jos);
        }
    }

    protected static void copyStream(InputStream in, OutputStream out) throws IOException {
        int cnt;
        byte[] bytes = new byte[8192];
        while ((cnt = in.read(bytes)) != -1) {
            out.write(bytes, 0, cnt);
        }
    }

    protected static void safeClose(Closeable c) {
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void delete(File file) throws IOException {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                throw new IOException("Null files, weird I/O error: " + file);
            }
            for (File f : files) {
                TransformerUtils.delete(f);
            }
        }
        if (!file.delete()) {
            throw new IOException("Cannot delete file: " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeJar(JarOutputStream jos, File src, String prefix) throws IOException {
        if (src.isDirectory()) {
            File[] files;
            prefix = prefix + src.getName() + "/";
            ZipEntry entry = new ZipEntry(prefix);
            entry.setTime(src.lastModified());
            entry.setMethod(0);
            entry.setSize(0L);
            entry.setCrc(0L);
            jos.putNextEntry(entry);
            jos.closeEntry();
            for (File file : files = src.listFiles()) {
                this.writeJar(jos, file, prefix);
            }
        } else if (src.isFile()) {
            ZipEntry entry = new ZipEntry(prefix + src.getName());
            entry.setTime(src.lastModified());
            jos.putNextEntry(entry);
            FileInputStream in = new FileInputStream(src);
            try {
                TransformerUtils.copyStream(in, jos);
            }
            finally {
                TransformerUtils.safeClose(in);
                jos.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(ClassLoader cl, Action action) throws Exception {
        this.classLoader = cl;
        this.loaderClassPath = new LoaderClassPath(this.classLoader);
        try {
            this.classPool = new ClassPool(true);
            this.classPool.appendClassPath((ClassPath)this.loaderClassPath);
            action.execute();
        }
        finally {
            this.loaderClassPath.close();
            this.classLoader = null;
        }
    }

    protected void recurse(File current, String name) throws Exception {
        this.recurse(current, this.getFilter(), name);
    }

    protected void recurse(File current, FileFilter filter, String name) throws Exception {
        if (current.isDirectory()) {
            File[] files = current.listFiles();
            if (files == null) {
                throw new IllegalArgumentException("Null files, weird I/O error: " + current);
            }
            if (name.length() > 0) {
                name = name + ".";
            }
            for (File f : files) {
                this.recurse(f, filter, name + f.getName());
            }
        } else if (name.endsWith(".class") && (filter == null || filter.accept(current))) {
            TransformationTarget tt = new TransformationTarget(TransformerUtils.toClassName(name));
            tt.writeOutChanges();
        }
    }

    protected FileFilter getFilter() {
        if (this.filterPattern == null) {
            return new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return true;
                }
            };
        }
        return new FileFilter(){
            Pattern patter;
            {
                this.patter = Pattern.compile(TransformerUtils.this.filterPattern);
            }

            @Override
            public boolean accept(File file) {
                return this.patter.matcher(file.getPath()).find();
            }
        };
    }

    protected ClassFileTransformer getTransformer() {
        if (this.transformer == null) {
            if (this.transformerClassName == null) {
                throw new IllegalArgumentException("Missing transformer class name!");
            }
            try {
                Class<?> aClass = this.classLoader.loadClass(this.transformerClassName);
                this.transformer = (ClassFileTransformer)aClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.transformer;
    }

    protected static File toFile(String className, URL url) throws Exception {
        if (url == null) {
            throw new Exception("No such class name: " + className + ", wrong classloader?");
        }
        try {
            return new File(url.toURI());
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    protected static String toClassName(String fileName) {
        int len = fileName.length() - 6;
        return fileName.replace("/", ".").substring(0, len);
    }

    public String getFilterPattern() {
        return this.filterPattern;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }

    public String getTransformerClassName() {
        return this.transformerClassName;
    }

    public void setTransformerClassName(String transformerClassName) {
        this.transformerClassName = transformerClassName;
    }

    class TransformationTarget {
        private final File classFileLocation;
        private final CtClass ctClass;

        public TransformationTarget(String className) throws Exception {
            this(className, TransformerUtils.toFile(className, transformerUtils.loaderClassPath.find(className)));
        }

        public TransformationTarget(String className, File file) throws Exception {
            try {
                this.ctClass = TransformerUtils.this.classPool.get(className);
                this.classFileLocation = file;
            }
            catch (Throwable e) {
                throw new Exception("Unable to resolve class file path", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeOutChanges() throws Exception {
            TransformerUtils.this.getLog().info("writing transformation changes [" + this.classFileLocation.getAbsolutePath() + "]");
            byte[] original = this.ctClass.toBytecode();
            byte[] transformed = TransformerUtils.this.getTransformer().transform(TransformerUtils.this.classLoader, this.ctClass.getName(), null, null, original);
            if (transformed == null || transformed.length == 0) {
                return;
            }
            FileOutputStream out = new FileOutputStream(this.classFileLocation);
            try {
                ((OutputStream)out).write(transformed);
            }
            finally {
                TransformerUtils.safeClose(out);
            }
            if (!this.classFileLocation.setLastModified(System.currentTimeMillis())) {
                TransformerUtils.this.getLog().info("Unable to manually update class file timestamp: " + this.classFileLocation);
            }
        }
    }
}

