/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.ToolLogger;

public abstract class AbstractTool {
    private final Elements elementUtils;
    private final Filer filer;
    private final ToolLogger logger;
    private final Types typeUtils;
    private final ProcessingEnvironment processingEnv;

    public AbstractTool(ProcessingEnvironment processingEnv) {
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.logger = ToolLogger.getLogger(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.processingEnv = processingEnv;
    }

    public abstract void processTypeElement(TypeElement var1, TypeElement var2, Collection<ExecutableElement> var3);

    public final ToolLogger logger() {
        return this.logger;
    }

    public final Filer filer() {
        return this.filer;
    }

    public final Elements elementUtils() {
        return this.elementUtils;
    }

    public final Types typeUtils() {
        return this.typeUtils;
    }

    public final ProcessingEnvironment processingEnv() {
        return this.processingEnv;
    }

    public final String getName() {
        return this.getClass().getSimpleName();
    }

    public final Set<String> getSupportedOptions() {
        SupportedOptions options = this.getClass().getAnnotation(SupportedOptions.class);
        if (options != null) {
            return new HashSet<String>(Arrays.asList(options.value()));
        }
        return Collections.emptySet();
    }
}

