/*
 *  JBoss, Home of Professional Open Source Copyright 2010, Red Hat, Inc., and
 *  individual contributors by the @authors tag. See the copyright.txt in the
 *  distribution for a full listing of individual contributors.
 *
 *  This is free software; you can redistribute it and/or modify it under the
 *  terms of the GNU Lesser General Public License as published by the Free
 *  Software Foundation; either version 2.1 of the License, or (at your option)
 *  any later version.
 *
 *  This software is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 *  FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this software; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 *  site: http://www.fsf.org.
 */
package org.jboss.logging.validation;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import java.util.Collection;

/**
 * Used to validate various aspects of an interface to make sure the classes can
 * be implemented the code model.
 *
 * @author James R. Perkins Jr. (jrp)
 * @author Kevin Pollet
 *
 */
public interface ElementValidator {

    /**
     * Validates the collection of methods that were passed.
     *
     * @param element        the root element, generally the interface.
     * @param elementMethods the methods of the interface.
     *
     * @return a collection of error messages or a an empty collection if no errors were found.
     */
    Collection<ValidationErrorMessage> validate(final TypeElement element, final Collection<ExecutableElement> elementMethods);
}
