/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security.jaspi;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import org.apache.log4j.Logger;

public class TomcatJASPICallbackHandler
implements CallbackHandler {
    private static Logger log = Logger.getLogger(TomcatJASPICallbackHandler.class);
    private CallerPrincipalCallback callerPrincipalCallback;
    private PasswordValidationCallback passwordValidationCallback;
    private GroupPrincipalCallback groupPrincipalCallback;

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks.length > 0) {
            for (Callback callback : callbacks) {
                if (callback instanceof CallerPrincipalCallback) {
                    callback = this.callerPrincipalCallback;
                    continue;
                }
                if (callback instanceof PasswordValidationCallback) {
                    callback = this.passwordValidationCallback;
                    continue;
                }
                if (callback instanceof GroupPrincipalCallback) {
                    callback = this.groupPrincipalCallback;
                    continue;
                }
                log.trace((Object)("Callback " + callback.getClass().getCanonicalName() + " not supported"));
            }
        }
    }

    public CallerPrincipalCallback getCallerPrincipalCallback() {
        return this.callerPrincipalCallback;
    }

    public PasswordValidationCallback getPasswordValidationCallback() {
        return this.passwordValidationCallback;
    }

    public GroupPrincipalCallback getGroupPrincipalCallback() {
        return this.groupPrincipalCallback;
    }

    public void setCallerPrincipalCallback(CallerPrincipalCallback callerPrincipalCallback) {
        this.callerPrincipalCallback = callerPrincipalCallback;
    }

    public void setGroupPrincipalCallback(GroupPrincipalCallback groupPrincipalCallback) {
        this.groupPrincipalCallback = groupPrincipalCallback;
    }

    public void setPasswordValidationCallback(PasswordValidationCallback passwordValidationCallback) {
        this.passwordValidationCallback = passwordValidationCallback;
    }
}

