/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.standard;

import javax.management.MBeanInfo;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.test.jmx.compliance.standard.AttributeInfoTEST;
import org.jboss.test.jmx.compliance.standard.ConstructorInfoTEST;
import org.jboss.test.jmx.compliance.standard.InfoUtil;
import org.jboss.test.jmx.compliance.standard.OperationInfoTEST;
import org.jboss.test.jmx.compliance.standard.SpuriousAttributeTEST;
import org.jboss.test.jmx.compliance.standard.support.Torture;

public class InfoTortureSUITE
extends TestSuite {
    private static int attributeTestCount = 0;
    private static int operationTestCount = 0;
    private static int constructorTestCount = 0;

    public static void main(String[] args) {
        TestRunner.run((Test)InfoTortureSUITE.suite());
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("All MBeanInfo Torture Tests for Standard MBeans");
        Torture mbean = new Torture();
        MBeanInfo info = InfoUtil.getMBeanInfo(mbean, "test:type=mbeaninfo");
        InfoTortureSUITE.addConstructorTest(testSuite, info, Torture.class.getName(), new String[0]);
        InfoTortureSUITE.addConstructorTest(testSuite, info, Torture.class.getName(), new String[]{String[][].class.getName()});
        testSuite.addTest((Test)new TestCoverageTEST("Torture constructor list length", constructorTestCount, info.getConstructors().length));
        InfoTortureSUITE.addSpuriousAttributeTest(testSuite, info, "peachy");
        InfoTortureSUITE.addSpuriousAttributeTest(testSuite, info, "Peachy");
        InfoTortureSUITE.addSpuriousAttributeTest(testSuite, info, "suer");
        InfoTortureSUITE.addSpuriousAttributeTest(testSuite, info, "settlement");
        InfoTortureSUITE.addSpuriousAttributeTest(testSuite, info, "Result");
        InfoTortureSUITE.addSpuriousAttributeTest(testSuite, info, "Multi");
        InfoTortureSUITE.addAttributeTest(testSuite, info, "NiceString", String.class.getName(), true, true, false);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "NiceBoolean", Boolean.TYPE.getName(), true, true, true);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "Something", String.class.getName(), false, true, false);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "Int", Integer.TYPE.getName(), false, true, false);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "IntArray", int[].class.getName(), false, true, false);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "NestedIntArray", int[][][].class.getName(), false, true, false);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "Integer", Integer.class.getName(), false, true, false);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "IntegerArray", Integer[].class.getName(), false, true, false);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "NestedIntegerArray", Integer[][][].class.getName(), false, true, false);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "Myinteger", Integer.TYPE.getName(), true, false, false);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "MyintegerArray", int[].class.getName(), true, false, false);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "MyNestedintegerArray", int[][][].class.getName(), true, false, false);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "MyInteger", Integer.class.getName(), true, false, false);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "MyIntegerArray", Integer[].class.getName(), true, false, false);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "MyNestedIntegerArray", Integer[][][].class.getName(), true, false, false);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "ready", Boolean.TYPE.getName(), true, false, true);
        InfoTortureSUITE.addAttributeTest(testSuite, info, "Ready", Boolean.class.getName(), true, false, false);
        testSuite.addTest((Test)new TestCoverageTEST("Torture attribute list length", attributeTestCount, info.getAttributes().length));
        InfoTortureSUITE.addOperationTest(testSuite, info, "settlement", 3, Integer.TYPE.getName(), new String[]{String.class.getName()});
        InfoTortureSUITE.addOperationTest(testSuite, info, "getSomething", 3, Void.TYPE.getName(), new String[0]);
        InfoTortureSUITE.addOperationTest(testSuite, info, "ispeachy", 3, Boolean.TYPE.getName(), new String[]{Integer.TYPE.getName()});
        InfoTortureSUITE.addOperationTest(testSuite, info, "isPeachy", 3, Boolean.class.getName(), new String[]{Integer.TYPE.getName()});
        InfoTortureSUITE.addOperationTest(testSuite, info, "setMulti", 3, Void.TYPE.getName(), new String[]{String.class.getName(), Integer.class.getName()});
        InfoTortureSUITE.addOperationTest(testSuite, info, "getResult", 3, String.class.getName(), new String[]{String.class.getName()});
        InfoTortureSUITE.addOperationTest(testSuite, info, "setNothing", 3, Void.TYPE.getName(), new String[0]);
        InfoTortureSUITE.addOperationTest(testSuite, info, "getNothing", 3, Void.TYPE.getName(), new String[0]);
        InfoTortureSUITE.addOperationTest(testSuite, info, "doSomethingCrazy", 3, String[][].class.getName(), new String[]{Object[].class.getName(), String[].class.getName(), int[][][].class.getName()});
        InfoTortureSUITE.addOperationTest(testSuite, info, "issuer", 3, String.class.getName(), new String[0]);
        testSuite.addTest((Test)new TestCoverageTEST("Torture operation list length", operationTestCount, info.getOperations().length));
        return testSuite;
    }

    public static void addConstructorTest(TestSuite testSuite, MBeanInfo info, String name, String[] signature) {
        testSuite.addTest((Test)new ConstructorInfoTEST("InfoTortureSUITE constructor", info, name, signature));
        ++constructorTestCount;
    }

    public static void addSpuriousAttributeTest(TestSuite testSuite, MBeanInfo info, String name) {
        testSuite.addTest((Test)new SpuriousAttributeTEST("InfoTortureSUITE spuriousAttribute", info, name));
    }

    public static void addAttributeTest(TestSuite testSuite, MBeanInfo info, String name, String type, boolean read, boolean write, boolean is) {
        testSuite.addTest((Test)new AttributeInfoTEST("InfoTortureSUITE attribute", info, name, type, read, write, is));
        ++attributeTestCount;
    }

    public static void addOperationTest(TestSuite testSuite, MBeanInfo info, String name, int impact, String returnType, String[] signature) {
        testSuite.addTest((Test)new OperationInfoTEST("InfoTortureSUITE operation", info, name, impact, returnType, signature));
        ++operationTestCount;
    }

    public static class TestCoverageTEST
    extends TestCase {
        private String msg;
        private int expected;
        private int got;

        public TestCoverageTEST(String msg, int expected, int got) {
            super("testAdequateCoverage");
            this.msg = msg;
            this.expected = expected;
            this.got = got;
        }

        public void testAdequateCoverage() {
            TestCoverageTEST.assertEquals((String)this.msg, (int)this.expected, (int)this.got);
        }
    }
}

