/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.relation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.relation.RoleUnresolved;
import junit.framework.TestCase;

public class RoleUnresolvedTestCase
extends TestCase {
    public RoleUnresolvedTestCase(String s) {
        super(s);
    }

    public void testBasic() {
        try {
            ArrayList<ObjectName> roleValue = new ArrayList<ObjectName>();
            ObjectName a = new ObjectName(":a=a");
            ObjectName b = new ObjectName(":b=b");
            roleValue.add(a);
            roleValue.add(b);
            RoleUnresolved roleUnresolved = new RoleUnresolved("RoleName", roleValue, 1);
            RoleUnresolvedTestCase.assertEquals((String)"RoleName", (String)roleUnresolved.getRoleName());
            RoleUnresolvedTestCase.assertEquals(roleValue, roleUnresolved.getRoleValue());
            RoleUnresolvedTestCase.assertEquals((int)1, (int)roleUnresolved.getProblemType());
            roleUnresolved.setRoleName("Changed");
            RoleUnresolvedTestCase.assertEquals((String)"Changed", (String)roleUnresolved.getRoleName());
            ArrayList<ObjectName> roleValue2 = new ArrayList<ObjectName>();
            ObjectName c = new ObjectName(":c=c");
            ObjectName d = new ObjectName(":d=d");
            roleValue2.add(c);
            roleValue2.add(d);
            roleUnresolved.setRoleValue(roleValue2);
            RoleUnresolvedTestCase.assertEquals(roleValue2, roleUnresolved.getRoleValue());
            roleUnresolved.setProblemType(2);
            RoleUnresolvedTestCase.assertEquals((int)2, (int)roleUnresolved.getProblemType());
        }
        catch (MalformedObjectNameException mfone) {
            RoleUnresolvedTestCase.fail((String)mfone.toString());
        }
    }

    public void testToString() {
        try {
            ArrayList<ObjectName> roleValue = new ArrayList<ObjectName>();
            ObjectName a = new ObjectName(":a=a");
            ObjectName b = new ObjectName(":b=b");
            roleValue.add(a);
            roleValue.add(b);
            RoleUnresolved roleUnresolved = new RoleUnresolved("XYZZY", roleValue, 1);
            String result = roleUnresolved.toString();
            if (result.lastIndexOf("XYZZY") == -1) {
                RoleUnresolvedTestCase.fail((String)"Missing role name in toString");
            }
            if (result.lastIndexOf(":a=a") == -1) {
                RoleUnresolvedTestCase.fail((String)"Missing object name :a=a in toString");
            }
            if (result.lastIndexOf(":b=b") == -1) {
                RoleUnresolvedTestCase.fail((String)"Missing object name :b=b in toString");
            }
        }
        catch (MalformedObjectNameException mfone) {
            RoleUnresolvedTestCase.fail((String)mfone.toString());
        }
    }

    public void testErrorHandling() {
        try {
            ArrayList<ObjectName> roleValue = new ArrayList<ObjectName>();
            ObjectName a = new ObjectName(":a=a");
            ObjectName b = new ObjectName(":b=b");
            roleValue.add(a);
            roleValue.add(b);
            boolean caught = false;
            try {
                new RoleUnresolved(null, roleValue, 1);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RoleUnresolvedTestCase.fail((String)"Constructor accepts null role name");
            }
            caught = false;
            try {
                new RoleUnresolved("RoleName", roleValue, -1000);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RoleUnresolvedTestCase.fail((String)"Constructor accepts an invalid problem type");
            }
            RoleUnresolved roleUnresolved = new RoleUnresolved("RoleName", roleValue, 1);
            caught = false;
            try {
                roleUnresolved.setRoleName(null);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RoleUnresolvedTestCase.fail((String)"setRoleName accepts null");
            }
            caught = false;
            try {
                roleUnresolved.setProblemType(-1000);
            }
            catch (IllegalArgumentException e) {
                caught = true;
            }
            if (!caught) {
                RoleUnresolvedTestCase.fail((String)"setProblemType accepts an invalid problem type");
            }
        }
        catch (MalformedObjectNameException mfone) {
            RoleUnresolvedTestCase.fail((String)mfone.toString());
        }
    }

    public void testClone() {
        ArrayList<ObjectName> roleValue = new ArrayList<ObjectName>();
        try {
            roleValue.add(new ObjectName(":a=a"));
            roleValue.add(new ObjectName(":b=b"));
        }
        catch (MalformedObjectNameException mfone) {
            RoleUnresolvedTestCase.fail((String)mfone.toString());
        }
        RoleUnresolved roleUnresolved = new RoleUnresolved("RoleName", roleValue, 1);
        RoleUnresolved roleUnresolved2 = (RoleUnresolved)roleUnresolved.clone();
        RoleUnresolvedTestCase.assertEquals((String)roleUnresolved.getRoleName(), (String)roleUnresolved2.getRoleName());
        RoleUnresolvedTestCase.assertEquals(roleUnresolved.getRoleValue(), roleUnresolved2.getRoleValue());
        RoleUnresolvedTestCase.assertEquals((int)roleUnresolved.getProblemType(), (int)roleUnresolved2.getProblemType());
        if (roleUnresolved.getRoleValue() == roleUnresolved2.getRoleValue()) {
            RoleUnresolvedTestCase.fail((String)"RoleUnresolved.clone() didn't clone");
        }
    }

    public void testSerialization() {
        ArrayList<ObjectName> roleValue = new ArrayList<ObjectName>();
        try {
            roleValue.add(new ObjectName(":a=a"));
            roleValue.add(new ObjectName(":b=b"));
        }
        catch (MalformedObjectNameException mfone) {
            RoleUnresolvedTestCase.fail((String)mfone.toString());
        }
        RoleUnresolved roleUnresolved = new RoleUnresolved("RoleName", roleValue, 1);
        RoleUnresolved roleUnresolved2 = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(roleUnresolved);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            roleUnresolved2 = (RoleUnresolved)ois.readObject();
        }
        catch (IOException ioe) {
            RoleUnresolvedTestCase.fail((String)ioe.toString());
        }
        catch (ClassNotFoundException cnfe) {
            RoleUnresolvedTestCase.fail((String)cnfe.toString());
        }
        RoleUnresolvedTestCase.assertEquals((String)roleUnresolved.getRoleName(), (String)roleUnresolved2.getRoleName());
        RoleUnresolvedTestCase.assertEquals(roleUnresolved.getRoleValue(), roleUnresolved2.getRoleValue());
    }
}

