/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.query;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeValueExp;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jboss.test.jmx.compliance.query.support.BooleanTest;
import org.jboss.test.jmx.compliance.query.support.NumberTest;
import org.jboss.test.jmx.compliance.query.support.StringTest;
import org.jboss.test.jmx.compliance.query.support.Trivial;

public class QueryTestCase
extends TestCase {
    public QueryTestCase(String s) {
        super(s);
    }

    public void testBoolean() throws Exception {
        ValueExp one = Query.value(true);
        ValueExp two = Query.value(false);
        this.equalsTEST(one, two);
        this.attrTEST(new BooleanTest(true), Query.attr("Boolean"), one, two);
        this.attrTEST(new BooleanTest(true), Query.attr(BooleanTest.class.getName(), "Boolean"), one, two);
        try {
            new QueryTEST(new MBean[]{new MBean(new Trivial(), "Domain1:type=instance1")}, new MBean[0], Query.in(one, new ValueExp[]{one, two, two})).test();
            new QueryTEST(new MBean[]{new MBean(new Trivial(), "Domain1:type=instance1")}, new MBean[0], Query.in(one, new ValueExp[]{two, two, one})).test();
            new QueryTEST(new MBean[]{new MBean(new Trivial(), "Domain1:type=instance1")}, new MBean[0], Query.in(one, new ValueExp[]{two, one, two})).test();
            new QueryTEST(new MBean[0], new MBean[]{new MBean(new Trivial(), "Domain1:type=instance1")}, Query.in(one, new ValueExp[]{two, two, two})).test();
        }
        catch (AssertionFailedError e) {
            QueryTestCase.fail((String)"FAILS IN RI: Query.in boolean");
        }
    }

    public void testDouble() throws Exception {
        ValueExp one = Query.value(10.0);
        ValueExp two = Query.value(20.0);
        ValueExp div = Query.value(2.0);
        ValueExp minus = Query.value(-10.0);
        ValueExp mult = Query.value(200.0);
        ValueExp plus = Query.value(30.0);
        this.equalsTEST(one, two);
        this.operationTEST(one, two, div, minus, mult, plus);
        this.comparisonTEST(one, two);
        this.betweenTEST(one, two, plus);
        this.attrTEST(new NumberTest(10.0), Query.attr("Number"), one, two);
        this.attrTEST(new NumberTest(10.0), Query.attr(NumberTest.class.getName(), "Number"), one, two);
        this.inTEST(one, two, div, minus, mult, plus);
    }

    public void testDoubleObject() throws Exception {
        ValueExp one = Query.value(new Double(10.0));
        ValueExp two = Query.value(new Double(20.0));
        ValueExp div = Query.value(new Double(2.0));
        ValueExp minus = Query.value(new Double(-10.0));
        ValueExp mult = Query.value(new Double(200.0));
        ValueExp plus = Query.value(new Double(30.0));
        this.equalsTEST(one, two);
        this.operationTEST(one, two, div, minus, mult, plus);
        this.comparisonTEST(one, two);
        this.betweenTEST(one, two, plus);
        this.attrTEST(new NumberTest(new Double(10.0)), Query.attr("Number"), one, two);
        this.attrTEST(new NumberTest(new Double(10.0)), Query.attr(NumberTest.class.getName(), "Number"), one, two);
        this.inTEST(one, two, div, minus, mult, plus);
    }

    public void testFloat() throws Exception {
        ValueExp one = Query.value(10.0f);
        ValueExp two = Query.value(20.0f);
        ValueExp div = Query.value(2.0f);
        ValueExp minus = Query.value(-10.0f);
        ValueExp mult = Query.value(200.0f);
        ValueExp plus = Query.value(30.0f);
        this.equalsTEST(one, two);
        this.operationTEST(one, two, div, minus, mult, plus);
        this.comparisonTEST(one, two);
        this.betweenTEST(one, two, plus);
        this.attrTEST(new NumberTest(10.0f), Query.attr("Number"), one, two);
        this.attrTEST(new NumberTest(10.0f), Query.attr(NumberTest.class.getName(), "Number"), one, two);
        this.inTEST(one, two, div, minus, mult, plus);
    }

    public void testFloatObject() throws Exception {
        ValueExp one = Query.value(new Float(10.0f));
        ValueExp two = Query.value(new Float(20.0f));
        ValueExp div = Query.value(new Double(2.0));
        ValueExp minus = Query.value(new Double(-10.0));
        ValueExp mult = Query.value(new Double(200.0));
        ValueExp plus = Query.value(new Double(30.0));
        this.equalsTEST(one, two);
        this.operationTEST(one, two, div, minus, mult, plus);
        this.comparisonTEST(one, two);
        this.betweenTEST(one, two, plus);
        this.attrTEST(new NumberTest(new Float(10.0f)), Query.attr("Number"), one, two);
        this.attrTEST(new NumberTest(new Float(10.0f)), Query.attr(NumberTest.class.getName(), "Number"), one, two);
        this.inTEST(one, two, div, minus, mult, plus);
    }

    public void testInteger() throws Exception {
        ValueExp one = Query.value(10);
        ValueExp two = Query.value(20);
        ValueExp div = Query.value(2);
        ValueExp minus = Query.value(-10);
        ValueExp mult = Query.value(200);
        ValueExp plus = Query.value(30);
        this.equalsTEST(one, two);
        this.operationTEST(one, two, div, minus, mult, plus);
        this.comparisonTEST(one, two);
        this.betweenTEST(one, two, plus);
        this.attrTEST(new NumberTest(10), Query.attr("Number"), one, two);
        this.attrTEST(new NumberTest(10), Query.attr(NumberTest.class.getName(), "Number"), one, two);
        this.inTEST(one, two, div, minus, mult, plus);
    }

    public void testIntegerObject() throws Exception {
        ValueExp one = Query.value(new Integer(10));
        ValueExp two = Query.value(new Integer(20));
        ValueExp div = Query.value(new Double(2.0));
        ValueExp minus = Query.value(new Double(-10.0));
        ValueExp mult = Query.value(new Double(200.0));
        ValueExp plus = Query.value(new Double(30.0));
        this.equalsTEST(one, two);
        this.operationTEST(one, two, div, minus, mult, plus);
        this.comparisonTEST(one, two);
        this.betweenTEST(one, two, plus);
        this.attrTEST(new NumberTest(new Integer(10)), Query.attr("Number"), one, two);
        this.attrTEST(new NumberTest(new Integer(10)), Query.attr(NumberTest.class.getName(), "Number"), one, two);
        this.inTEST(one, two, div, minus, mult, plus);
    }

    public void testLong() throws Exception {
        ValueExp one = Query.value(10L);
        ValueExp two = Query.value(20L);
        ValueExp div = Query.value(2L);
        ValueExp minus = Query.value(-10L);
        ValueExp mult = Query.value(200L);
        ValueExp plus = Query.value(30L);
        this.equalsTEST(one, two);
        this.operationTEST(one, two, div, minus, mult, plus);
        this.comparisonTEST(one, two);
        this.betweenTEST(one, two, plus);
        this.attrTEST(new NumberTest(10L), Query.attr("Number"), one, two);
        this.attrTEST(new NumberTest(10L), Query.attr(NumberTest.class.getName(), "Number"), one, two);
        this.inTEST(one, two, div, minus, mult, plus);
    }

    public void testLongObject() throws Exception {
        ValueExp one = Query.value(new Long(10L));
        ValueExp two = Query.value(new Long(20L));
        ValueExp div = Query.value(new Double(2.0));
        ValueExp minus = Query.value(new Double(-10.0));
        ValueExp mult = Query.value(new Double(200.0));
        ValueExp plus = Query.value(new Double(30.0));
        this.equalsTEST(one, two);
        this.operationTEST(one, two, div, minus, mult, plus);
        this.comparisonTEST(one, two);
        this.betweenTEST(one, two, plus);
        this.attrTEST(new NumberTest(new Long(10L)), Query.attr("Number"), one, two);
        this.attrTEST(new NumberTest(new Long(10L)), Query.attr(NumberTest.class.getName(), "Number"), one, two);
        this.inTEST(one, two, div, minus, mult, plus);
    }

    public void testString() throws Exception {
        StringValueExp one = Query.value("Hello");
        StringValueExp two = Query.value("Goodbye");
        StringValueExp cat = Query.value("HelloGoodbye");
        StringValueExp three = Query.value("ZZZZZZ");
        StringValueExp four = Query.value("Hi");
        StringValueExp five = Query.value("See ya");
        StringValueExp six = Query.value("Laytaz");
        this.equalsTEST(one, two);
        this.catTEST(one, two, cat);
        this.comparisonTEST(two, one);
        this.betweenTEST(two, one, three);
        this.attrTEST(new StringTest("Hello"), Query.attr("String"), one, two);
        this.attrTEST(new StringTest("Hello"), Query.attr(StringTest.class.getName(), "String"), one, two);
        this.inTEST(one, two, three, four, five, six);
    }

    public void testAndTrueBoth() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.and(Query.eq(Query.value(10), Query.value(10)), Query.eq(Query.value("Hello"), Query.value("Hello")))).test();
    }

    public void testAndFalseFirst() throws Exception {
        new QueryTEST(new MBean[0], new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, Query.and(Query.eq(Query.value(10), Query.value(20)), Query.eq(Query.value("Hello"), Query.value("Hello")))).test();
    }

    public void testAndFalseSecond() throws Exception {
        new QueryTEST(new MBean[0], new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, Query.and(Query.eq(Query.value(10), Query.value(10)), Query.eq(Query.value("Hello"), Query.value("Goodbye")))).test();
    }

    public void testAndFalseBoth() throws Exception {
        new QueryTEST(new MBean[0], new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, Query.and(Query.eq(Query.value(10), Query.value(20)), Query.eq(Query.value("Hello"), Query.value("Goodbye")))).test();
    }

    public void testOrTrueBoth() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.or(Query.eq(Query.value(10), Query.value(10)), Query.eq(Query.value("Hello"), Query.value("Hello")))).test();
    }

    public void testOrFalseFirst() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.or(Query.eq(Query.value(10), Query.value(20)), Query.eq(Query.value("Hello"), Query.value("Hello")))).test();
    }

    public void testOrFalseSecond() throws Exception {
        new QueryTEST(new MBean[0], new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, Query.and(Query.eq(Query.value(10), Query.value(10)), Query.eq(Query.value("Hello"), Query.value("Goodbye")))).test();
    }

    public void testOrFalseBoth() throws Exception {
        new QueryTEST(new MBean[0], new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, Query.or(Query.eq(Query.value(10), Query.value(20)), Query.eq(Query.value("Hello"), Query.value("Goodbye")))).test();
    }

    public void testNot() throws Exception {
        new QueryTEST(new MBean[0], new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, Query.not(Query.eq(Query.value("Hello"), Query.value("Hello")))).test();
    }

    public void testNotNot() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.not(Query.eq(Query.value("Hello"), Query.value("Goodbye")))).test();
    }

    public void testClassAttribute() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[]{new MBean(new Trivial(), "Domain1:type=instance2")}, Query.eq(Query.classattr(), Query.value(NumberTest.class.getName()))).test();
    }

    public void testSimpleObjectName() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new Trivial(), "Domain1:type=instance1")}, new MBean[]{new MBean(new Trivial(), "Domain1:type=instance2")}, new ObjectName("Domain1:type=instance1")).test();
    }

    public void testDomainPatternObjectName() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new Trivial(), "Domain1:type=instance1")}, new MBean[]{new MBean(new Trivial(), "Domain1:type=instance2")}, new ObjectName("*:type=instance1")).test();
    }

    public void testPropertyPatternObjectName() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new Trivial(), "Domain1:type=instance1"), new MBean(new Trivial(), "Domain1:type=instance2")}, new MBean[]{new MBean(new Trivial(), "Domain2:type=instance1")}, new ObjectName("Domain1:*")).test();
    }

    public void testMultiplePropertyPatternObjectName() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new Trivial(), "Domain1:type=instance1,extra=true")}, new MBean[]{new MBean(new Trivial(), "Domain1:type=instance2")}, new ObjectName("Domain1:extra=true,*")).test();
    }

    public void testInvalidNamePassedToObjectName() throws Exception {
        if (new ObjectName("*:*").apply(new ObjectName("*:type=patternNotAllowedHere"))) {
            QueryTestCase.fail((String)"Patterns should not be matched");
        }
    }

    public void testAnySubstring() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new StringTest("Hello"), "Domain1:type=instance1"), new MBean(new StringTest("ellbeginning"), "Domain1:type=instance2"), new MBean(new StringTest("endell"), "Domain1:type=instance3"), new MBean(new StringTest("ell"), "Domain1:type=instance4")}, new MBean[]{new MBean(new StringTest("Goodbye"), "Domain2:type=instance1"), new MBean(new StringTest("el"), "Domain2:type=instance2"), new MBean(new StringTest("ll"), "Domain2:type=instance3"), new MBean(new StringTest("e ll"), "Domain2:type=instance4"), new MBean(new StringTest("ELL"), "Domain2:type=instance5"), new MBean(new StringTest("Ell"), "Domain2:type=instance6")}, Query.anySubString(Query.attr("String"), Query.value("ell"))).test();
    }

    public void testFinalSubstring() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new StringTest("endell"), "Domain1:type=instance1"), new MBean(new StringTest("ell"), "Domain1:type=instance2")}, new MBean[]{new MBean(new StringTest("Hello"), "Domain2:type=instance1"), new MBean(new StringTest("ellbeginning"), "Domain2:type=instance2"), new MBean(new StringTest("Goodbye"), "Domain2:type=instance3"), new MBean(new StringTest("el"), "Domain2:type=instance4"), new MBean(new StringTest("ll"), "Domain2:type=instance5"), new MBean(new StringTest("e ll"), "Domain2:type=instance6"), new MBean(new StringTest("ELL"), "Domain2:type=instance7"), new MBean(new StringTest("Ell"), "Domain2:type=instance8")}, Query.finalSubString(Query.attr("String"), Query.value("ell"))).test();
    }

    public void testInitialSubstring() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new StringTest("ellbeginning"), "Domain1:type=instance1"), new MBean(new StringTest("ell"), "Domain1:type=instance2")}, new MBean[]{new MBean(new StringTest("Hello"), "Domain2:type=instance1"), new MBean(new StringTest("endell"), "Domain2:type=instance2"), new MBean(new StringTest("Goodbye"), "Domain2:type=instance3"), new MBean(new StringTest("el"), "Domain2:type=instance4"), new MBean(new StringTest("ll"), "Domain2:type=instance5"), new MBean(new StringTest("e ll"), "Domain2:type=instance6"), new MBean(new StringTest("ELL"), "Domain2:type=instance7"), new MBean(new StringTest("Ell"), "Domain2:type=instance8")}, Query.initialSubString(Query.attr("String"), Query.value("ell"))).test();
    }

    public void testMatchAsteriskBeginning() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new StringTest("endell"), "Domain1:type=instance1"), new MBean(new StringTest("ell"), "Domain1:type=instance2")}, new MBean[]{new MBean(new StringTest("Hello"), "Domain2:type=instance1"), new MBean(new StringTest("ellbeginning"), "Domain2:type=instance2"), new MBean(new StringTest("Goodbye"), "Domain2:type=instance3"), new MBean(new StringTest("el"), "Domain2:type=instance4"), new MBean(new StringTest("ll"), "Domain2:type=instance5"), new MBean(new StringTest("e ll"), "Domain2:type=instance6"), new MBean(new StringTest("ELL"), "Domain2:type=instance7"), new MBean(new StringTest("Ell"), "Domain2:type=instance8")}, Query.match(Query.attr("String"), Query.value("*ell"))).test();
    }

    public void testMatchAsteriskEnd() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new StringTest("ellbeginning"), "Domain1:type=instance1"), new MBean(new StringTest("ell"), "Domain1:type=instance2")}, new MBean[]{new MBean(new StringTest("Hello"), "Domain2:type=instance1"), new MBean(new StringTest("beginningell"), "Domain2:type=instance2"), new MBean(new StringTest("Goodbye"), "Domain2:type=instance3"), new MBean(new StringTest("el"), "Domain2:type=instance4"), new MBean(new StringTest("ll"), "Domain2:type=instance5"), new MBean(new StringTest("e ll"), "Domain2:type=instance6"), new MBean(new StringTest("ELL"), "Domain2:type=instance7"), new MBean(new StringTest("Ell"), "Domain2:type=instance8")}, Query.match(Query.attr("String"), Query.value("ell*"))).test();
    }

    public void testMatchAsteriskBeginningAndEnd() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new StringTest("Hello"), "Domain1:type=instance1"), new MBean(new StringTest("ell"), "Domain1:type=instance2"), new MBean(new StringTest("endell"), "Domain1:type=instance3"), new MBean(new StringTest("beginningell"), "Domain1:type=instance4")}, new MBean[]{new MBean(new StringTest("Goodbye"), "Domain2:type=instance1"), new MBean(new StringTest("el"), "Domain2:type=instance2"), new MBean(new StringTest("ll"), "Domain2:type=instance3"), new MBean(new StringTest("e ll"), "Domain2:type=instance4"), new MBean(new StringTest("ELL"), "Domain2:type=instance5"), new MBean(new StringTest("Ell"), "Domain2:type=instance6")}, Query.match(Query.attr("String"), Query.value("*ell*"))).test();
    }

    public void testMatchAsteriskEmbedded() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new StringTest("Hello"), "Domain1:type=instance1")}, new MBean[]{new MBean(new StringTest("ell"), "Domain2:type=instance1"), new MBean(new StringTest("endell"), "Domain2:type=instance2"), new MBean(new StringTest("beginningell"), "Domain2:type=instance3"), new MBean(new StringTest("Goodbye"), "Domain2:type=instance4"), new MBean(new StringTest("el"), "Domain2:type=instance5"), new MBean(new StringTest("ll"), "Domain2:type=instance6"), new MBean(new StringTest("e ll"), "Domain4:type=instance7"), new MBean(new StringTest("ELL"), "Domain2:type=instance8"), new MBean(new StringTest("Ell"), "Domain2:type=instance9")}, Query.match(Query.attr("String"), Query.value("H*o"))).test();
    }

    public void testMatchQuestionBeginning() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new StringTest("Hello"), "Domain1:type=instance1"), new MBean(new StringTest("hello"), "Domain1:type=instance2"), new MBean(new StringTest(" ello"), "Domain1:type=instance3")}, new MBean[]{new MBean(new StringTest("ello"), "Domain2:type=instance1"), new MBean(new StringTest("Ello"), "Domain2:type=instance2"), new MBean(new StringTest("hhello"), "Domain2:type=instance3")}, Query.match(Query.attr("String"), Query.value("?ello"))).test();
    }

    public void testMatchQuestionEnd() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new StringTest("Hello"), "Domain1:type=instance1"), new MBean(new StringTest("HellO"), "Domain1:type=instance2"), new MBean(new StringTest("Hell "), "Domain1:type=instance3")}, new MBean[]{new MBean(new StringTest("hell"), "Domain2:type=instance1"), new MBean(new StringTest("helL"), "Domain2:type=instance2"), new MBean(new StringTest("Helloo"), "Domain2:type=instance3")}, Query.match(Query.attr("String"), Query.value("Hell?"))).test();
    }

    public void testMatchQuestionBeginningEnd() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new StringTest("Hello"), "Domain1:type=instance1"), new MBean(new StringTest("HellO"), "Domain1:type=instance2"), new MBean(new StringTest("hello"), "Domain1:type=instance3"), new MBean(new StringTest("hellO"), "Domain1:type=instance4"), new MBean(new StringTest(" ell "), "Domain1:type=instance5")}, new MBean[]{new MBean(new StringTest("hell"), "Domain2:type=instance1"), new MBean(new StringTest("helL"), "Domain2:type=instance2"), new MBean(new StringTest("ello"), "Domain2:type=instance3"), new MBean(new StringTest("Ello"), "Domain2:type=instance4"), new MBean(new StringTest("ell"), "Domain2:type=instance5"), new MBean(new StringTest("Helloo"), "Domain2:type=instance6"), new MBean(new StringTest("HHello"), "Domain2:type=instance7"), new MBean(new StringTest("HHelloo"), "Domain2:type=instance8")}, Query.match(Query.attr("String"), Query.value("?ell?"))).test();
    }

    public void testMatchQuestionEmbedded() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new StringTest("Hello"), "Domain1:type=instance1"), new MBean(new StringTest("HeLlo"), "Domain1:type=instance2"), new MBean(new StringTest("He lo"), "Domain1:type=instance3")}, new MBean[]{new MBean(new StringTest("hell"), "Domain2:type=instance1"), new MBean(new StringTest("ello"), "Domain2:type=instance2"), new MBean(new StringTest("ell"), "Domain2:type=instance3"), new MBean(new StringTest("Helloo"), "Domain2:type=instance4"), new MBean(new StringTest("HHello"), "Domain2:type=instance5"), new MBean(new StringTest("HHelloo"), "Domain2:type=instance6")}, Query.match(Query.attr("String"), Query.value("He?lo"))).test();
    }

    public void testMatchCharacterSet() throws Exception {
        try {
            new QueryTEST(new MBean[]{new MBean(new StringTest("Hello"), "Domain1:type=instance1"), new MBean(new StringTest("HeLlo"), "Domain1:type=instance2")}, new MBean[]{new MBean(new StringTest("hell"), "Domain2:type=instance1"), new MBean(new StringTest("ello"), "Domain2:type=instance2"), new MBean(new StringTest("ell"), "Domain2:type=instance3"), new MBean(new StringTest("Helloo"), "Domain2:type=instance4"), new MBean(new StringTest("HHello"), "Domain2:type=instance5"), new MBean(new StringTest("HHelloo"), "Domain2:type=instance6")}, Query.match(Query.attr("String"), Query.value("He[lL]lo"))).test();
        }
        catch (AssertionFailedError e) {
            QueryTestCase.fail((String)"FAILS IN RI: expected Hello to match He[lL]lo");
        }
    }

    public void testMatchCharacterRange() throws Exception {
        try {
            new QueryTEST(new MBean[]{new MBean(new StringTest("Hello"), "Domain1:type=instance1"), new MBean(new StringTest("Hemlo"), "Domain1:type=instance2")}, new MBean[]{new MBean(new StringTest("hell"), "Domain2:type=instance1"), new MBean(new StringTest("He lo"), "Domain2:type=instance2"), new MBean(new StringTest("Heklo"), "Domain2:type=instance3"), new MBean(new StringTest("Henlo"), "Domain2:type=instance4"), new MBean(new StringTest("HeLlo"), "Domain2:type=instance5"), new MBean(new StringTest("HeMlo"), "Domain2:type=instance6")}, Query.match(Query.attr("String"), Query.value("He[l-m]lo"))).test();
        }
        catch (AssertionFailedError e) {
            QueryTestCase.fail((String)"FAILS IN RI: didn't expected HeMlo to match He[l-m]lo");
        }
    }

    public void testEscapingQuestion() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new StringTest("Hello?"), "Domain1:type=instance1")}, new MBean[]{new MBean(new StringTest("Helloz"), "Domain2:type=instance1")}, Query.match(Query.attr("String"), Query.value("Hello\\?"))).test();
    }

    public void testEscapingAsterisk() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new StringTest("Hello*"), "Domain1:type=instance1")}, new MBean[]{new MBean(new StringTest("Helloz"), "Domain2:type=instance1")}, Query.match(Query.attr("String"), Query.value("Hello\\*"))).test();
    }

    public void testEscapingOpenBracket() throws Exception {
        new QueryTEST(new MBean[]{new MBean(new StringTest("Hello[ab]"), "Domain1:type=instance1")}, new MBean[]{new MBean(new StringTest("Helloa"), "Domain2:type=instance1"), new MBean(new StringTest("Hello\\a"), "Domain2:type=instance2")}, Query.match(Query.attr("String"), Query.value("Hello\\[ab]"))).test();
    }

    public void testMinusInCharacterSet() throws Exception {
        try {
            new QueryTEST(new MBean[]{new MBean(new StringTest("Hello-"), "Domain1:type=instance1")}, new MBean[]{new MBean(new StringTest("Hello[ab-]"), "Domain2:type=instance1")}, Query.match(Query.attr("String"), Query.value("Hello[ab-]"))).test();
        }
        catch (AssertionFailedError e) {
            QueryTestCase.fail((String)"FAILS IN RI: expected Hello- to match Hello[ab-]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testThreading() throws Exception {
        MBeanServer server1 = MBeanServerFactory.createMBeanServer("server1");
        MBeanServer server2 = MBeanServerFactory.createMBeanServer("server2");
        try {
            ObjectName name = new ObjectName("Domain1:type=instance1");
            NumberTest bean1 = new NumberTest(1);
            NumberTest bean2 = new NumberTest(2);
            server1.registerMBean(bean1, name);
            server2.registerMBean(bean2, name);
            QueryExp query = Query.eq(Query.attr("Number"), Query.value(2));
            QueryThread thread1 = new QueryThread(server1, query, 0);
            QueryThread thread2 = new QueryThread(server2, query, 1);
            thread1.start();
            thread2.start();
            thread1.join(10000L);
            thread1.check();
            thread2.join(10000L);
            thread2.check();
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server1);
            MBeanServerFactory.releaseMBeanServer(server2);
        }
    }

    public void testPathological() throws Exception {
        try {
            new QueryTEST(new MBean[]{new MBean(new StringTest("Hello(?:.)"), "Domain1:type=instance1")}, new MBean[]{new MBean(new StringTest("Hellox"), "Domain2:type=instance1")}, Query.match(Query.attr("String"), Query.value("Hello(?:.)"))).test();
        }
        catch (AssertionFailedError e) {
            QueryTestCase.fail((String)"FAILS IN JBossMX: expected Hello(?:.) to match Hello(?:.)");
        }
    }

    private void equalsTEST(ValueExp value1, ValueExp value2) throws Exception {
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.eq(value1, value1)).test();
        new QueryTEST(new MBean[0], new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, Query.eq(value1, value2)).test();
    }

    private void operationTEST(ValueExp value1, ValueExp value2, ValueExp div, ValueExp minus, ValueExp mult, ValueExp plus) throws Exception {
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.eq(Query.div(value2, value1), div)).test();
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.eq(Query.minus(value1, value2), minus)).test();
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.eq(Query.times(value1, value2), mult)).test();
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.eq(Query.plus(value1, value2), plus)).test();
    }

    private void catTEST(ValueExp value1, ValueExp value2, ValueExp cat) throws Exception {
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.eq(Query.plus(value1, value2), cat)).test();
    }

    private void comparisonTEST(ValueExp value1, ValueExp value2) throws Exception {
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.geq(value2, value1)).test();
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.geq(value1, value1)).test();
        new QueryTEST(new MBean[0], new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, Query.geq(value1, value2)).test();
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.gt(value2, value1)).test();
        new QueryTEST(new MBean[0], new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, Query.gt(value1, value2)).test();
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.leq(value1, value2)).test();
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.leq(value1, value1)).test();
        new QueryTEST(new MBean[0], new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, Query.leq(value2, value1)).test();
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.lt(value1, value2)).test();
        new QueryTEST(new MBean[0], new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, Query.lt(value2, value1)).test();
    }

    private void betweenTEST(ValueExp value1, ValueExp value2, ValueExp value3) throws Exception {
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.between(value2, value1, value3)).test();
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.between(value2, value2, value3)).test();
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.between(value2, value1, value2)).test();
        new QueryTEST(new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, new MBean[0], Query.between(value2, value2, value2)).test();
        new QueryTEST(new MBean[0], new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, Query.between(value1, value2, value3)).test();
        new QueryTEST(new MBean[0], new MBean[]{new MBean(new NumberTest(0), "Domain1:type=instance1")}, Query.between(value3, value1, value2)).test();
    }

    private void attrTEST(Object mbean, AttributeValueExp attr, ValueExp value1, ValueExp value2) throws Exception {
        new QueryTEST(new MBean[]{new MBean(mbean, "Domain1:type=instance1")}, new MBean[]{new MBean(new Trivial(), "Domain1:type=instance2")}, Query.eq(attr, value1)).test();
        new QueryTEST(new MBean[0], new MBean[]{new MBean(mbean, "Domain1:type=instance1")}, Query.eq(attr, value2)).test();
    }

    private void inTEST(ValueExp value1, ValueExp value2, ValueExp value3, ValueExp value4, ValueExp value5, ValueExp value6) throws Exception {
        new QueryTEST(new MBean[]{new MBean(new Trivial(), "Domain1:type=instance1")}, new MBean[0], Query.in(value1, new ValueExp[]{value1, value2, value3, value4, value5, value6})).test();
        new QueryTEST(new MBean[]{new MBean(new Trivial(), "Domain1:type=instance1")}, new MBean[0], Query.in(value6, new ValueExp[]{value1, value2, value3, value4, value5, value6})).test();
        new QueryTEST(new MBean[]{new MBean(new Trivial(), "Domain1:type=instance1")}, new MBean[0], Query.in(value3, new ValueExp[]{value1, value2, value3, value4, value5, value6})).test();
        new QueryTEST(new MBean[0], new MBean[]{new MBean(new Trivial(), "Domain1:type=instance1")}, Query.in(value1, new ValueExp[]{value2, value3, value4, value5, value6})).test();
    }

    public class QueryThread
    extends Thread {
        MBeanServer server;
        QueryExp query;
        int expected;
        int result;

        public QueryThread(MBeanServer server, QueryExp query, int expected) {
            this.server = server;
            this.query = query;
            this.expected = expected;
        }

        public int getExpected() {
            return this.expected;
        }

        public void check() {
            Assert.assertEquals((int)this.expected, (int)this.result);
        }

        public void run() {
            for (int i = 0; i < 1000; ++i) {
                this.result = this.server.queryNames(null, this.query).size();
                if (this.result == this.expected) continue;
                return;
            }
        }
    }

    private class QueryTEST {
        HashSet expectedInstances = new HashSet();
        HashSet expectedNames = new HashSet();
        QueryExp queryExp;
        MBeanServer server;

        public QueryTEST(MBean[] expected, MBean[] others, QueryExp queryExp) throws Exception {
            int i;
            this.queryExp = queryExp;
            this.server = MBeanServerFactory.createMBeanServer();
            for (i = 0; i < expected.length; ++i) {
                ObjectInstance instance = this.server.registerMBean(expected[i].mbean, expected[i].objectName);
                this.expectedInstances.add(instance);
                this.expectedNames.add(instance.getObjectName());
            }
            for (i = 0; i < others.length; ++i) {
                this.server.registerMBean(others[i].mbean, others[i].objectName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void test() throws Exception {
            try {
                this.testQueryMBeans();
                this.testQueryNames();
            }
            finally {
                MBeanServerFactory.releaseMBeanServer(this.server);
            }
        }

        public void testQueryMBeans() throws Exception {
            Set<ObjectInstance> result = this.server.queryMBeans(null, this.queryExp);
            for (ObjectInstance instance : result) {
                Iterator iterator2 = this.expectedInstances.iterator();
                boolean found = false;
                while (iterator2.hasNext()) {
                    if (!iterator2.next().equals(instance)) continue;
                    iterator2.remove();
                    found = true;
                    break;
                }
                if (found || instance.getObjectName().getDomain().equals("JMImplementation")) continue;
                Assert.fail((String)("Unexpected instance " + instance.getObjectName() + "\nfor query " + this.queryExp));
            }
            Iterator<ObjectInstance> iterator = this.expectedInstances.iterator();
            if (iterator.hasNext()) {
                ObjectInstance instance;
                instance = iterator.next();
                Assert.fail((String)("Expected instance " + instance.getObjectName() + "\nfor query " + this.queryExp));
            }
        }

        public void testQueryNames() throws Exception {
            Set<ObjectName> result = this.server.queryNames(null, this.queryExp);
            for (ObjectName name : result) {
                Iterator iterator2 = this.expectedNames.iterator();
                boolean found = false;
                while (iterator2.hasNext()) {
                    if (!iterator2.next().equals(name)) continue;
                    iterator2.remove();
                    found = true;
                    break;
                }
                if (found || name.getDomain().equals("JMImplementation")) continue;
                Assert.fail((String)("Unexpected name " + name + "\nfor query " + this.queryExp));
            }
            Iterator<ObjectName> iterator = this.expectedNames.iterator();
            if (iterator.hasNext()) {
                Assert.fail((String)("Expected instance " + iterator.next() + "\nfor query " + this.queryExp));
            }
        }
    }

    private class MBean {
        public Object mbean;
        public ObjectName objectName;

        public MBean(Object object, String name) throws Exception {
            this.mbean = object;
            this.objectName = new ObjectName(name);
        }
    }
}

