/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.loading;

import java.net.URL;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ServiceNotFoundException;
import javax.management.loading.MLet;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class MLetTEST
extends TestCase {
    private MBeanServer server;
    private URL location = ((Object)((Object)this)).getClass().getResource("/org/jboss/test/jmx/compliance/loading/MLetTEST.class");

    public MLetTEST(String s) throws Exception {
        super(s);
        String jarPath = this.location.getPath();
        int i = jarPath.indexOf(33);
        if (i != -1) {
            jarPath = jarPath.substring(0, i);
            this.location = new URL(jarPath);
            this.location = new URL(this.location, "file:../");
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.server = MBeanServerFactory.createMBeanServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateAndRegister() throws Exception {
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            this.server.registerMBean(mlet, name);
        }
        finally {
            this.server.unregisterMBean(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMLetLoadClassFromURLInConstructor() throws Exception {
        URL MBEANS_URL = new URL(this.location, "lib/jmxcompliance-MyMBeans.jar");
        try {
            this.server.getClassLoaderRepository().loadClass("org.jboss.test.jmx.compliance.loading.support.Trivial");
            MLetTEST.fail((String)"class org.jboss.test.jmx.compliance.loading.support.Trivial was already found in CL repository.");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName name = new ObjectName("test:name=mlet");
        MLet mlet = new MLet(new URL[]{MBEANS_URL});
        try {
            server.getClassLoaderRepository().loadClass("org.jboss.test.jmx.compliance.loading.support.Trivial");
            MLetTEST.fail((String)"class org.jboss.test.jmx.compliance.loading.support.Trivial found in CL repository after MLet construction.");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            server.registerMBean(mlet, name);
            server.getClassLoaderRepository().loadClass("org.jboss.test.jmx.compliance.loading.support.Trivial");
        }
        finally {
            server.unregisterMBean(name);
        }
        try {
            server.getClassLoaderRepository().loadClass("org.jboss.test.jmx.compliance.loading.support.Trivial");
            MLetTEST.fail((String)"class org.jboss.test.jmx.compliance.loading.support.Trivial was still found in CL repository.");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
    }

    public void testBasicMLetFileLoad() throws Exception {
        URL MLET_URL = new URL(this.location, "etc/tests/BasicConfig.mlet");
        try {
            this.server.getClassLoaderRepository().loadClass("org.jboss.test.jmx.compliance.loading.support.Trivial");
            MLetTEST.fail((String)"class org.jboss.test.jmx.compliance.loading.support.Trivial was already found in CL repository.");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            this.server.getClassLoaderRepository().loadClass("org.jboss.test.jmx.compliance.loading.support.Trivial2");
            MLetTEST.fail((String)"class org.jboss.test.jmx.compliance.loading.support.Trivial2 was already found in CL repository.");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        server.registerMBean(mlet, name);
        server.invoke(name, "getMBeansFromURL", new Object[]{MLET_URL.toString()}, new String[]{String.class.getName()});
        try {
            MLetTEST.assertTrue((boolean)server.isRegistered(new ObjectName("test:name=Trivial")));
            MLetTEST.assertTrue((boolean)server.isRegistered(new ObjectName("test:name=Trivial2")));
        }
        catch (AssertionFailedError e) {
            URL[] urls = mlet.getURLs();
            URL url = null;
            if (urls != null && urls.length > 0) {
                url = urls[0];
            }
            MLetTEST.fail((String)("FAILS IN RI: SUN JMX RI builds a malformed URL from an MLet text file URL '" + MLET_URL + "' resulting into MLET codebase URL '" + url + "' and therefore fails " + "to load the required classes from the Java archive (MyMBeans.jar)"));
        }
        MLetTEST.assertTrue((server.getMBeanInfo(new ObjectName("test:name=Trivial")) != null ? 1 : 0) != 0);
        MLetTEST.assertTrue((server.getMBeanInfo(new ObjectName("test:name=Trivial2")) != null ? 1 : 0) != 0);
        MLetTEST.assertTrue((boolean)server.getAttribute(new ObjectName("test:name=Trivial2"), "Something").equals("foo"));
        server.invoke(new ObjectName("test:name=Trivial"), "doOperation", new Object[]{"Test"}, new String[]{String.class.getName()});
        server.invoke(new ObjectName("test:name=Trivial2"), "doOperation", new Object[]{"Test"}, new String[]{String.class.getName()});
    }

    public void testConflictingMLetFileLoad() throws Exception {
        URL MLET_URL1 = new URL(this.location, "etc/tests/BasicConfig2.mlet");
        URL MLET_URL2 = new URL(this.location, "etc/tests/BasicConfig2.mlet");
        try {
            this.server.getClassLoaderRepository().loadClass("org.jboss.test.jmx.compliance.loading.support.Trivial3");
            MLetTEST.fail((String)"class org.jboss.test.jmx.compliance.loading.support.Trivial was already found in CL repository.");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            this.server.getClassLoaderRepository().loadClass("org.jboss.test.jmx.compliance.loading.support.Trivial4");
            MLetTEST.fail((String)"class org.jboss.test.jmx.compliance.loading.support.Trivial2 was already found in CL repository.");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        server.registerMBean(mlet, name);
        Set result = (Set)server.invoke(name, "getMBeansFromURL", new Object[]{MLET_URL1.toString()}, new String[]{String.class.getName()});
        this.checkResult(result);
        ObjectName oname = new ObjectName("test:name=Trivial2");
        server.setAttribute(oname, new Attribute("Something", "Something"));
        mlet = new MLet();
        name = new ObjectName("test:name=mlet2");
        server.registerMBean(mlet, name);
        server.invoke(name, "getMBeansFromURL", new Object[]{MLET_URL2.toString()}, new String[]{String.class.getName()});
        oname = new ObjectName("test:name=Trivial2");
        String value = (String)server.getAttribute(oname, "Something");
        MLetTEST.assertTrue((boolean)value.equals("Something"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMalformedURLLoad() throws Exception {
        URL MLET_URL = new URL(this.location, "etc/tests/BasicConfig.mlet");
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            server.registerMBean(mlet, name);
            server.invoke(name, "getMBeansFromURL", new Object[]{MLET_URL.getPath()}, new String[]{String.class.getName()});
            MLetTEST.fail((String)"FAILS IN RI: Malformed URL in getMBeansURL() should result in ServiceNotFoundException thrown.");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (MBeanException e) {
            MLetTEST.assertTrue((boolean)(e.getTargetException() instanceof ServiceNotFoundException));
        }
        finally {
            try {
                server.unregisterMBean(name);
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingMLetTagInLoad() throws Exception {
        URL MLET_URL = new URL(this.location, "etc/tests/MissingMLET.mlet");
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            server.registerMBean(mlet, name);
            server.invoke(name, "getMBeansFromURL", new Object[]{MLET_URL.toString()}, new String[]{String.class.getName()});
            MLetTEST.fail((String)"MLet text file missing the MLET tag should result in ServiceNotFoundException thrown.");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (MBeanException e) {
            MLetTEST.assertTrue((boolean)(e.getTargetException() instanceof ServiceNotFoundException));
        }
        finally {
            try {
                server.unregisterMBean(name);
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingMandatoryArchiveTagInLoad() throws Exception {
        URL MLET_URL = new URL(this.location, "etc/tests/MissingMandatoryArchive.mlet");
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            server.registerMBean(mlet, name);
            server.invoke(name, "getMBeansFromURL", new Object[]{MLET_URL.toString()}, new String[]{String.class.getName()});
            MLetTEST.fail((String)"MLet text file missing mandatory ARCHIVE attribute should result in ServiceNotFoundException thrown.");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (MBeanException e) {
            MLetTEST.assertTrue((boolean)(e.getTargetException() instanceof ServiceNotFoundException));
        }
        finally {
            try {
                server.unregisterMBean(name);
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingMandatoryCodeTagInLoad() throws Exception {
        URL MLET_URL = new URL(this.location, "etc/tests/MissingMandatoryCode.mlet");
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            server.registerMBean(mlet, name);
            server.invoke(name, "getMBeansFromURL", new Object[]{MLET_URL.toString()}, new String[]{String.class.getName()});
            MLetTEST.fail((String)"MLet text file missing mandatory CODE attribute should result in ServiceNotFoundException thrown.");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (MBeanException e) {
            MLetTEST.assertTrue((boolean)(e.getTargetException() instanceof ServiceNotFoundException));
        }
        finally {
            try {
                server.unregisterMBean(name);
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testArchiveListInMLet() throws Exception {
        URL MLET_URL = new URL(this.location, "etc/tests/ArchiveList.mlet");
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            server.registerMBean(mlet, name);
            server.invoke(name, "getMBeansFromURL", new Object[]{MLET_URL.toString()}, new String[]{String.class.getName()});
            Class<?> c = null;
            try {
                c = mlet.loadClass("org.jboss.test.jmx.compliance.loading.support.AClass");
            }
            catch (ClassNotFoundException e) {
                URL[] urls = mlet.getURLs();
                MLetTEST.fail((String)("FAILS IN RI: SUN JMX RI builds a malformed URL from an MLet text file URL '" + MLET_URL + "' resulting into MLET codebase URL '" + urls[0] + "' and therefore fails " + "to load the required classes from the Java archive."));
            }
            Object o = c.newInstance();
            server.setAttribute(new ObjectName("test:name=AnotherTrivial"), new Attribute("Something", o));
            o = server.getAttribute(new ObjectName("test:name=AnotherTrivial"), "Something");
            MLetTEST.assertTrue((boolean)o.getClass().isAssignableFrom(c));
        }
        finally {
            try {
                server.unregisterMBean(name);
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnexpectedEndOfFile() throws Exception {
        URL MLET_URL = new URL(this.location, "etc/tests/UnexpectedEnd.mlet");
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            server.registerMBean(mlet, name);
            server.invoke(name, "getMBeansFromURL", new Object[]{MLET_URL.toString()}, new String[]{String.class.getName()});
            MLetTEST.fail((String)"Unexpected end of file from mlet text file did not cause an exception.");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (MBeanException e) {
            MLetTEST.assertTrue((boolean)(e.getTargetException() instanceof ServiceNotFoundException));
        }
        finally {
            try {
                server.unregisterMBean(name);
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingEndMLetTag() throws Exception {
        URL MLET_URL = new URL(this.location, "etc/tests/MissingEndTag.mlet");
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MLet mlet = new MLet();
        ObjectName name = new ObjectName("test:name=mlet");
        try {
            server.registerMBean(mlet, name);
            server.invoke(name, "getMBeansFromURL", new Object[]{MLET_URL.toString()}, new String[]{String.class.getName()});
            MLetTEST.assertTrue((!server.isRegistered(new ObjectName("test:name=Trivial")) ? 1 : 0) != 0);
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (MBeanException e) {
            MLetTEST.assertTrue((boolean)(e.getTargetException() instanceof ServiceNotFoundException));
        }
        finally {
            try {
                server.unregisterMBean(name);
            }
            catch (Exception ignored) {}
        }
    }

    protected void checkResult(Set result) {
        for (Object mbean : result) {
            if (!(mbean instanceof Throwable)) continue;
            throw new RuntimeException((Throwable)mbean);
        }
    }
}

