/*    */ package org.slf4j.impl;
/*    */ 
/*    */ import java.util.HashMap;
/*    */ import java.util.Map;
/*    */ import org.apache.log4j.LogManager;
/*    */ import org.slf4j.ILoggerFactory;
/*    */ 
/*    */ public class Log4jLoggerFactory
/*    */   implements ILoggerFactory
/*    */ {
/*    */   Map loggerMap;
/*    */ 
/*    */   public Log4jLoggerFactory()
/*    */   {
/* 55 */     this.loggerMap = new HashMap();
/*    */   }
/*    */ 
/*    */   public org.slf4j.Logger getLogger(String name)
/*    */   {
/* 64 */     org.slf4j.Logger slf4jLogger = null;
/*    */ 
/* 66 */     synchronized (this) {
/* 67 */       slf4jLogger = (org.slf4j.Logger)this.loggerMap.get(name);
/* 68 */       if (slf4jLogger == null)
/*    */       {
/*    */         org.apache.log4j.Logger log4jLogger;
/*    */         org.apache.log4j.Logger log4jLogger;
/* 70 */         if (name.equalsIgnoreCase("ROOT"))
/* 71 */           log4jLogger = LogManager.getRootLogger();
/*    */         else {
/* 73 */           log4jLogger = LogManager.getLogger(name);
/*    */         }
/* 75 */         slf4jLogger = new Log4jLoggerAdapter(log4jLogger);
/* 76 */         this.loggerMap.put(name, slf4jLogger);
/*    */       }
/*    */     }
/* 79 */     return slf4jLogger;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.slf4j.impl.Log4jLoggerFactory
 * JD-Core Version:    0.6.0
 */