/*     */ package org.slf4j.helpers;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Vector;
/*     */ import org.slf4j.Marker;
/*     */ 
/*     */ public class BasicMarker
/*     */   implements Marker
/*     */ {
/*     */   private static final long serialVersionUID = 1803952589649545191L;
/*     */   final String name;
/*     */   List children;
/* 144 */   private static String OPEN = "[ ";
/* 145 */   private static String CLOSE = " ]";
/* 146 */   private static String SEP = ", ";
/*     */ 
/*     */   BasicMarker(String name)
/*     */   {
/*  55 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getName() {
/*  59 */     return this.name;
/*     */   }
/*     */ 
/*     */   public synchronized void add(Marker child) {
/*  63 */     if (child == null) {
/*  64 */       throw new NullPointerException("Null children cannot be added to a Marker.");
/*     */     }
/*     */ 
/*  67 */     if (this.children == null) {
/*  68 */       this.children = new Vector();
/*     */     }
/*  70 */     this.children.add(child);
/*     */   }
/*     */ 
/*     */   public synchronized boolean hasChildren() {
/*  74 */     return (this.children != null) && (this.children.size() > 0);
/*     */   }
/*     */ 
/*     */   public synchronized Iterator iterator() {
/*  78 */     if (this.children != null) {
/*  79 */       return this.children.iterator();
/*     */     }
/*  81 */     return Collections.EMPTY_LIST.iterator();
/*     */   }
/*     */ 
/*     */   public synchronized boolean remove(Marker markerToRemove)
/*     */   {
/*  86 */     if (this.children == null) {
/*  87 */       return false;
/*     */     }
/*     */ 
/*  90 */     int size = this.children.size();
/*  91 */     for (int i = 0; i < size; i++) {
/*  92 */       Marker m = (Marker)this.children.get(i);
/*  93 */       if (m == markerToRemove) {
/*  94 */         return false;
/*     */       }
/*     */     }
/*     */ 
/*  98 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean contains(Marker other) {
/* 102 */     if (other == null) {
/* 103 */       throw new IllegalArgumentException("Other cannot be null");
/*     */     }
/*     */ 
/* 106 */     if (this == other) {
/* 107 */       return true;
/*     */     }
/*     */ 
/* 110 */     if (hasChildren()) {
/* 111 */       for (int i = 0; i < this.children.size(); i++) {
/* 112 */         Marker child = (Marker)this.children.get(i);
/* 113 */         if (child.contains(other)) {
/* 114 */           return true;
/*     */         }
/*     */       }
/*     */     }
/* 118 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean contains(String name)
/*     */   {
/* 125 */     if (name == null) {
/* 126 */       throw new IllegalArgumentException("Other cannot be null");
/*     */     }
/*     */ 
/* 129 */     if (this.name.equals(name)) {
/* 130 */       return true;
/*     */     }
/*     */ 
/* 133 */     if (hasChildren()) {
/* 134 */       for (int i = 0; i < this.children.size(); i++) {
/* 135 */         Marker child = (Marker)this.children.get(i);
/* 136 */         if (child.contains(name)) {
/* 137 */           return true;
/*     */         }
/*     */       }
/*     */     }
/* 141 */     return false;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 150 */     if (!hasChildren()) {
/* 151 */       return getName();
/*     */     }
/*     */ 
/* 154 */     Iterator it = iterator();
/*     */ 
/* 156 */     StringBuffer sb = new StringBuffer(getName());
/* 157 */     sb.append(' ').append(OPEN);
/* 158 */     while (it.hasNext()) {
/* 159 */       Marker child = (Marker)it.next();
/* 160 */       sb.append(child.getName());
/* 161 */       if (it.hasNext()) {
/* 162 */         sb.append(SEP);
/*     */       }
/*     */     }
/* 165 */     sb.append(CLOSE);
/*     */ 
/* 167 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.slf4j.helpers.BasicMarker
 * JD-Core Version:    0.6.0
 */