/*     */ package org.slf4j;
/*     */ 
/*     */ import org.slf4j.helpers.Util;
/*     */ import org.slf4j.impl.StaticLoggerBinder;
/*     */ 
/*     */ public final class LoggerFactory
/*     */ {
/*     */   static ILoggerFactory loggerFactory;
/*     */   static final String NO_STATICLOGGERBINDER_URL = "http://www.slf4j.org/codes.html#StaticLoggerBinder";
/*     */   static final String NULL_LF_URL = "http://www.slf4j.org/codes.html#null_LF";
/*     */ 
/*     */   public static Logger getLogger(String name)
/*     */   {
/*  85 */     if (loggerFactory == null) {
/*  86 */       throw new IllegalStateException("Logging factory implementation cannot be null. See also http://www.slf4j.org/codes.html#null_LF");
/*     */     }
/*  88 */     return loggerFactory.getLogger(name);
/*     */   }
/*     */ 
/*     */   public static Logger getLogger(Class clazz)
/*     */   {
/* 100 */     if (loggerFactory == null) {
/* 101 */       throw new IllegalStateException("Logging factory implementation cannot be null. See also http://www.slf4j.org/codes.html#null_LF");
/*     */     }
/* 103 */     return loggerFactory.getLogger(clazz.getName());
/*     */   }
/*     */ 
/*     */   public static ILoggerFactory getILoggerFactory()
/*     */   {
/* 115 */     return loggerFactory;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  60 */       loggerFactory = StaticLoggerBinder.SINGLETON.getLoggerFactory();
/*     */     } catch (NoClassDefFoundError ncde) {
/*  62 */       String msg = ncde.getMessage();
/*  63 */       if ((msg != null) && (msg.indexOf("org/slf4j/impl/StaticLoggerBinder") != -1)) {
/*  64 */         Util.reportFailure("Failed to load class \"org.slf4j.impl.StaticLoggerBinder\".");
/*  65 */         Util.reportFailure("See http://www.slf4j.org/codes.html#StaticLoggerBinder for further details.");
/*     */       }
/*     */ 
/*  68 */       throw ncde;
/*     */     }
/*     */     catch (Exception e) {
/*  71 */       Util.reportFailure("Failed to instantiate logger [" + StaticLoggerBinder.SINGLETON.getLoggerFactoryClassStr() + "]", e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.slf4j.LoggerFactory
 * JD-Core Version:    0.6.0
 */