/*     */ package org.quartz.xml;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ 
/*     */ public class ValidationException extends Exception
/*     */ {
/*  42 */   private Collection validationExceptions = new ArrayList();
/*     */ 
/*     */   public ValidationException()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ValidationException(String message)
/*     */   {
/*  66 */     super(message);
/*     */   }
/*     */ 
/*     */   public ValidationException(Collection errors)
/*     */   {
/*  76 */     this();
/*  77 */     this.validationExceptions = Collections.unmodifiableCollection(this.validationExceptions);
/*     */   }
/*     */ 
/*     */   public Collection getValidationExceptions()
/*     */   {
/*  95 */     return this.validationExceptions;
/*     */   }
/*     */ 
/*     */   public String getMessage()
/*     */   {
/* 104 */     if (getValidationExceptions().size() == 0) return super.getMessage();
/*     */ 
/* 106 */     StringBuffer sb = new StringBuffer();
/*     */ 
/* 108 */     boolean first = true;
/*     */ 
/* 110 */     Iterator iter = getValidationExceptions().iterator();
/* 111 */     while (iter.hasNext()) {
/* 112 */       Exception e = (Exception)iter.next();
/*     */ 
/* 114 */       if (!first) {
/* 115 */         sb.append('\n');
/* 116 */         first = false;
/*     */       }
/*     */ 
/* 119 */       sb.append(e.getMessage());
/*     */     }
/*     */ 
/* 122 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.xml.ValidationException
 * JD-Core Version:    0.6.0
 */