/*     */ package org.quartz.xml;
/*     */ 
/*     */ import org.quartz.Calendar;
/*     */ 
/*     */ public class CalendarBundle
/*     */   implements Calendar
/*     */ {
/*     */   protected String calendarName;
/*     */   protected String className;
/*     */   protected Calendar calendar;
/*     */   protected boolean replace;
/*     */ 
/*     */   public String getCalendarName()
/*     */   {
/*  67 */     return this.calendarName;
/*     */   }
/*     */ 
/*     */   public void setCalendarName(String calendarName) {
/*  71 */     this.calendarName = calendarName;
/*     */   }
/*     */ 
/*     */   public String getClassName() {
/*  75 */     return this.className;
/*     */   }
/*     */ 
/*     */   public void setClassName(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException
/*     */   {
/*  80 */     this.className = className;
/*  81 */     createCalendar();
/*     */   }
/*     */ 
/*     */   public Calendar getCalendar() {
/*  85 */     return this.calendar;
/*     */   }
/*     */ 
/*     */   public void setCalendar(Calendar calendar) {
/*  89 */     this.calendar = calendar;
/*     */   }
/*     */ 
/*     */   public boolean getReplace() {
/*  93 */     return this.replace;
/*     */   }
/*     */ 
/*     */   public void setReplace(boolean replace) {
/*  97 */     this.replace = replace;
/*     */   }
/*     */ 
/*     */   public Calendar getBaseCalendar() {
/* 101 */     return this.calendar.getBaseCalendar();
/*     */   }
/*     */ 
/*     */   public void setBaseCalendar(Calendar baseCalendar) {
/* 105 */     if ((baseCalendar instanceof CalendarBundle)) {
/* 106 */       baseCalendar = ((CalendarBundle)baseCalendar).getCalendar();
/*     */     }
/* 108 */     this.calendar.setBaseCalendar(baseCalendar);
/*     */   }
/*     */ 
/*     */   public String getDescription() {
/* 112 */     return this.calendar.getDescription();
/*     */   }
/*     */ 
/*     */   public void setDescription(String description) {
/* 116 */     this.calendar.setDescription(description);
/*     */   }
/*     */ 
/*     */   public boolean isTimeIncluded(long timeStamp) {
/* 120 */     return this.calendar.isTimeIncluded(timeStamp);
/*     */   }
/*     */ 
/*     */   public long getNextIncludedTime(long timeStamp) {
/* 124 */     return this.calendar.getNextIncludedTime(timeStamp);
/*     */   }
/*     */ 
/*     */   protected void createCalendar() throws ClassNotFoundException, InstantiationException, IllegalAccessException
/*     */   {
/* 129 */     Class clazz = Thread.currentThread().getContextClassLoader().loadClass(getClassName());
/* 130 */     setCalendar((Calendar)clazz.newInstance());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.xml.CalendarBundle
 * JD-Core Version:    0.6.0
 */