/*     */ package org.quartz.utils;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.sql.DataSource;
/*     */ import javax.sql.XAConnection;
/*     */ import javax.sql.XADataSource;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ 
/*     */ public class JNDIConnectionProvider
/*     */   implements ConnectionProvider
/*     */ {
/*     */   private String url;
/*     */   private Properties props;
/*     */   private Object datasource;
/*  67 */   private boolean alwaysLookup = false;
/*     */ 
/*     */   public JNDIConnectionProvider(String jndiUrl, boolean alwaysLookup)
/*     */   {
/*  84 */     this.url = jndiUrl;
/*  85 */     this.alwaysLookup = alwaysLookup;
/*  86 */     init();
/*     */   }
/*     */ 
/*     */   public JNDIConnectionProvider(String jndiUrl, Properties jndiProps, boolean alwaysLookup)
/*     */   {
/* 100 */     this.url = jndiUrl;
/* 101 */     this.props = jndiProps;
/* 102 */     this.alwaysLookup = alwaysLookup;
/* 103 */     init();
/*     */   }
/*     */ 
/*     */   Log getLog()
/*     */   {
/* 115 */     return LogFactory.getLog(getClass());
/*     */   }
/*     */ 
/*     */   private void init()
/*     */   {
/* 120 */     if (!isAlwaysLookup()) {
/* 121 */       Context ctx = null;
/*     */       try {
/* 123 */         if (this.props != null) ctx = new InitialContext(this.props);
/*     */         else {
/* 125 */           ctx = new InitialContext();
/*     */         }
/* 127 */         this.datasource = ((DataSource)ctx.lookup(this.url));
/*     */       } catch (Exception e) {
/* 129 */         getLog().error("Error looking up datasource: " + e.getMessage(), e);
/*     */       }
/*     */       finally
/*     */       {
/* 133 */         if (ctx != null) try {
/* 134 */             ctx.close(); } catch (Exception ignore) {
/*     */           } 
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Connection getConnection() throws SQLException {
/* 140 */     Context ctx = null;
/*     */     try {
/* 142 */       Object ds = this.datasource;
/*     */ 
/* 144 */       if ((ds == null) || (isAlwaysLookup())) {
/* 145 */         if (this.props != null) ctx = new InitialContext(this.props);
/*     */         else {
/* 147 */           ctx = new InitialContext();
/*     */         }
/* 149 */         ds = ctx.lookup(this.url);
/* 150 */         if (!isAlwaysLookup()) this.datasource = ds;
/*     */       }
/*     */ 
/* 153 */       if (ds == null)
/* 154 */         throw new SQLException("There is no object at the JNDI URL '" + this.url + "'");
/* 157 */       Connection localConnection;
/* 157 */       if ((ds instanceof XADataSource)) { localConnection = ((XADataSource)ds).getXAConnection().getConnection(); jsr 133;
/*     */       }
/* 159 */       if ((ds instanceof DataSource)) { localConnection = ((DataSource)ds).getConnection(); jsr 111;
/*     */       }
/*     */ 
/* 162 */       throw new SQLException("Object at JNDI URL '" + this.url + "' is not a DataSource.");
/*     */     }
/*     */     catch (Exception e) {
/* 165 */       this.datasource = null;
/* 166 */       throw new SQLException("Could not retrieve datasource via JNDI url '" + this.url + "' " + e.getClass().getName() + ": " + e.getMessage());
/*     */     }
/*     */     finally
/*     */     {
/* 171 */       if (ctx != null) try {
/* 172 */           ctx.close(); } catch (Exception ignore) {
/*     */         } 
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isAlwaysLookup() {
/* 177 */     return this.alwaysLookup;
/*     */   }
/*     */ 
/*     */   public void setAlwaysLookup(boolean b) {
/* 181 */     this.alwaysLookup = b;
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.utils.JNDIConnectionProvider
 * JD-Core Version:    0.6.0
 */