/*     */ package org.quartz.utils;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class DirtyFlagMap
/*     */   implements Map, Cloneable, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1433884852607126222L;
/*  48 */   private boolean dirty = false;
/*  49 */   private transient boolean locked = false;
/*     */   private Map map;
/*     */ 
/*     */   public DirtyFlagMap(Map mapToWrap)
/*     */   {
/*  66 */     if (mapToWrap == null) {
/*  67 */       throw new IllegalArgumentException("mapToWrap cannot be null!");
/*     */     }
/*  69 */     this.map = mapToWrap;
/*     */   }
/*     */ 
/*     */   public DirtyFlagMap()
/*     */   {
/*  80 */     this.map = new HashMap();
/*     */   }
/*     */ 
/*     */   public DirtyFlagMap(int initialCapacity)
/*     */   {
/*  92 */     this.map = new HashMap(initialCapacity);
/*     */   }
/*     */ 
/*     */   public DirtyFlagMap(int initialCapacity, float loadFactor)
/*     */   {
/* 104 */     this.map = new HashMap(initialCapacity, loadFactor);
/*     */   }
/*     */ 
/*     */   public void setMutable(boolean mutable)
/*     */   {
/* 117 */     this.locked = (!mutable);
/* 118 */     if (this.locked)
/* 119 */       this.map = Collections.unmodifiableMap(this.map);
/*     */     else
/* 121 */       this.map = new HashMap(this.map);
/*     */   }
/*     */ 
/*     */   public boolean isMutable()
/*     */   {
/* 126 */     return !this.locked;
/*     */   }
/*     */ 
/*     */   public void clearDirtyFlag()
/*     */   {
/* 135 */     this.dirty = false;
/*     */   }
/*     */ 
/*     */   public boolean isDirty()
/*     */   {
/* 144 */     return this.dirty;
/*     */   }
/*     */ 
/*     */   public Map getWrappedMap()
/*     */   {
/* 153 */     return this.map;
/*     */   }
/*     */ 
/*     */   public void clear() {
/* 157 */     this.dirty = true;
/*     */ 
/* 159 */     this.map.clear();
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object key) {
/* 163 */     return this.map.containsKey(key);
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object val) {
/* 167 */     return this.map.containsValue(val);
/*     */   }
/*     */ 
/*     */   public Set entrySet() {
/* 171 */     return this.map.entrySet();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj) {
/* 175 */     if ((obj == null) || (!(obj instanceof DirtyFlagMap))) return false;
/*     */ 
/* 177 */     return this.map.equals(((DirtyFlagMap)obj).getWrappedMap());
/*     */   }
/*     */ 
/*     */   public Object get(Object key) {
/* 181 */     return this.map.get(key);
/*     */   }
/*     */ 
/*     */   public boolean isEmpty() {
/* 185 */     return this.map.isEmpty();
/*     */   }
/*     */ 
/*     */   public Set keySet() {
/* 189 */     return this.map.keySet();
/*     */   }
/*     */ 
/*     */   public Object put(Object key, Object val) {
/* 193 */     this.dirty = true;
/*     */ 
/* 195 */     return this.map.put(key, val);
/*     */   }
/*     */ 
/*     */   public void putAll(Map t) {
/* 199 */     if (!t.isEmpty()) this.dirty = true;
/*     */ 
/* 201 */     this.map.putAll(t);
/*     */   }
/*     */ 
/*     */   public Object remove(Object key) {
/* 205 */     Object obj = this.map.remove(key);
/*     */ 
/* 207 */     if (obj != null) this.dirty = true;
/*     */ 
/* 209 */     return obj;
/*     */   }
/*     */ 
/*     */   public int size() {
/* 213 */     return this.map.size();
/*     */   }
/*     */ 
/*     */   public Collection values() {
/* 217 */     return this.map.values();
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try {
/* 223 */       DirtyFlagMap copy = (DirtyFlagMap)super.clone();
/* 224 */       if ((this.map instanceof HashMap))
/* 225 */         copy.map = ((Serializable)((HashMap)this.map).clone());
/*     */     } catch (CloneNotSupportedException ex) {
/* 227 */       throw new IncompatibleClassChangeError("Not Cloneable.");
/*     */     }
/*     */     DirtyFlagMap copy;
/* 230 */     return copy;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.utils.DirtyFlagMap
 * JD-Core Version:    0.6.0
 */