/*     */ package org.quartz.utils;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.util.HashMap;
/*     */ 
/*     */ public class DBConnectionManager
/*     */ {
/*     */   public static final String DB_PROPS_PREFIX = "org.quartz.db.";
/*  62 */   private static DBConnectionManager instance = new DBConnectionManager();
/*     */ 
/*  64 */   private HashMap providers = new HashMap();
/*     */ 
/*     */   public void addConnectionProvider(String dataSourceName, ConnectionProvider provider)
/*     */   {
/*  93 */     this.providers.put(dataSourceName, provider);
/*     */   }
/*     */ 
/*     */   public Connection getConnection(String dsName)
/*     */     throws SQLException
/*     */   {
/* 105 */     ConnectionProvider provider = (ConnectionProvider)this.providers.get(dsName);
/*     */ 
/* 107 */     if (provider == null) {
/* 108 */       throw new SQLException("There is no DataSource named '" + dsName + "'");
/*     */     }
/*     */ 
/* 111 */     return provider.getConnection();
/*     */   }
/*     */ 
/*     */   public static DBConnectionManager getInstance()
/*     */   {
/* 122 */     return instance;
/*     */   }
/*     */ 
/*     */   public void shutdown(String dsName)
/*     */     throws SQLException
/*     */   {
/* 136 */     ConnectionProvider provider = (ConnectionProvider)this.providers.get(dsName);
/*     */ 
/* 138 */     if (provider == null) {
/* 139 */       throw new SQLException("There is no DataSource named '" + dsName + "'");
/*     */     }
/*     */ 
/* 142 */     provider.shutdown();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.utils.DBConnectionManager
 * JD-Core Version:    0.6.0
 */