/*      */ package org.quartz.simpl;
/*      */ 
/*      */ import org.quartz.Trigger;
/*      */ 
/*      */ class TriggerWrapper
/*      */ {
/*      */   public String key;
/*      */   public String jobKey;
/*      */   public Trigger trigger;
/* 1468 */   public int state = 0;
/*      */   public static final int STATE_WAITING = 0;
/*      */   public static final int STATE_ACQUIRED = 1;
/*      */   public static final int STATE_EXECUTING = 2;
/*      */   public static final int STATE_COMPLETE = 3;
/*      */   public static final int STATE_PAUSED = 4;
/*      */   public static final int STATE_BLOCKED = 5;
/*      */   public static final int STATE_PAUSED_BLOCKED = 6;
/*      */   public static final int STATE_ERROR = 7;
/*      */ 
/*      */   TriggerWrapper(Trigger trigger)
/*      */   {
/* 1487 */     this.trigger = trigger;
/* 1488 */     this.key = getTriggerNameKey(trigger);
/* 1489 */     this.jobKey = JobWrapper.getJobNameKey(trigger.getJobName(), trigger.getJobGroup());
/*      */   }
/*      */ 
/*      */   TriggerWrapper(Trigger trigger, String key)
/*      */   {
/* 1494 */     this.trigger = trigger;
/* 1495 */     this.key = key;
/* 1496 */     this.jobKey = JobWrapper.getJobNameKey(trigger.getJobName(), trigger.getJobGroup());
/*      */   }
/*      */ 
/*      */   static String getTriggerNameKey(Trigger trigger)
/*      */   {
/* 1501 */     return trigger.getGroup() + "_$x$x$_" + trigger.getName();
/*      */   }
/*      */ 
/*      */   static String getTriggerNameKey(String triggerName, String groupName) {
/* 1505 */     return groupName + "_$x$x$_" + triggerName;
/*      */   }
/*      */ 
/*      */   public boolean equals(Object obj) {
/* 1509 */     if ((obj instanceof TriggerWrapper)) {
/* 1510 */       TriggerWrapper tw = (TriggerWrapper)obj;
/* 1511 */       if (tw.key.equals(this.key)) return true;
/*      */     }
/*      */ 
/* 1514 */     return false;
/*      */   }
/*      */ 
/*      */   public int hashCode() {
/* 1518 */     return this.key.hashCode();
/*      */   }
/*      */ 
/*      */   public Trigger getTrigger()
/*      */   {
/* 1523 */     return this.trigger;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.simpl.TriggerWrapper
 * JD-Core Version:    0.6.0
 */