/*     */ package org.quartz.simpl;
/*     */ 
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.quartz.SchedulerConfigException;
/*     */ import org.quartz.spi.ThreadPool;
/*     */ 
/*     */ public class SimpleThreadPool
/*     */   implements ThreadPool
/*     */ {
/*  57 */   private int count = -1;
/*     */ 
/*  59 */   private int prio = 5;
/*     */ 
/*  61 */   private boolean isShutdown = false;
/*     */ 
/*  63 */   private boolean inheritLoader = false;
/*     */ 
/*  65 */   private boolean inheritGroup = true;
/*     */ 
/*  67 */   private boolean makeThreadsDaemons = false;
/*     */   private ThreadGroup threadGroup;
/*     */   private Runnable nextRunnable;
/*  73 */   private Object nextRunnableLock = new Object();
/*     */   private WorkerThread[] workers;
/*  77 */   private String threadNamePrefix = "SimpleThreadPoolWorker";
/*     */ 
/*     */   public SimpleThreadPool()
/*     */   {
/*     */   }
/*     */ 
/*     */   public SimpleThreadPool(int threadCount, int threadPriority)
/*     */   {
/* 113 */     setThreadCount(threadCount);
/* 114 */     setThreadPriority(threadPriority);
/*     */   }
/*     */ 
/*     */   public Log getLog()
/*     */   {
/* 126 */     return LogFactory.getLog(SimpleThreadPool.class);
/*     */   }
/*     */ 
/*     */   public int getPoolSize() {
/* 130 */     return getThreadCount();
/*     */   }
/*     */ 
/*     */   public void setThreadCount(int count)
/*     */   {
/* 140 */     this.count = count;
/*     */   }
/*     */ 
/*     */   public int getThreadCount()
/*     */   {
/* 149 */     return this.count;
/*     */   }
/*     */ 
/*     */   public void setThreadPriority(int prio)
/*     */   {
/* 159 */     this.prio = prio;
/*     */   }
/*     */ 
/*     */   public int getThreadPriority()
/*     */   {
/* 168 */     return this.prio;
/*     */   }
/*     */ 
/*     */   public void setThreadNamePrefix(String prfx) {
/* 172 */     this.threadNamePrefix = prfx;
/*     */   }
/*     */ 
/*     */   public String getThreadNamePrefix() {
/* 176 */     return this.threadNamePrefix;
/*     */   }
/*     */ 
/*     */   public boolean isThreadsInheritContextClassLoaderOfInitializingThread()
/*     */   {
/* 184 */     return this.inheritLoader;
/*     */   }
/*     */ 
/*     */   public void setThreadsInheritContextClassLoaderOfInitializingThread(boolean inheritLoader)
/*     */   {
/* 194 */     this.inheritLoader = inheritLoader;
/*     */   }
/*     */ 
/*     */   public boolean isThreadsInheritGroupOfInitializingThread() {
/* 198 */     return this.inheritGroup;
/*     */   }
/*     */ 
/*     */   public void setThreadsInheritGroupOfInitializingThread(boolean inheritGroup)
/*     */   {
/* 203 */     this.inheritGroup = inheritGroup;
/*     */   }
/*     */ 
/*     */   public boolean isMakeThreadsDaemons()
/*     */   {
/* 211 */     return this.makeThreadsDaemons;
/*     */   }
/*     */ 
/*     */   public void setMakeThreadsDaemons(boolean makeThreadsDaemons)
/*     */   {
/* 219 */     this.makeThreadsDaemons = makeThreadsDaemons;
/*     */   }
/*     */ 
/*     */   public void initialize() throws SchedulerConfigException
/*     */   {
/* 224 */     if (this.count <= 0) {
/* 225 */       throw new SchedulerConfigException("Thread count must be > 0");
/*     */     }
/* 227 */     if ((this.prio <= 0) || (this.prio > 9)) {
/* 228 */       throw new SchedulerConfigException("Thread priority must be > 0 and <= 9");
/*     */     }
/*     */ 
/* 231 */     if (isThreadsInheritGroupOfInitializingThread()) {
/* 232 */       this.threadGroup = Thread.currentThread().getThreadGroup();
/*     */     }
/*     */     else {
/* 235 */       this.threadGroup = Thread.currentThread().getThreadGroup();
/* 236 */       ThreadGroup parent = this.threadGroup;
/* 237 */       while (!parent.getName().equals("main"))
/*     */       {
/* 239 */         this.threadGroup = parent;
/* 240 */         parent = this.threadGroup.getParent();
/*     */       }
/* 242 */       this.threadGroup = new ThreadGroup(parent, "SimpleThreadPool");
/*     */     }
/*     */ 
/* 246 */     if (isThreadsInheritContextClassLoaderOfInitializingThread()) {
/* 247 */       getLog().info("Job execution threads will use class loader of thread: " + Thread.currentThread().getName());
/*     */     }
/*     */ 
/* 252 */     this.workers = createWorkerThreads(this.count);
/* 253 */     for (int i = 0; i < this.count; i++)
/* 254 */       if (isThreadsInheritContextClassLoaderOfInitializingThread())
/* 255 */         this.workers[i].setContextClassLoader(Thread.currentThread().getContextClassLoader());
/*     */   }
/*     */ 
/*     */   protected WorkerThread[] createWorkerThreads(int count)
/*     */   {
/* 263 */     this.workers = new WorkerThread[count];
/* 264 */     for (int i = 0; i < count; i++) {
/* 265 */       this.workers[i] = new WorkerThread(this, this.threadGroup, getThreadNamePrefix() + "-" + i, getThreadPriority(), isMakeThreadsDaemons());
/*     */     }
/*     */ 
/* 271 */     return this.workers;
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/* 284 */     shutdown(true);
/*     */   }
/*     */ 
/*     */   public void shutdown(boolean waitForJobsToComplete)
/*     */   {
/* 297 */     this.isShutdown = true;
/*     */ 
/* 300 */     for (int i = 0; i < this.workers.length; i++) {
/* 301 */       if (this.workers[i] == null) continue; this.workers[i].shutdown();
/*     */     }
/*     */ 
/* 307 */     synchronized (this.nextRunnableLock) {
/* 308 */       this.nextRunnableLock.notifyAll();
/*     */     }
/*     */ 
/* 311 */     if (waitForJobsToComplete == true)
/*     */     {
/* 313 */       int alive = this.workers.length;
/* 314 */       while (alive > 0) {
/* 315 */         alive = 0;
/* 316 */         for (int i = 0; i < this.workers.length; i++) {
/* 317 */           if (!this.workers[i].isAlive())
/*     */             continue;
/*     */           try {
/* 320 */             getLog().debug("Waiting for thread no. " + i + " to shut down");
/*     */ 
/* 329 */             alive++;
/* 330 */             this.workers[i].join(200L);
/*     */           }
/*     */           catch (InterruptedException ex)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 338 */       int activeCount = this.threadGroup.activeCount();
/* 339 */       if (activeCount > 0) {
/* 340 */         getLog().info("There are still " + activeCount + " worker threads active." + " See javadoc runInThread(Runnable) for a possible explanation");
/*     */       }
/*     */ 
/* 347 */       getLog().debug("shutdown complete");
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean runInThread(Runnable runnable)
/*     */   {
/* 364 */     if (runnable == null) return false;
/*     */ 
/* 366 */     if (this.isShutdown) {
/*     */       try {
/* 368 */         getLog().info("SimpleThreadPool.runInThread(): thread pool has been shutdown. Runnable will not be executed");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */ 
/* 375 */       return false;
/*     */     }
/*     */ 
/* 378 */     synchronized (this.nextRunnableLock)
/*     */     {
/* 382 */       while ((this.nextRunnable != null) && (!this.isShutdown)) {
/*     */         try {
/* 384 */           this.nextRunnableLock.wait(1000L);
/*     */         }
/*     */         catch (InterruptedException ignore)
/*     */         {
/*     */         }
/*     */       }
/*     */ 
/* 391 */       if (!this.isShutdown) {
/* 392 */         this.nextRunnable = runnable;
/* 393 */         this.nextRunnableLock.notifyAll();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 401 */     if (this.isShutdown) {
/* 402 */       new WorkerThread(this, this.threadGroup, "WorkerThread-LastJob", this.prio, false, runnable);
/*     */     }
/*     */ 
/* 406 */     return true;
/*     */   }
/*     */ 
/*     */   private Runnable getNextRunnable()
/*     */     throws InterruptedException
/*     */   {
/* 423 */     Runnable toRun = null;
/*     */ 
/* 427 */     synchronized (this.nextRunnableLock) {
/* 428 */       if (this.nextRunnable == null) this.nextRunnableLock.wait(1000L);
/*     */ 
/* 430 */       if (this.nextRunnable != null) {
/* 431 */         toRun = this.nextRunnable;
/* 432 */         this.nextRunnable = null;
/* 433 */         this.nextRunnableLock.notifyAll();
/*     */       }
/*     */     }
/*     */ 
/* 437 */     return toRun;
/*     */   }
/*     */ 
/*     */   class WorkerThread extends Thread
/*     */   {
/* 456 */     private boolean run = true;
/*     */     private SimpleThreadPool tp;
/* 460 */     private Runnable runnable = null;
/*     */ 
/*     */     WorkerThread(SimpleThreadPool tp, ThreadGroup threadGroup, String name, int prio, boolean isDaemon)
/*     */     {
/* 472 */       this(tp, threadGroup, name, prio, isDaemon, null);
/*     */     }
/*     */ 
/*     */     WorkerThread(SimpleThreadPool tp, ThreadGroup threadGroup, String name, int prio, boolean isDaemon, Runnable runnable)
/*     */     {
/* 484 */       super(name);
/* 485 */       this.tp = tp;
/* 486 */       this.runnable = runnable;
/* 487 */       setPriority(prio);
/* 488 */       setDaemon(isDaemon);
/* 489 */       start();
/*     */     }
/*     */ 
/*     */     void shutdown()
/*     */     {
/* 498 */       this.run = false;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 514 */       boolean runOnce = this.runnable != null;
/*     */       while (true) {
/* 516 */         if (this.run) {
/*     */           try {
/* 518 */             if (this.runnable == null) this.runnable = this.tp.getNextRunnable();
/*     */ 
/* 520 */             if (this.runnable != null) this.runnable.run(); 
/*     */           }
/*     */           catch (InterruptedException unblock)
/*     */           {
/*     */             try {
/* 524 */               SimpleThreadPool.this.getLog().error("worker threat got 'interrupt'ed.", unblock);
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 528 */               jsr 40;
/*     */             } } catch (Exception exceptionInRunnable) {
/*     */             try {
/* 530 */               SimpleThreadPool.this.getLog().error("Error while executing the Runnable: ", exceptionInRunnable);
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 535 */               jsr 14;
/*     */             } } finally {
/* 536 */             if (runOnce) this.run = false;
/*     */ 
/* 538 */             this.runnable = null;
/*     */ 
/* 541 */             setPriority(this.tp.getThreadPriority());
/*     */           }
/*     */         }
/*     */       }
/*     */       try
/*     */       {
/* 547 */         SimpleThreadPool.this.getLog().debug("WorkerThread is shutting down");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.simpl.SimpleThreadPool
 * JD-Core Version:    0.6.0
 */