/*     */ package org.quartz.simpl;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.URL;
/*     */ import org.quartz.spi.ClassLoadHelper;
/*     */ 
/*     */ public class SimpleClassLoadHelper
/*     */   implements ClassLoadHelper
/*     */ {
/*     */   public void initialize()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Class loadClass(String name)
/*     */     throws ClassNotFoundException
/*     */   {
/*  62 */     return Class.forName(name);
/*     */   }
/*     */ 
/*     */   public URL getResource(String name)
/*     */   {
/*  72 */     return getClassLoader().getResource(name);
/*     */   }
/*     */ 
/*     */   public InputStream getResourceAsStream(String name)
/*     */   {
/*  82 */     return getClassLoader().getResourceAsStream(name);
/*     */   }
/*     */ 
/*     */   private ClassLoader getClassLoader()
/*     */   {
/*     */     try
/*     */     {
/*  91 */       ClassLoader cl = getClass().getClassLoader();
/*     */ 
/*  94 */       Method mthd = ClassLoader.class.getDeclaredMethod("getCallerClassLoader", new Class[0]);
/*     */ 
/*  97 */       AccessibleObject.setAccessible(new AccessibleObject[] { mthd }, true);
/*     */ 
/*  99 */       return (ClassLoader)mthd.invoke(cl, new Object[0]);
/*     */     } catch (Exception all) {
/*     */     }
/* 102 */     return getClass().getClassLoader();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.simpl.SimpleClassLoadHelper
 * JD-Core Version:    0.6.0
 */