/*      */ package org.quartz.simpl;
/*      */ 
/*      */ import java.util.ArrayList;
/*      */ import java.util.Date;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.NoSuchElementException;
/*      */ import java.util.Set;
/*      */ import java.util.TreeSet;
/*      */ import org.apache.commons.logging.Log;
/*      */ import org.apache.commons.logging.LogFactory;
/*      */ import org.quartz.Calendar;
/*      */ import org.quartz.JobDataMap;
/*      */ import org.quartz.JobDetail;
/*      */ import org.quartz.JobPersistenceException;
/*      */ import org.quartz.ObjectAlreadyExistsException;
/*      */ import org.quartz.SchedulerException;
/*      */ import org.quartz.Trigger;
/*      */ import org.quartz.core.SchedulingContext;
/*      */ import org.quartz.spi.ClassLoadHelper;
/*      */ import org.quartz.spi.JobStore;
/*      */ import org.quartz.spi.SchedulerSignaler;
/*      */ import org.quartz.spi.TriggerFiredBundle;
/*      */ 
/*      */ public class RAMJobStore
/*      */   implements JobStore
/*      */ {
/*   73 */   protected HashMap jobsByFQN = new HashMap(1000);
/*      */ 
/*   75 */   protected HashMap triggersByFQN = new HashMap(1000);
/*      */ 
/*   77 */   protected HashMap jobsByGroup = new HashMap(25);
/*      */ 
/*   79 */   protected HashMap triggersByGroup = new HashMap(25);
/*      */ 
/*   81 */   protected TreeSet timeTriggers = new TreeSet(new TriggerComparator());
/*      */ 
/*   83 */   protected HashMap calendarsByName = new HashMap(25);
/*      */ 
/*   85 */   protected ArrayList triggers = new ArrayList(1000);
/*      */ 
/*   87 */   protected Object jobLock = new Object();
/*      */ 
/*   89 */   protected Object triggerLock = new Object();
/*      */ 
/*   91 */   protected HashSet pausedTriggerGroups = new HashSet();
/*      */ 
/*   93 */   protected HashSet blockedJobs = new HashSet();
/*      */ 
/*   95 */   protected long misfireThreshold = 5000L;
/*      */   protected SchedulerSignaler signaler;
/* 1110 */   private static long ftrCtr = System.currentTimeMillis();
/*      */ 
/*      */   protected Log getLog()
/*      */   {
/*  124 */     return LogFactory.getLog(RAMJobStore.class);
/*      */   }
/*      */ 
/*      */   public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler)
/*      */   {
/*  136 */     this.signaler = signaler;
/*      */ 
/*  138 */     getLog().info("RAMJobStore initialized.");
/*      */   }
/*      */ 
/*      */   public void schedulerStarted() throws SchedulerException
/*      */   {
/*      */   }
/*      */ 
/*      */   public long getMisfireThreshold()
/*      */   {
/*  147 */     return this.misfireThreshold;
/*      */   }
/*      */ 
/*      */   public void setMisfireThreshold(long misfireThreshold)
/*      */   {
/*  158 */     if (misfireThreshold < 1L) {
/*  159 */       throw new IllegalArgumentException("Misfirethreashold must be larger than 0");
/*      */     }
/*  161 */     this.misfireThreshold = misfireThreshold;
/*      */   }
/*      */ 
/*      */   public void shutdown()
/*      */   {
/*      */   }
/*      */ 
/*      */   public boolean supportsPersistence()
/*      */   {
/*  175 */     return false;
/*      */   }
/*      */ 
/*      */   public void storeJobAndTrigger(SchedulingContext ctxt, JobDetail newJob, Trigger newTrigger)
/*      */     throws JobPersistenceException
/*      */   {
/*  193 */     storeJob(ctxt, newJob, false);
/*  194 */     storeTrigger(ctxt, newTrigger, false);
/*      */   }
/*      */ 
/*      */   public void storeJob(SchedulingContext ctxt, JobDetail newJob, boolean replaceExisting)
/*      */     throws ObjectAlreadyExistsException
/*      */   {
/*  214 */     JobWrapper jw = new JobWrapper(newJob);
/*      */ 
/*  216 */     boolean repl = false;
/*      */ 
/*  218 */     if (this.jobsByFQN.get(jw.key) != null) {
/*  219 */       if (!replaceExisting)
/*  220 */         throw new ObjectAlreadyExistsException(newJob);
/*  221 */       repl = true;
/*      */     }
/*      */ 
/*  224 */     synchronized (this.jobLock) {
/*  225 */       if (!repl)
/*      */       {
/*  227 */         HashMap grpMap = (HashMap)this.jobsByGroup.get(newJob.getGroup());
/*  228 */         if (grpMap == null) {
/*  229 */           grpMap = new HashMap(100);
/*  230 */           this.jobsByGroup.put(newJob.getGroup(), grpMap);
/*      */         }
/*      */ 
/*  233 */         grpMap.put(newJob.getName(), jw);
/*      */ 
/*  235 */         this.jobsByFQN.put(jw.key, jw);
/*      */       }
/*      */       else {
/*  238 */         JobWrapper orig = (JobWrapper)this.jobsByFQN.get(jw.key);
/*  239 */         orig.jobDetail = newJob;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean removeJob(SchedulingContext ctxt, String jobName, String groupName)
/*      */   {
/*  260 */     String key = JobWrapper.getJobNameKey(jobName, groupName);
/*      */ 
/*  262 */     boolean found = false;
/*      */ 
/*  264 */     Trigger[] trigger = getTriggersForJob(ctxt, jobName, groupName);
/*      */ 
/*  266 */     for (int i = 0; i < trigger.length; i++) {
/*  267 */       Trigger trig = trigger[i];
/*  268 */       removeTrigger(ctxt, trig.getName(), trig.getGroup());
/*  269 */       found = true;
/*      */     }
/*  271 */     synchronized (this.jobLock) {
/*  272 */       found = this.jobsByFQN.remove(key) != null | found;
/*  273 */       if (found)
/*      */       {
/*  275 */         HashMap grpMap = (HashMap)this.jobsByGroup.get(groupName);
/*  276 */         if (grpMap != null) {
/*  277 */           grpMap.remove(jobName);
/*  278 */           if (grpMap.size() == 0) this.jobsByGroup.remove(groupName);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  283 */     return found;
/*      */   }
/*      */ 
/*      */   public void storeTrigger(SchedulingContext ctxt, Trigger newTrigger, boolean replaceExisting)
/*      */     throws JobPersistenceException
/*      */   {
/*  305 */     TriggerWrapper tw = new TriggerWrapper(newTrigger);
/*      */ 
/*  307 */     if (this.triggersByFQN.get(tw.key) != null) {
/*  308 */       if (!replaceExisting) {
/*  309 */         throw new ObjectAlreadyExistsException(newTrigger);
/*      */       }
/*  311 */       removeTrigger(ctxt, newTrigger.getName(), newTrigger.getGroup());
/*      */     }
/*      */ 
/*  314 */     if (retrieveJob(ctxt, newTrigger.getJobName(), newTrigger.getJobGroup()) == null) {
/*  315 */       throw new JobPersistenceException("The job (" + newTrigger.getFullJobName() + ") referenced by the trigger does not exist.");
/*      */     }
/*      */ 
/*  319 */     synchronized (this.triggerLock)
/*      */     {
/*  321 */       this.triggers.add(tw);
/*      */ 
/*  323 */       HashMap grpMap = (HashMap)this.triggersByGroup.get(newTrigger.getGroup());
/*      */ 
/*  325 */       if (grpMap == null) {
/*  326 */         grpMap = new HashMap(100);
/*  327 */         this.triggersByGroup.put(newTrigger.getGroup(), grpMap);
/*      */       }
/*  329 */       grpMap.put(newTrigger.getName(), tw);
/*      */ 
/*  331 */       this.triggersByFQN.put(tw.key, tw);
/*      */ 
/*  333 */       synchronized (this.pausedTriggerGroups) {
/*  334 */         if (this.pausedTriggerGroups.contains(newTrigger.getGroup())) {
/*  335 */           tw.state = 4;
/*  336 */           if (this.blockedJobs.contains(tw.jobKey))
/*  337 */             tw.state = 6;
/*      */         }
/*  339 */         else if (this.blockedJobs.contains(tw.jobKey)) {
/*  340 */           tw.state = 5;
/*      */         } else {
/*  342 */           this.timeTriggers.add(tw);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean removeTrigger(SchedulingContext ctxt, String triggerName, String groupName)
/*      */   {
/*  362 */     String key = TriggerWrapper.getTriggerNameKey(triggerName, groupName);
/*      */ 
/*  364 */     boolean found = false;
/*      */ 
/*  366 */     synchronized (this.triggerLock)
/*      */     {
/*  368 */       found = this.triggersByFQN.remove(key) != null;
/*  369 */       if (found) {
/*  370 */         TriggerWrapper tw = null;
/*      */ 
/*  372 */         HashMap grpMap = (HashMap)this.triggersByGroup.get(groupName);
/*  373 */         if (grpMap != null) {
/*  374 */           grpMap.remove(triggerName);
/*  375 */           if (grpMap.size() == 0) this.triggersByGroup.remove(groupName);
/*      */         }
/*      */ 
/*  378 */         Iterator tgs = this.triggers.iterator();
/*  379 */         while (tgs.hasNext()) {
/*  380 */           tw = (TriggerWrapper)tgs.next();
/*  381 */           if (key.equals(tw.key)) {
/*  382 */             tgs.remove();
/*      */           }
/*      */         }
/*      */ 
/*  386 */         this.timeTriggers.remove(tw);
/*      */ 
/*  388 */         JobWrapper jw = (JobWrapper)this.jobsByFQN.get(JobWrapper.getJobNameKey(tw.trigger.getJobName(), tw.trigger.getJobGroup()));
/*      */ 
/*  391 */         Trigger[] trigs = getTriggersForJob(ctxt, tw.trigger.getJobName(), tw.trigger.getJobGroup());
/*      */ 
/*  393 */         if (((trigs == null) || (trigs.length == 0)) && (!jw.jobDetail.isDurable()))
/*      */         {
/*  395 */           removeJob(ctxt, tw.trigger.getJobName(), tw.trigger.getJobGroup());
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  400 */     return found;
/*      */   }
/*      */ 
/*      */   public boolean replaceTrigger(SchedulingContext ctxt, String triggerName, String groupName, Trigger newTrigger)
/*      */     throws JobPersistenceException
/*      */   {
/*  408 */     String key = TriggerWrapper.getTriggerNameKey(triggerName, groupName);
/*      */ 
/*  410 */     boolean found = false;
/*      */ 
/*  412 */     synchronized (this.triggerLock)
/*      */     {
/*  414 */       TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.remove(key);
/*  415 */       found = tw != null;
/*      */ 
/*  417 */       if (found)
/*      */       {
/*  419 */         if ((!tw.getTrigger().getJobName().equals(newTrigger.getJobName())) || (!tw.getTrigger().getJobGroup().equals(newTrigger.getJobGroup())))
/*      */         {
/*  421 */           throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
/*      */         }
/*  423 */         tw = null;
/*      */ 
/*  425 */         HashMap grpMap = (HashMap)this.triggersByGroup.get(groupName);
/*  426 */         if (grpMap != null) {
/*  427 */           grpMap.remove(triggerName);
/*  428 */           if (grpMap.size() == 0) this.triggersByGroup.remove(groupName);
/*      */         }
/*      */ 
/*  431 */         Iterator tgs = this.triggers.iterator();
/*  432 */         while (tgs.hasNext()) {
/*  433 */           tw = (TriggerWrapper)tgs.next();
/*  434 */           if (key.equals(tw.key)) {
/*  435 */             tgs.remove();
/*      */           }
/*      */         }
/*      */ 
/*  439 */         this.timeTriggers.remove(tw);
/*      */         try
/*      */         {
/*  442 */           storeTrigger(ctxt, newTrigger, false);
/*      */         }
/*      */         catch (JobPersistenceException jpe) {
/*  445 */           storeTrigger(ctxt, tw.getTrigger(), false);
/*  446 */           throw jpe;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  451 */     return found;
/*      */   }
/*      */ 
/*      */   public JobDetail retrieveJob(SchedulingContext ctxt, String jobName, String groupName)
/*      */   {
/*  468 */     JobWrapper jw = (JobWrapper)this.jobsByFQN.get(JobWrapper.getJobNameKey(jobName, groupName));
/*      */ 
/*  470 */     if (jw != null) return jw.jobDetail;
/*      */ 
/*  472 */     return null;
/*      */   }
/*      */ 
/*      */   public Trigger retrieveTrigger(SchedulingContext ctxt, String triggerName, String groupName)
/*      */   {
/*  489 */     TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
/*      */ 
/*  491 */     if (tw != null) return tw.getTrigger();
/*      */ 
/*  493 */     return null;
/*      */   }
/*      */ 
/*      */   public int getTriggerState(SchedulingContext ctxt, String triggerName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  510 */     TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
/*      */ 
/*  512 */     if (tw == null) return -1;
/*      */ 
/*  514 */     if (tw.state == 3) {
/*  515 */       return 2;
/*      */     }
/*  517 */     if (tw.state == 4) {
/*  518 */       return 1;
/*      */     }
/*  520 */     if (tw.state == 6) {
/*  521 */       return 1;
/*      */     }
/*  523 */     if (tw.state == 5) {
/*  524 */       return 4;
/*      */     }
/*  526 */     if (tw.state == 7) {
/*  527 */       return 3;
/*      */     }
/*  529 */     return 0;
/*      */   }
/*      */ 
/*      */   public void storeCalendar(SchedulingContext ctxt, String name, Calendar calendar, boolean replaceExisting, boolean updateTriggers)
/*      */     throws ObjectAlreadyExistsException
/*      */   {
/*  555 */     Object obj = this.calendarsByName.get(name);
/*      */ 
/*  557 */     if ((obj != null) && (!replaceExisting)) throw new ObjectAlreadyExistsException("Calendar with name '" + name + "' already exists.");
/*      */ 
/*  559 */     if (obj != null) this.calendarsByName.remove(name);
/*      */ 
/*  561 */     this.calendarsByName.put(name, calendar);
/*      */ 
/*  563 */     if ((obj != null) && (updateTriggers))
/*  564 */       synchronized (this.triggerLock) {
/*  565 */         Iterator trigs = getTriggerWrappersForCalendar(name).iterator();
/*  566 */         while (trigs.hasNext()) {
/*  567 */           TriggerWrapper tw = (TriggerWrapper)trigs.next();
/*  568 */           Trigger trig = tw.getTrigger();
/*  569 */           boolean removed = this.timeTriggers.remove(tw);
/*      */ 
/*  571 */           trig.updateWithNewCalendar(calendar, getMisfireThreshold());
/*      */ 
/*  573 */           if (removed)
/*  574 */             this.timeTriggers.add(tw);
/*      */         }
/*      */       }
/*      */   }
/*      */ 
/*      */   public boolean removeCalendar(SchedulingContext ctxt, String calName)
/*      */     throws JobPersistenceException
/*      */   {
/*  597 */     int numRefs = 0;
/*      */ 
/*  599 */     synchronized (this.triggerLock) {
/*  600 */       Iterator itr = this.triggers.iterator();
/*  601 */       while (itr.hasNext()) {
/*  602 */         Trigger trigg = ((TriggerWrapper)itr.next()).trigger;
/*  603 */         if ((trigg.getCalendarName() != null) && (trigg.getCalendarName().equals(calName))) {
/*  604 */           numRefs++;
/*      */         }
/*      */       }
/*      */     }
/*  608 */     if (numRefs > 0) {
/*  609 */       throw new JobPersistenceException("Calender cannot be removed if it referenced by a Trigger!");
/*      */     }
/*      */ 
/*  612 */     return this.calendarsByName.remove(calName) != null;
/*      */   }
/*      */ 
/*      */   public Calendar retrieveCalendar(SchedulingContext ctxt, String calName)
/*      */   {
/*  626 */     return (Calendar)this.calendarsByName.get(calName);
/*      */   }
/*      */ 
/*      */   public int getNumberOfJobs(SchedulingContext ctxt)
/*      */   {
/*  636 */     return this.jobsByFQN.size();
/*      */   }
/*      */ 
/*      */   public int getNumberOfTriggers(SchedulingContext ctxt)
/*      */   {
/*  646 */     return this.triggers.size();
/*      */   }
/*      */ 
/*      */   public int getNumberOfCalendars(SchedulingContext ctxt)
/*      */   {
/*  656 */     return this.calendarsByName.size();
/*      */   }
/*      */ 
/*      */   public String[] getJobNames(SchedulingContext ctxt, String groupName)
/*      */   {
/*  666 */     String[] outList = null;
/*  667 */     HashMap grpMap = (HashMap)this.jobsByGroup.get(groupName);
/*  668 */     if (grpMap != null) {
/*  669 */       synchronized (this.jobLock) {
/*  670 */         outList = new String[grpMap.size()];
/*  671 */         int outListPos = 0;
/*  672 */         Iterator keys = grpMap.keySet().iterator();
/*  673 */         while (keys.hasNext()) {
/*  674 */           String key = (String)keys.next();
/*  675 */           JobWrapper jw = (JobWrapper)grpMap.get(key);
/*  676 */           if (jw != null)
/*  677 */             outList[(outListPos++)] = jw.jobDetail.getName();
/*      */         }
/*      */       }
/*      */     }
/*  681 */     outList = new String[0];
/*      */ 
/*  683 */     return outList;
/*      */   }
/*      */ 
/*      */   public String[] getCalendarNames(SchedulingContext ctxt)
/*      */   {
/*  698 */     Set names = this.calendarsByName.keySet();
/*  699 */     return (String[])names.toArray(new String[names.size()]);
/*      */   }
/*      */ 
/*      */   public String[] getTriggerNames(SchedulingContext ctxt, String groupName)
/*      */   {
/*  709 */     String[] outList = null;
/*  710 */     HashMap grpMap = (HashMap)this.triggersByGroup.get(groupName);
/*  711 */     if (grpMap != null) {
/*  712 */       synchronized (this.triggerLock) {
/*  713 */         outList = new String[grpMap.size()];
/*  714 */         int outListPos = 0;
/*  715 */         Iterator keys = grpMap.keySet().iterator();
/*  716 */         while (keys.hasNext()) {
/*  717 */           String key = (String)keys.next();
/*  718 */           TriggerWrapper tw = (TriggerWrapper)grpMap.get(key);
/*  719 */           if (tw != null)
/*  720 */             outList[(outListPos++)] = tw.trigger.getName();
/*      */         }
/*      */       }
/*      */     }
/*  724 */     outList = new String[0];
/*      */ 
/*  726 */     return outList;
/*      */   }
/*      */ 
/*      */   public String[] getJobGroupNames(SchedulingContext ctxt)
/*      */   {
/*  736 */     String[] outList = null;
/*      */ 
/*  738 */     synchronized (this.jobLock) {
/*  739 */       outList = new String[this.jobsByGroup.size()];
/*  740 */       int outListPos = 0;
/*  741 */       Iterator keys = this.jobsByGroup.keySet().iterator();
/*  742 */       while (keys.hasNext()) {
/*  743 */         outList[(outListPos++)] = ((String)keys.next());
/*      */       }
/*      */     }
/*      */ 
/*  747 */     return outList;
/*      */   }
/*      */ 
/*      */   public String[] getTriggerGroupNames(SchedulingContext ctxt)
/*      */   {
/*  757 */     String[] outList = null;
/*      */ 
/*  759 */     synchronized (this.triggerLock) {
/*  760 */       outList = new String[this.triggersByGroup.size()];
/*  761 */       int outListPos = 0;
/*  762 */       Iterator keys = this.triggersByGroup.keySet().iterator();
/*  763 */       while (keys.hasNext()) {
/*  764 */         outList[(outListPos++)] = ((String)keys.next());
/*      */       }
/*      */     }
/*      */ 
/*  768 */     return outList;
/*      */   }
/*      */ 
/*      */   public Trigger[] getTriggersForJob(SchedulingContext ctxt, String jobName, String groupName)
/*      */   {
/*  782 */     ArrayList trigList = new ArrayList();
/*      */ 
/*  784 */     String jobKey = JobWrapper.getJobNameKey(jobName, groupName);
/*  785 */     synchronized (this.triggerLock) {
/*  786 */       for (int i = 0; i < this.triggers.size(); i++) {
/*  787 */         TriggerWrapper tw = (TriggerWrapper)this.triggers.get(i);
/*  788 */         if (!tw.jobKey.equals(jobKey)) continue; trigList.add(tw.trigger.clone());
/*      */       }
/*      */     }
/*      */ 
/*  792 */     return (Trigger[])trigList.toArray(new Trigger[trigList.size()]);
/*      */   }
/*      */ 
/*      */   protected ArrayList getTriggerWrappersForJob(String jobName, String groupName) {
/*  796 */     ArrayList trigList = new ArrayList();
/*      */ 
/*  798 */     String jobKey = JobWrapper.getJobNameKey(jobName, groupName);
/*  799 */     synchronized (this.triggerLock) {
/*  800 */       for (int i = 0; i < this.triggers.size(); i++) {
/*  801 */         TriggerWrapper tw = (TriggerWrapper)this.triggers.get(i);
/*  802 */         if (!tw.jobKey.equals(jobKey)) continue; trigList.add(tw);
/*      */       }
/*      */     }
/*      */ 
/*  806 */     return trigList;
/*      */   }
/*      */ 
/*      */   protected ArrayList getTriggerWrappersForCalendar(String calName) {
/*  810 */     ArrayList trigList = new ArrayList();
/*      */ 
/*  812 */     synchronized (this.triggerLock) {
/*  813 */       for (int i = 0; i < this.triggers.size(); i++) {
/*  814 */         TriggerWrapper tw = (TriggerWrapper)this.triggers.get(i);
/*  815 */         String tcalName = tw.getTrigger().getCalendarName();
/*  816 */         if ((tcalName != null) && (tcalName.equals(calName))) {
/*  817 */           trigList.add(tw);
/*      */         }
/*      */       }
/*      */     }
/*  821 */     return trigList;
/*      */   }
/*      */ 
/*      */   public void pauseTrigger(SchedulingContext ctxt, String triggerName, String groupName)
/*      */   {
/*  833 */     TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
/*      */ 
/*  837 */     if ((tw == null) || (tw.trigger == null)) return;
/*      */ 
/*  839 */     if (tw.state == 3) return;
/*      */ 
/*  841 */     synchronized (this.triggerLock) {
/*  842 */       if (tw.state == 5)
/*  843 */         tw.state = 6;
/*      */       else
/*  845 */         tw.state = 4;
/*  846 */       this.timeTriggers.remove(tw);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseTriggerGroup(SchedulingContext ctxt, String groupName)
/*      */   {
/*  864 */     synchronized (this.pausedTriggerGroups) {
/*  865 */       if (this.pausedTriggerGroups.contains(groupName)) return;
/*  866 */       this.pausedTriggerGroups.add(groupName);
/*  867 */       String[] names = getTriggerNames(ctxt, groupName);
/*      */ 
/*  869 */       for (int i = 0; i < names.length; i++)
/*  870 */         pauseTrigger(ctxt, names[i], groupName);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseJob(SchedulingContext ctxt, String jobName, String groupName)
/*      */   {
/*  884 */     synchronized (this.pausedTriggerGroups) {
/*  885 */       Trigger[] triggers = getTriggersForJob(ctxt, jobName, groupName);
/*  886 */       for (int j = 0; j < triggers.length; j++)
/*  887 */         pauseTrigger(ctxt, triggers[j].getName(), triggers[j].getGroup());
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseJobGroup(SchedulingContext ctxt, String groupName)
/*      */   {
/*  906 */     synchronized (this.pausedTriggerGroups) {
/*  907 */       String[] jobNames = getJobNames(ctxt, groupName);
/*      */ 
/*  909 */       for (int i = 0; i < jobNames.length; i++) {
/*  910 */         Trigger[] triggers = getTriggersForJob(ctxt, jobNames[i], groupName);
/*      */ 
/*  912 */         for (int j = 0; j < triggers.length; j++)
/*  913 */           pauseTrigger(ctxt, triggers[j].getName(), triggers[j].getGroup());
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeTrigger(SchedulingContext ctxt, String triggerName, String groupName)
/*      */   {
/*  935 */     TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
/*      */ 
/*  938 */     Trigger trig = tw.getTrigger();
/*      */ 
/*  941 */     if ((tw == null) || (tw.trigger == null)) return;
/*      */ 
/*  943 */     if ((tw.state != 4) && (tw.state != 6))
/*      */     {
/*  945 */       return;
/*      */     }
/*  947 */     synchronized (this.triggerLock) {
/*  948 */       if (this.blockedJobs.contains(JobWrapper.getJobNameKey(trig.getJobName(), trig.getJobGroup())))
/*  949 */         tw.state = 5;
/*      */       else {
/*  951 */         tw.state = 0;
/*      */       }
/*  953 */       applyMisfire(tw);
/*      */ 
/*  955 */       if (tw.state == 0) this.timeTriggers.add(tw);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeTriggerGroup(SchedulingContext ctxt, String groupName)
/*      */   {
/*  973 */     synchronized (this.pausedTriggerGroups) {
/*  974 */       String[] names = getTriggerNames(ctxt, groupName);
/*      */ 
/*  976 */       for (int i = 0; i < names.length; i++) {
/*  977 */         resumeTrigger(ctxt, names[i], groupName);
/*      */       }
/*  979 */       this.pausedTriggerGroups.remove(groupName);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeJob(SchedulingContext ctxt, String jobName, String groupName)
/*      */   {
/*  999 */     synchronized (this.pausedTriggerGroups) {
/* 1000 */       Trigger[] triggers = getTriggersForJob(ctxt, jobName, groupName);
/* 1001 */       for (int j = 0; j < triggers.length; j++)
/* 1002 */         resumeTrigger(ctxt, triggers[j].getName(), triggers[j].getGroup());
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeJobGroup(SchedulingContext ctxt, String groupName)
/*      */   {
/* 1021 */     synchronized (this.pausedTriggerGroups) {
/* 1022 */       String[] jobNames = getJobNames(ctxt, groupName);
/*      */ 
/* 1024 */       for (int i = 0; i < jobNames.length; i++) {
/* 1025 */         Trigger[] triggers = getTriggersForJob(ctxt, jobNames[i], groupName);
/*      */ 
/* 1027 */         for (int j = 0; j < triggers.length; j++)
/* 1028 */           resumeTrigger(ctxt, triggers[j].getName(), triggers[j].getGroup());
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseAll(SchedulingContext ctxt)
/*      */   {
/* 1051 */     synchronized (this.pausedTriggerGroups) {
/* 1052 */       String[] names = getTriggerGroupNames(ctxt);
/*      */ 
/* 1054 */       for (int i = 0; i < names.length; i++)
/* 1055 */         pauseTriggerGroup(ctxt, names[i]);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeAll(SchedulingContext ctxt)
/*      */   {
/* 1075 */     synchronized (this.pausedTriggerGroups) {
/* 1076 */       String[] names = getTriggerGroupNames(ctxt);
/*      */ 
/* 1078 */       for (int i = 0; i < names.length; i++)
/* 1079 */         resumeTriggerGroup(ctxt, names[i]);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected boolean applyMisfire(TriggerWrapper tw)
/*      */   {
/* 1086 */     long misfireTime = System.currentTimeMillis();
/* 1087 */     if (getMisfireThreshold() > 0L) misfireTime -= getMisfireThreshold();
/*      */ 
/* 1089 */     Date tnft = tw.trigger.getNextFireTime();
/* 1090 */     if (tnft.getTime() > misfireTime) return false;
/*      */ 
/* 1092 */     Calendar cal = null;
/* 1093 */     if (tw.trigger.getCalendarName() != null) {
/* 1094 */       cal = retrieveCalendar(null, tw.trigger.getCalendarName());
/*      */     }
/* 1096 */     this.signaler.notifyTriggerListenersMisfired(tw.trigger);
/*      */ 
/* 1098 */     tw.trigger.updateAfterMisfire(cal);
/*      */ 
/* 1100 */     if (tw.trigger.getNextFireTime() == null) {
/* 1101 */       tw.state = 3;
/* 1102 */       synchronized (this.triggerLock) {
/* 1103 */         this.timeTriggers.remove(tw);
/*      */       }
/*      */     }
/* 1105 */     return !tnft.equals(tw.trigger.getNextFireTime());
/*      */   }
/*      */ 
/*      */   protected synchronized String getFiredTriggerRecordId()
/*      */   {
/* 1113 */     return String.valueOf(ftrCtr++);
/*      */   }
/*      */ 
/*      */   public Trigger acquireNextTrigger(SchedulingContext ctxt, long noLaterThan)
/*      */   {
/* 1125 */     TriggerWrapper tw = null;
/*      */ 
/* 1127 */     synchronized (this.triggerLock)
/*      */     {
/* 1129 */       while (tw == null) {
/*      */         try {
/* 1131 */           tw = (TriggerWrapper)this.timeTriggers.first();
/*      */         } catch (NoSuchElementException nsee) {
/* 1133 */           return null;
/*      */         }
/*      */ 
/* 1136 */         if (tw == null) return null;
/*      */ 
/* 1138 */         if (tw.trigger.getNextFireTime() == null) {
/* 1139 */           this.timeTriggers.remove(tw);
/* 1140 */           tw = null;
/* 1141 */           continue;
/*      */         }
/*      */ 
/* 1144 */         this.timeTriggers.remove(tw);
/*      */ 
/* 1146 */         if (applyMisfire(tw)) {
/* 1147 */           if (tw.trigger.getNextFireTime() != null)
/* 1148 */             this.timeTriggers.add(tw);
/* 1149 */           tw = null;
/* 1150 */           continue;
/*      */         }
/*      */ 
/* 1153 */         if (tw.trigger.getNextFireTime().getTime() > noLaterThan) {
/* 1154 */           this.timeTriggers.add(tw);
/* 1155 */           return null;
/*      */         }
/*      */ 
/* 1158 */         tw.state = 1;
/*      */ 
/* 1160 */         tw.trigger.setFireInstanceId(getFiredTriggerRecordId());
/* 1161 */         Trigger trig = (Trigger)tw.trigger.clone();
/* 1162 */         return trig;
/*      */       }
/*      */     }
/*      */ 
/* 1166 */     return null;
/*      */   }
/*      */ 
/*      */   public void releaseAcquiredTrigger(SchedulingContext ctxt, Trigger trigger)
/*      */   {
/* 1177 */     synchronized (this.triggerLock) {
/* 1178 */       TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(trigger));
/*      */ 
/* 1180 */       if ((tw != null) && (tw.state == 1)) {
/* 1181 */         tw.state = 0;
/* 1182 */         this.timeTriggers.add(tw);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public TriggerFiredBundle triggerFired(SchedulingContext ctxt, Trigger trigger)
/*      */   {
/* 1197 */     synchronized (this.triggerLock) {
/* 1198 */       TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(trigger));
/*      */ 
/* 1201 */       if ((tw == null) || (tw.trigger == null)) return null;
/*      */ 
/* 1203 */       if (tw.state == 3) return null;
/*      */ 
/* 1205 */       if (tw.state == 4) return null;
/*      */ 
/* 1207 */       if (tw.state == 5) return null;
/*      */ 
/* 1209 */       if (tw.state == 6) return null;
/*      */ 
/* 1211 */       Calendar cal = null;
/* 1212 */       if (tw.trigger.getCalendarName() != null)
/* 1213 */         cal = retrieveCalendar(ctxt, tw.trigger.getCalendarName());
/* 1214 */       Date prevFireTime = trigger.getPreviousFireTime();
/*      */ 
/* 1216 */       tw.trigger.triggered(cal);
/* 1217 */       trigger.triggered(cal);
/*      */ 
/* 1219 */       tw.state = 0;
/*      */ 
/* 1221 */       TriggerFiredBundle bndle = new TriggerFiredBundle(retrieveJob(ctxt, trigger.getJobName(), trigger.getJobGroup()), trigger, cal, false, new Date(), trigger.getPreviousFireTime(), prevFireTime, trigger.getNextFireTime());
/*      */ 
/* 1226 */       JobDetail job = bndle.getJobDetail();
/*      */ 
/* 1228 */       if (job.isStateful()) {
/* 1229 */         ArrayList trigs = getTriggerWrappersForJob(job.getName(), job.getGroup());
/*      */ 
/* 1231 */         Iterator itr = trigs.iterator();
/* 1232 */         while (itr.hasNext()) {
/* 1233 */           TriggerWrapper ttw = (TriggerWrapper)itr.next();
/* 1234 */           if (ttw.state == 0)
/* 1235 */             ttw.state = 5;
/* 1236 */           if (ttw.state == 4)
/* 1237 */             ttw.state = 6;
/* 1238 */           this.timeTriggers.remove(ttw);
/*      */         }
/* 1240 */         this.blockedJobs.add(JobWrapper.getJobNameKey(job));
/* 1241 */       } else if (tw.trigger.getNextFireTime() != null) {
/* 1242 */         synchronized (this.triggerLock) {
/* 1243 */           this.timeTriggers.add(tw);
/*      */         }
/*      */       }
/*      */ 
/* 1247 */       return bndle;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void triggeredJobComplete(SchedulingContext ctxt, Trigger trigger, JobDetail jobDetail, int triggerInstCode)
/*      */   {
/* 1263 */     synchronized (this.triggerLock)
/*      */     {
/* 1265 */       String jobKey = JobWrapper.getJobNameKey(jobDetail.getName(), jobDetail.getGroup());
/*      */ 
/* 1267 */       JobWrapper jw = (JobWrapper)this.jobsByFQN.get(jobKey);
/* 1268 */       TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(trigger));
/*      */ 
/* 1275 */       if (jw != null) {
/* 1276 */         JobDetail jd = jw.jobDetail;
/*      */ 
/* 1278 */         if (jobDetail.isStateful()) {
/* 1279 */           JobDataMap newData = jobDetail.getJobDataMap();
/* 1280 */           if (newData != null) newData.clearDirtyFlag();
/* 1281 */           jd.setJobDataMap(newData);
/* 1282 */           this.blockedJobs.remove(JobWrapper.getJobNameKey(jd));
/* 1283 */           ArrayList trigs = getTriggerWrappersForJob(jd.getName(), jd.getGroup());
/*      */ 
/* 1285 */           Iterator itr = trigs.iterator();
/* 1286 */           while (itr.hasNext()) {
/* 1287 */             TriggerWrapper ttw = (TriggerWrapper)itr.next();
/* 1288 */             if (ttw.state == 5) {
/* 1289 */               ttw.state = 0;
/* 1290 */               this.timeTriggers.add(ttw);
/*      */             }
/* 1292 */             if (ttw.state == 6)
/* 1293 */               ttw.state = 4;
/*      */           }
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1299 */         this.blockedJobs.remove(JobWrapper.getJobNameKey(jobDetail));
/*      */       }
/*      */ 
/* 1303 */       if (tw != null)
/* 1304 */         if (triggerInstCode == 3)
/*      */         {
/* 1306 */           if (trigger.getNextFireTime() == null)
/*      */           {
/* 1309 */             if (tw.getTrigger().getNextFireTime() == null)
/* 1310 */               removeTrigger(ctxt, trigger.getName(), trigger.getGroup());
/*      */           }
/*      */           else
/* 1313 */             removeTrigger(ctxt, trigger.getName(), trigger.getGroup());
/*      */         }
/* 1315 */         else if (triggerInstCode == 2) {
/* 1316 */           tw.state = 3;
/* 1317 */           this.timeTriggers.remove(tw);
/*      */         }
/* 1319 */         else if (triggerInstCode == 5) {
/* 1320 */           getLog().info("Trigger " + trigger.getFullName() + " set to ERROR state.");
/* 1321 */           tw.state = 7;
/*      */         }
/* 1323 */         else if (triggerInstCode == 6) {
/* 1324 */           getLog().info("All triggers of Job " + trigger.getFullJobName() + " set to ERROR state.");
/*      */ 
/* 1326 */           setAllTriggersOfJobToState(trigger.getJobName(), trigger.getJobGroup(), 7);
/*      */         }
/* 1331 */         else if (triggerInstCode == 4) {
/* 1332 */           setAllTriggersOfJobToState(trigger.getJobName(), trigger.getJobGroup(), 3);
/*      */         }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void setAllTriggersOfJobToState(String jobName, String jobGroup, int state)
/*      */   {
/* 1342 */     ArrayList tws = getTriggerWrappersForJob(jobName, jobGroup);
/* 1343 */     Iterator itr = tws.iterator();
/* 1344 */     while (itr.hasNext()) {
/* 1345 */       TriggerWrapper tw = (TriggerWrapper)itr.next();
/* 1346 */       tw.state = state;
/* 1347 */       if (state != 0)
/* 1348 */         this.timeTriggers.remove(tw);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected String peekTriggers()
/*      */   {
/* 1354 */     StringBuffer str = new StringBuffer();
/* 1355 */     TriggerWrapper tw = null;
/*      */ 
/* 1357 */     synchronized (this.triggerLock) {
/* 1358 */       Iterator itr = this.triggersByFQN.keySet().iterator();
/* 1359 */       while (itr.hasNext()) {
/* 1360 */         tw = (TriggerWrapper)this.triggersByFQN.get(itr.next());
/* 1361 */         str.append(tw.trigger.getName());
/* 1362 */         str.append("/");
/*      */       }
/*      */     }
/* 1365 */     str.append(" | ");
/*      */ 
/* 1367 */     synchronized (this.triggerLock) {
/* 1368 */       Iterator itr = this.timeTriggers.iterator();
/* 1369 */       while (itr.hasNext()) {
/* 1370 */         tw = (TriggerWrapper)itr.next();
/* 1371 */         str.append(tw.trigger.getName());
/* 1372 */         str.append("->");
/*      */       }
/*      */     }
/*      */ 
/* 1376 */     return str.toString();
/*      */   }
/*      */ 
/*      */   public Set getPausedTriggerGroups(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/* 1383 */     HashSet set = new HashSet();
/*      */ 
/* 1385 */     set.addAll(this.pausedTriggerGroups);
/*      */ 
/* 1387 */     return set;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.simpl.RAMJobStore
 * JD-Core Version:    0.6.0
 */