/*      */ package org.quartz.simpl;
/*      */ 
/*      */ import org.quartz.JobDetail;
/*      */ 
/*      */ class JobWrapper
/*      */ {
/*      */   public String key;
/*      */   public JobDetail jobDetail;
/*      */ 
/*      */   JobWrapper(JobDetail jobDetail)
/*      */   {
/* 1427 */     this.jobDetail = jobDetail;
/* 1428 */     this.key = getJobNameKey(jobDetail);
/*      */   }
/*      */ 
/*      */   JobWrapper(JobDetail jobDetail, String key) {
/* 1432 */     this.jobDetail = jobDetail;
/* 1433 */     this.key = key;
/*      */   }
/*      */ 
/*      */   static String getJobNameKey(JobDetail jobDetail) {
/* 1437 */     return jobDetail.getGroup() + "_$x$x$_" + jobDetail.getName();
/*      */   }
/*      */ 
/*      */   static String getJobNameKey(String jobName, String groupName) {
/* 1441 */     return groupName + "_$x$x$_" + jobName;
/*      */   }
/*      */ 
/*      */   public boolean equals(Object obj) {
/* 1445 */     if ((obj instanceof JobWrapper)) {
/* 1446 */       JobWrapper jw = (JobWrapper)obj;
/* 1447 */       if (jw.key.equals(this.key)) return true;
/*      */     }
/*      */ 
/* 1450 */     return false;
/*      */   }
/*      */ 
/*      */   public int hashCode() {
/* 1454 */     return this.key.hashCode();
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.simpl.JobWrapper
 * JD-Core Version:    0.6.0
 */