/*     */ package org.quartz.plugins.xml;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.util.Date;
/*     */ import java.util.Iterator;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.Vector;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.quartz.JobDataMap;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.SchedulerContext;
/*     */ import org.quartz.SchedulerException;
/*     */ import org.quartz.SimpleTrigger;
/*     */ import org.quartz.jobs.FileScanJob;
/*     */ import org.quartz.jobs.FileScanListener;
/*     */ import org.quartz.spi.SchedulerPlugin;
/*     */ import org.quartz.xml.JobSchedulingDataProcessor;
/*     */ 
/*     */ public class JobInitializationPluginMultiple
/*     */   implements SchedulerPlugin, FileScanListener
/*     */ {
/*     */   private String name;
/*     */   private Scheduler scheduler;
/*  65 */   private boolean overWriteExistingJobs = true;
/*     */ 
/*  67 */   private boolean failOnFileNotFound = true;
/*     */ 
/*  69 */   private String fileName = "quartz_jobs.xml";
/*     */ 
/*  71 */   private Vector files = new Vector();
/*     */ 
/*  73 */   private boolean useContextClassLoader = true;
/*     */ 
/*  75 */   private boolean validating = true;
/*     */ 
/*  77 */   private boolean validatingSchema = true;
/*     */ 
/*  79 */   private long scanInterval = 0L;
/*     */ 
/*  81 */   boolean initializing = true;
/*     */ 
/*  83 */   boolean started = false;
/*     */ 
/*     */   public boolean isOverWriteExistingJobs()
/*     */   {
/* 111 */     return this.overWriteExistingJobs;
/*     */   }
/*     */ 
/*     */   public void setOverWriteExistingJobs(boolean overWriteExistingJobs)
/*     */   {
/* 121 */     this.overWriteExistingJobs = overWriteExistingJobs;
/*     */   }
/*     */ 
/*     */   public String getFileName()
/*     */   {
/* 130 */     return this.fileName;
/*     */   }
/*     */ 
/*     */   public void setFileName(String fileName)
/*     */   {
/* 139 */     this.fileName = fileName;
/*     */   }
/*     */ 
/*     */   public long getScanInterval()
/*     */   {
/* 150 */     return this.scanInterval / 1000L;
/*     */   }
/*     */ 
/*     */   public void setScanInterval(long scanInterval)
/*     */   {
/* 161 */     this.scanInterval = (scanInterval * 1000L);
/*     */   }
/*     */ 
/*     */   public boolean isFailOnFileNotFound()
/*     */   {
/* 171 */     return this.failOnFileNotFound;
/*     */   }
/*     */ 
/*     */   public void setFailOnFileNotFound(boolean failOnFileNotFound)
/*     */   {
/* 181 */     this.failOnFileNotFound = failOnFileNotFound;
/*     */   }
/*     */ 
/*     */   public boolean isUseContextClassLoader()
/*     */   {
/* 190 */     return this.useContextClassLoader;
/*     */   }
/*     */ 
/*     */   public void setUseContextClassLoader(boolean useContextClassLoader)
/*     */   {
/* 199 */     this.useContextClassLoader = useContextClassLoader;
/*     */   }
/*     */ 
/*     */   public boolean isValidating()
/*     */   {
/* 208 */     return this.validating;
/*     */   }
/*     */ 
/*     */   public void setValidating(boolean validating)
/*     */   {
/* 217 */     this.validating = validating;
/*     */   }
/*     */ 
/*     */   public boolean isValidatingSchema()
/*     */   {
/* 226 */     return this.validatingSchema;
/*     */   }
/*     */ 
/*     */   public void setValidatingSchema(boolean validatingSchema)
/*     */   {
/* 235 */     this.validatingSchema = validatingSchema;
/*     */   }
/*     */ 
/*     */   protected static Log getLog() {
/* 239 */     return LogFactory.getLog(JobInitializationPluginMultiple.class);
/*     */   }
/*     */ 
/*     */   public void initialize(String name, Scheduler scheduler)
/*     */     throws SchedulerException
/*     */   {
/* 262 */     this.initializing = true;
/*     */     try {
/* 264 */       this.name = name;
/* 265 */       this.scheduler = scheduler;
/*     */ 
/* 267 */       getLog().info("Registering Quartz Job Initialization Plug-in.");
/*     */ 
/* 269 */       updateJobFileList();
/*     */     }
/*     */     finally {
/* 272 */       this.initializing = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   private void updateJobFileList() {
/* 277 */     StringTokenizer stok = new StringTokenizer(this.fileName, ",");
/*     */ 
/* 279 */     while (stok.hasMoreTokens()) {
/* 280 */       JobFile jobFile = new JobFile(stok.nextToken());
/* 281 */       this.files.add(jobFile);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/* 288 */     if (this.scanInterval > 0L) {
/*     */       try {
/* 290 */         Iterator iterator = this.files.iterator();
/* 291 */         while (iterator.hasNext()) {
/* 292 */           JobFile jobFile = (JobFile)iterator.next();
/*     */ 
/* 294 */           SimpleTrigger trig = new SimpleTrigger("JobInitializationPluginMultiple_" + this.name, "JobInitializationPluginMultiple", new Date(), null, SimpleTrigger.REPEAT_INDEFINITELY, this.scanInterval);
/*     */ 
/* 299 */           trig.setVolatility(true);
/* 300 */           JobDetail job = new JobDetail("JobInitializationPluginMultiple_" + this.name, "JobInitializationPluginMultiple", FileScanJob.class);
/*     */ 
/* 304 */           job.setVolatility(true);
/* 305 */           job.getJobDataMap().put(FileScanJob.FILE_NAME, jobFile.getFilePath());
/* 306 */           job.getJobDataMap().put(FileScanJob.FILE_SCAN_LISTENER_NAME, "JobInitializationPluginMultiple_" + this.name);
/*     */ 
/* 308 */           this.scheduler.getContext().put("JobInitializationPluginMultiple_" + this.name, this);
/* 309 */           this.scheduler.scheduleJob(job, trig);
/*     */         }
/*     */       }
/*     */       catch (SchedulerException se) {
/* 313 */         getLog().error("Error starting background-task for watching jobs file.", se);
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/* 318 */       processFiles();
/*     */     }
/*     */     finally {
/* 321 */       this.started = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void processFiles()
/*     */   {
/* 338 */     JobSchedulingDataProcessor processor = new JobSchedulingDataProcessor(isUseContextClassLoader(), isValidating(), isValidatingSchema());
/*     */ 
/* 341 */     Iterator iterator = this.files.iterator();
/* 342 */     while (iterator.hasNext()) {
/* 343 */       JobFile jobFile = (JobFile)iterator.next();
/*     */       try
/*     */       {
/* 346 */         if (jobFile.getFileFound())
/* 347 */           processor.processFileAndScheduleJobs(jobFile.getFileName(), this.scheduler, isOverWriteExistingJobs());
/*     */       }
/*     */       catch (Exception e) {
/* 350 */         getLog().error("Error scheduling jobs: " + e.getMessage(), e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void fileUpdated(String fileName)
/*     */   {
/* 359 */     if (this.started)
/* 360 */       processFiles();
/*     */   }
/*     */ 
/*     */   class JobFile {
/* 364 */     private String fileName = null;
/*     */ 
/* 366 */     private String filePath = null;
/*     */ 
/* 368 */     private boolean fileFound = false;
/*     */ 
/*     */     protected JobFile(String fileName) {
/* 371 */       this.fileName = fileName;
/*     */     }
/*     */ 
/*     */     protected String getFileName() {
/* 375 */       return this.fileName;
/*     */     }
/*     */ 
/*     */     protected boolean getFileFound() throws SchedulerException {
/* 379 */       if (this.filePath == null) {
/* 380 */         findFile();
/*     */       }
/*     */ 
/* 383 */       return this.fileFound;
/*     */     }
/*     */ 
/*     */     protected String getFilePath() throws SchedulerException {
/* 387 */       if (this.filePath == null) {
/* 388 */         findFile();
/*     */       }
/*     */ 
/* 391 */       return this.filePath;
/*     */     }
/*     */ 
/*     */     private void findFile()
/*     */       throws SchedulerException
/*     */     {
/* 398 */       InputStream f = null;
/*     */ 
/* 400 */       File file = new File(this.fileName);
/* 401 */       if ((file == null) || (!file.exists()))
/*     */       {
/* 403 */         URL url = Thread.currentThread().getContextClassLoader().getResource(this.fileName);
/*     */ 
/* 406 */         if (url != null)
/* 407 */           file = new File(url.getPath());
/*     */       }
/*     */       try
/*     */       {
/* 411 */         f = new FileInputStream(file);
/*     */       }
/*     */       catch (FileNotFoundException e)
/*     */       {
/*     */       }
/* 416 */       if ((f == null) && (JobInitializationPluginMultiple.this.isFailOnFileNotFound())) {
/* 417 */         throw new SchedulerException("File named '" + this.fileName + "' does not exist.");
/*     */       }
/* 419 */       if (f == null) {
/* 420 */         JobInitializationPluginMultiple.getLog().warn("File named '" + this.fileName + "' does not exist.");
/*     */       } else {
/* 422 */         this.fileFound = true;
/*     */         try {
/* 424 */           this.filePath = file.getPath();
/* 425 */           f.close();
/*     */         } catch (IOException ioe) {
/* 427 */           JobInitializationPluginMultiple.getLog().warn("Error closing file named '" + this.fileName, ioe);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.plugins.xml.JobInitializationPluginMultiple
 * JD-Core Version:    0.6.0
 */