/*      */ package org.quartz.impl.jdbcjobstore;
/*      */ 
/*      */ import java.sql.Connection;
/*      */ import java.sql.SQLException;
/*      */ import java.util.List;
/*      */ import java.util.Set;
/*      */ import org.apache.commons.logging.Log;
/*      */ import org.quartz.Calendar;
/*      */ import org.quartz.JobDetail;
/*      */ import org.quartz.JobPersistenceException;
/*      */ import org.quartz.ObjectAlreadyExistsException;
/*      */ import org.quartz.SchedulerConfigException;
/*      */ import org.quartz.Trigger;
/*      */ import org.quartz.core.SchedulingContext;
/*      */ import org.quartz.spi.ClassLoadHelper;
/*      */ import org.quartz.spi.SchedulerSignaler;
/*      */ import org.quartz.spi.TriggerFiredBundle;
/*      */ import org.quartz.utils.DBConnectionManager;
/*      */ 
/*      */ public class JobStoreCMT extends JobStoreSupport
/*      */ {
/*      */   protected String nonManagedTxDsName;
/*   72 */   protected boolean dontSetNonManagedTXConnectionAutoCommitFalse = false;
/*      */ 
/*   75 */   protected boolean setTxIsolationLevelReadCommitted = false;
/*      */ 
/*      */   public void setNonManagedTXDataSource(String nonManagedTxDsName)
/*      */   {
/*   92 */     this.nonManagedTxDsName = nonManagedTxDsName;
/*      */   }
/*      */ 
/*      */   public String getNonManagedTXDataSource()
/*      */   {
/*  102 */     return this.nonManagedTxDsName;
/*      */   }
/*      */ 
/*      */   public boolean isDontSetNonManagedTXConnectionAutoCommitFalse() {
/*  106 */     return this.dontSetNonManagedTXConnectionAutoCommitFalse;
/*      */   }
/*      */ 
/*      */   public void setDontSetNonManagedTXConnectionAutoCommitFalse(boolean b)
/*      */   {
/*  117 */     this.dontSetNonManagedTXConnectionAutoCommitFalse = b;
/*      */   }
/*      */ 
/*      */   public boolean isTxIsolationLevelReadCommitted()
/*      */   {
/*  122 */     return this.setTxIsolationLevelReadCommitted;
/*      */   }
/*      */ 
/*      */   public void setTxIsolationLevelReadCommitted(boolean b)
/*      */   {
/*  131 */     this.setTxIsolationLevelReadCommitted = b;
/*      */   }
/*      */ 
/*      */   public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler)
/*      */     throws SchedulerConfigException
/*      */   {
/*  138 */     if (this.nonManagedTxDsName == null) {
/*  139 */       throw new SchedulerConfigException("Non-ManagedTX DataSource name not set!");
/*      */     }
/*      */ 
/*  142 */     setUseDBLocks(true);
/*      */ 
/*  144 */     super.initialize(loadHelper, signaler);
/*      */ 
/*  146 */     getLog().info("JobStoreCMT initialized.");
/*      */   }
/*      */ 
/*      */   public void shutdown()
/*      */   {
/*  151 */     super.shutdown();
/*      */     try
/*      */     {
/*  154 */       DBConnectionManager.getInstance().shutdown(getNonManagedTXDataSource());
/*      */     } catch (SQLException sqle) {
/*  156 */       getLog().warn("Database connection shutdown unsuccessful.", sqle);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void recoverJobs()
/*      */     throws JobPersistenceException
/*      */   {
/*  175 */     Connection conn = null;
/*      */ 
/*  177 */     boolean transOwner = false;
/*      */     try
/*      */     {
/*  180 */       conn = getNonManagedTXConnection();
/*      */ 
/*  182 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  183 */       transOwner = true;
/*      */ 
/*  186 */       recoverJobs(conn);
/*      */ 
/*  188 */       conn.commit();
/*      */     } catch (JobPersistenceException e) {
/*  190 */       rollbackConnection(conn);
/*  191 */       throw e;
/*      */     } catch (Exception e) {
/*  193 */       rollbackConnection(conn);
/*  194 */       throw new JobPersistenceException("Error recovering jobs: " + e.getMessage(), e);
/*      */     }
/*      */     finally {
/*      */       try {
/*  198 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  200 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void cleanVolatileTriggerAndJobs() throws JobPersistenceException {
/*  206 */     Connection conn = null;
/*      */ 
/*  208 */     boolean transOwner = false;
/*      */     try
/*      */     {
/*  211 */       conn = getNonManagedTXConnection();
/*      */ 
/*  213 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  214 */       transOwner = true;
/*      */ 
/*  217 */       cleanVolatileTriggerAndJobs(conn);
/*      */ 
/*  219 */       conn.commit();
/*      */     } catch (JobPersistenceException e) {
/*  221 */       rollbackConnection(conn);
/*  222 */       throw e;
/*      */     } catch (Exception e) {
/*  224 */       rollbackConnection(conn);
/*  225 */       throw new JobPersistenceException("Error cleaning volatile data: " + e.getMessage(), e);
/*      */     }
/*      */     finally {
/*      */       try {
/*  229 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  231 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void storeJobAndTrigger(SchedulingContext ctxt, JobDetail newJob, Trigger newTrigger)
/*      */     throws ObjectAlreadyExistsException, JobPersistenceException
/*      */   {
/*  256 */     Connection conn = getConnection();
/*  257 */     boolean transOwner = false;
/*      */     try {
/*  259 */       if (isLockOnInsert()) {
/*  260 */         getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  261 */         transOwner = true;
/*      */       }
/*      */ 
/*  265 */       if ((newJob.isVolatile()) && (!newTrigger.isVolatile())) {
/*  266 */         JobPersistenceException jpe = new JobPersistenceException("Cannot associate non-volatile trigger with a volatile job!");
/*      */ 
/*  269 */         jpe.setErrorCode(100);
/*  270 */         throw jpe;
/*      */       }
/*      */ 
/*  273 */       storeJob(conn, ctxt, newJob, false);
/*  274 */       storeTrigger(conn, ctxt, newTrigger, newJob, false, "WAITING", false, false);
/*      */     }
/*      */     finally {
/*      */       try {
/*  278 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  280 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void storeJob(SchedulingContext ctxt, JobDetail newJob, boolean replaceExisting)
/*      */     throws ObjectAlreadyExistsException, JobPersistenceException
/*      */   {
/*  303 */     Connection conn = getConnection();
/*  304 */     boolean transOwner = false;
/*      */     try {
/*  306 */       if ((isLockOnInsert()) || (replaceExisting)) {
/*  307 */         getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  308 */         transOwner = true;
/*      */       }
/*      */ 
/*  312 */       storeJob(conn, ctxt, newJob, replaceExisting);
/*      */     } finally {
/*      */       try {
/*  315 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  317 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean removeJob(SchedulingContext ctxt, String jobName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  344 */     Connection conn = getConnection();
/*  345 */     boolean transOwner = false;
/*      */     try {
/*  347 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  348 */       transOwner = true;
/*      */ 
/*  351 */       bool1 = removeJob(conn, ctxt, jobName, groupName, true);
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*      */         boolean bool1;
/*  354 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  356 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public JobDetail retrieveJob(SchedulingContext ctxt, String jobName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  375 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  378 */       JobDetail localJobDetail = retrieveJob(conn, ctxt, jobName, groupName);
/*      */       return localJobDetail; } finally { closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public void storeTrigger(SchedulingContext ctxt, Trigger newTrigger, boolean replaceExisting)
/*      */     throws ObjectAlreadyExistsException, JobPersistenceException
/*      */   {
/*  402 */     Connection conn = getConnection();
/*  403 */     boolean transOwner = false;
/*      */     try {
/*  405 */       if ((isLockOnInsert()) || (replaceExisting)) {
/*  406 */         getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  407 */         transOwner = true;
/*      */       }
/*      */ 
/*  410 */       storeTrigger(conn, ctxt, newTrigger, null, replaceExisting, "WAITING", false, false);
/*      */     }
/*      */     finally {
/*      */       try {
/*  414 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  416 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean removeTrigger(SchedulingContext ctxt, String triggerName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  448 */     Connection conn = getConnection();
/*  449 */     boolean transOwner = false;
/*      */     try {
/*  451 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  452 */       transOwner = true;
/*      */ 
/*  454 */       bool1 = removeTrigger(conn, ctxt, triggerName, groupName);
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*      */         boolean bool1;
/*  457 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  459 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean replaceTrigger(SchedulingContext ctxt, String triggerName, String groupName, Trigger newTrigger)
/*      */     throws JobPersistenceException
/*      */   {
/*  469 */     Connection conn = getConnection();
/*  470 */     boolean transOwner = false;
/*      */     try {
/*  472 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  473 */       transOwner = true;
/*      */ 
/*  475 */       bool1 = replaceTrigger(conn, ctxt, triggerName, groupName, newTrigger);
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*      */         boolean bool1;
/*  478 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  480 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Trigger retrieveTrigger(SchedulingContext ctxt, String triggerName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  499 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  502 */       Trigger localTrigger = retrieveTrigger(conn, ctxt, triggerName, groupName);
/*      */       return localTrigger; } finally { closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public void storeCalendar(SchedulingContext ctxt, String calName, Calendar calendar, boolean replaceExisting, boolean updateTriggers)
/*      */     throws ObjectAlreadyExistsException, JobPersistenceException
/*      */   {
/*  528 */     Connection conn = getConnection();
/*  529 */     boolean lockOwner = false;
/*      */     try {
/*  531 */       if ((isLockOnInsert()) || (updateTriggers)) {
/*  532 */         getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  533 */         lockOwner = true;
/*      */       }
/*      */ 
/*  536 */       storeCalendar(conn, ctxt, calName, calendar, replaceExisting, updateTriggers);
/*      */     } finally {
/*      */       try {
/*  539 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, lockOwner);
/*      */       } finally {
/*  541 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean removeCalendar(SchedulingContext ctxt, String calName)
/*      */     throws JobPersistenceException
/*      */   {
/*  563 */     Connection conn = getConnection();
/*  564 */     boolean lockOwner = false;
/*      */     try {
/*  566 */       getLockHandler().obtainLock(conn, LOCK_CALENDAR_ACCESS);
/*  567 */       lockOwner = true;
/*      */ 
/*  569 */       bool1 = removeCalendar(conn, ctxt, calName);
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*      */         boolean bool1;
/*  572 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, lockOwner);
/*      */       } finally {
/*  574 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Calendar retrieveCalendar(SchedulingContext ctxt, String calName)
/*      */     throws JobPersistenceException
/*      */   {
/*  591 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  594 */       Calendar localCalendar = retrieveCalendar(conn, ctxt, calName);
/*      */       return localCalendar; } finally { closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public int getNumberOfJobs(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/*  612 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  615 */       int i = getNumberOfJobs(conn, ctxt);
/*      */       return i; } finally { closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public int getNumberOfTriggers(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/*  629 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  632 */       int i = getNumberOfTriggers(conn, ctxt);
/*      */       return i; } finally { closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public int getNumberOfCalendars(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/*  646 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  649 */       int i = getNumberOfCalendars(conn, ctxt);
/*      */       return i; } finally { closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public Set getPausedTriggerGroups(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/*  658 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  661 */       Set groups = getPausedTriggerGroups(conn, ctxt);
/*  662 */       Set localSet1 = groups;
/*      */       return localSet1; } finally { closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public String[] getJobNames(SchedulingContext ctxt, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  681 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  684 */       String[] arrayOfString = getJobNames(conn, ctxt, groupName);
/*      */       return arrayOfString; } finally { closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public String[] getTriggerNames(SchedulingContext ctxt, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  703 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  706 */       String[] arrayOfString = getTriggerNames(conn, ctxt, groupName);
/*      */       return arrayOfString; } finally { closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public String[] getJobGroupNames(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/*  725 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  728 */       String[] arrayOfString = getJobGroupNames(conn, ctxt);
/*      */       return arrayOfString; } finally { closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public String[] getTriggerGroupNames(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/*  747 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  750 */       String[] arrayOfString = getTriggerGroupNames(conn, ctxt);
/*      */       return arrayOfString; } finally { closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public String[] getCalendarNames(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/*  769 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  772 */       String[] arrayOfString = getCalendarNames(conn, ctxt);
/*      */       return arrayOfString; } finally { closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public Trigger[] getTriggersForJob(SchedulingContext ctxt, String jobName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  789 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  792 */       Trigger[] arrayOfTrigger = getTriggersForJob(conn, ctxt, jobName, groupName);
/*      */       return arrayOfTrigger; } finally { closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public int getTriggerState(SchedulingContext ctxt, String triggerName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  811 */     Connection conn = getConnection();
/*      */     try
/*      */     {
/*  814 */       int i = getTriggerState(conn, ctxt, triggerName, groupName);
/*      */       return i; } finally { closeConnection(conn); } throw localObject;
/*      */   }
/*      */ 
/*      */   public void pauseTrigger(SchedulingContext ctxt, String triggerName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  833 */     Connection conn = getConnection();
/*  834 */     boolean transOwner = false;
/*      */     try {
/*  836 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  837 */       transOwner = true;
/*      */ 
/*  840 */       pauseTrigger(conn, ctxt, triggerName, groupName);
/*      */     } finally {
/*      */       try {
/*  843 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  845 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseTriggerGroup(SchedulingContext ctxt, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  860 */     Connection conn = getConnection();
/*  861 */     boolean transOwner = false;
/*      */     try {
/*  863 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  864 */       transOwner = true;
/*      */ 
/*  867 */       pauseTriggerGroup(conn, ctxt, groupName);
/*      */     } finally {
/*      */       try {
/*  870 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  872 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseJob(SchedulingContext ctxt, String jobName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  887 */     Connection conn = getConnection();
/*  888 */     boolean transOwner = false;
/*      */     try {
/*  890 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  891 */       transOwner = true;
/*      */ 
/*  894 */       Trigger[] triggers = getTriggersForJob(conn, ctxt, jobName, groupName);
/*      */ 
/*  896 */       for (int j = 0; j < triggers.length; j++)
/*  897 */         pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
/*      */     }
/*      */     finally
/*      */     {
/*      */       try {
/*  902 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  904 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseJobGroup(SchedulingContext ctxt, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  919 */     Connection conn = getConnection();
/*  920 */     boolean transOwner = false;
/*      */     try {
/*  922 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  923 */       transOwner = true;
/*      */ 
/*  926 */       String[] jobNames = getJobNames(conn, ctxt, groupName);
/*      */ 
/*  928 */       for (int i = 0; i < jobNames.length; i++) {
/*  929 */         Trigger[] triggers = getTriggersForJob(conn, ctxt, jobNames[i], groupName);
/*      */ 
/*  931 */         for (int j = 0; j < triggers.length; j++)
/*  932 */           pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*      */       try {
/*  938 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  940 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeTrigger(SchedulingContext ctxt, String triggerName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  960 */     Connection conn = getConnection();
/*  961 */     boolean transOwner = false;
/*      */     try {
/*  963 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  964 */       transOwner = true;
/*      */ 
/*  967 */       resumeTrigger(conn, ctxt, triggerName, groupName);
/*      */     } finally {
/*      */       try {
/*  970 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/*  972 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeTriggerGroup(SchedulingContext ctxt, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/*  992 */     Connection conn = getConnection();
/*  993 */     boolean transOwner = false;
/*      */     try {
/*  995 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*  996 */       transOwner = true;
/*      */ 
/*  999 */       resumeTriggerGroup(conn, ctxt, groupName);
/*      */     } finally {
/*      */       try {
/* 1002 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1004 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeJob(SchedulingContext ctxt, String jobName, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/* 1025 */     Connection conn = getConnection();
/* 1026 */     boolean transOwner = false;
/*      */     try {
/* 1028 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1029 */       transOwner = true;
/*      */ 
/* 1032 */       Trigger[] triggers = getTriggersForJob(conn, ctxt, jobName, groupName);
/*      */ 
/* 1034 */       for (int j = 0; j < triggers.length; j++)
/* 1035 */         resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
/*      */     }
/*      */     finally
/*      */     {
/*      */       try {
/* 1040 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1042 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeJobGroup(SchedulingContext ctxt, String groupName)
/*      */     throws JobPersistenceException
/*      */   {
/* 1063 */     Connection conn = getConnection();
/* 1064 */     boolean transOwner = false;
/*      */     try {
/* 1066 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1067 */       transOwner = true;
/*      */ 
/* 1070 */       String[] jobNames = getJobNames(conn, ctxt, groupName);
/*      */ 
/* 1072 */       for (int i = 0; i < jobNames.length; i++) {
/* 1073 */         Trigger[] triggers = getTriggersForJob(conn, ctxt, jobNames[i], groupName);
/*      */ 
/* 1075 */         for (int j = 0; j < triggers.length; j++)
/* 1076 */           resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*      */       try {
/* 1082 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1084 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseAll(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/* 1104 */     Connection conn = getConnection();
/* 1105 */     boolean transOwner = false;
/*      */     try {
/* 1107 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1108 */       transOwner = true;
/*      */ 
/* 1111 */       pauseAll(conn, ctxt);
/*      */     } finally {
/*      */       try {
/* 1114 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1116 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeAll(SchedulingContext ctxt)
/*      */     throws JobPersistenceException
/*      */   {
/* 1136 */     Connection conn = getConnection();
/* 1137 */     boolean transOwner = false;
/*      */     try {
/* 1139 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1140 */       transOwner = true;
/*      */ 
/* 1143 */       resumeAll(conn, ctxt);
/*      */     } finally {
/*      */       try {
/* 1146 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1148 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Trigger acquireNextTrigger(SchedulingContext ctxt, long noLaterThan)
/*      */     throws JobPersistenceException
/*      */   {
/* 1167 */     Connection conn = null;
/* 1168 */     boolean transOwner = false;
/*      */     try
/*      */     {
/* 1171 */       conn = getNonManagedTXConnection();
/*      */ 
/* 1173 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1174 */       transOwner = true;
/*      */ 
/* 1177 */       Trigger trigger = acquireNextTrigger(conn, ctxt, noLaterThan);
/*      */ 
/* 1179 */       conn.commit();
/* 1180 */       localTrigger1 = trigger;
/*      */     }
/*      */     catch (JobPersistenceException e)
/*      */     {
/*      */       Trigger localTrigger1;
/* 1182 */       rollbackConnection(conn);
/* 1183 */       throw e;
/*      */     } catch (Exception e) {
/* 1185 */       rollbackConnection(conn);
/* 1186 */       throw new JobPersistenceException("Error acquiring next firable trigger: " + e.getMessage(), e);
/*      */     }
/*      */     finally
/*      */     {
/*      */       try {
/* 1191 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1193 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void releaseAcquiredTrigger(SchedulingContext ctxt, Trigger trigger)
/*      */     throws JobPersistenceException
/*      */   {
/* 1207 */     Connection conn = null;
/* 1208 */     boolean transOwner = false;
/*      */     try
/*      */     {
/* 1211 */       conn = getNonManagedTXConnection();
/*      */ 
/* 1213 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1214 */       transOwner = true;
/*      */ 
/* 1217 */       releaseAcquiredTrigger(conn, ctxt, trigger);
/* 1218 */       conn.commit();
/*      */     } catch (JobPersistenceException e) {
/* 1220 */       rollbackConnection(conn);
/* 1221 */       throw e;
/*      */     } catch (Exception e) {
/* 1223 */       rollbackConnection(conn);
/* 1224 */       throw new JobPersistenceException("Error releasing acquired trigger: " + e.getMessage(), e);
/*      */     }
/*      */     finally {
/*      */       try {
/* 1228 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1230 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public TriggerFiredBundle triggerFired(SchedulingContext ctxt, Trigger trigger)
/*      */     throws JobPersistenceException
/*      */   {
/* 1248 */     Connection conn = null;
/* 1249 */     boolean transOwner = false;
/*      */     try
/*      */     {
/* 1252 */       conn = getNonManagedTXConnection();
/*      */ 
/* 1254 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1255 */       transOwner = true;
/*      */ 
/* 1258 */       TriggerFiredBundle tfb = null;
/* 1259 */       JobPersistenceException err = null;
/*      */       try {
/* 1261 */         tfb = triggerFired(conn, ctxt, trigger);
/*      */       } catch (JobPersistenceException jpe) {
/* 1263 */         if (jpe.getErrorCode() != 410)
/* 1264 */           throw jpe;
/* 1265 */         err = jpe;
/*      */       }
/*      */ 
/* 1268 */       if (err != null) throw err;
/*      */ 
/* 1270 */       conn.commit();
/* 1271 */       jpe = tfb;
/*      */     } catch (JobPersistenceException e) {
/* 1273 */       rollbackConnection(conn);
/* 1274 */       throw e;
/*      */     } catch (Exception e) {
/* 1276 */       rollbackConnection(conn);
/* 1277 */       throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
/*      */     }
/*      */     finally {
/*      */       try {
/* 1281 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1283 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void triggeredJobComplete(SchedulingContext ctxt, Trigger trigger, JobDetail jobDetail, int triggerInstCode)
/*      */     throws JobPersistenceException
/*      */   {
/* 1300 */     Connection conn = null;
/* 1301 */     boolean transOwner = false;
/*      */     try
/*      */     {
/* 1304 */       conn = getNonManagedTXConnection();
/* 1305 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1306 */       transOwner = true;
/*      */ 
/* 1309 */       triggeredJobComplete(conn, ctxt, trigger, jobDetail, triggerInstCode);
/*      */ 
/* 1312 */       conn.commit();
/*      */     } catch (JobPersistenceException e) {
/* 1314 */       rollbackConnection(conn);
/* 1315 */       throw e;
/*      */     } catch (Exception e) {
/* 1317 */       rollbackConnection(conn);
/* 1318 */       throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
/*      */     }
/*      */     finally {
/*      */       try {
/* 1322 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1324 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected boolean doRecoverMisfires() throws JobPersistenceException {
/* 1330 */     Connection conn = null;
/* 1331 */     boolean transOwner = false;
/* 1332 */     boolean moreToDo = false;
/*      */     try
/*      */     {
/* 1335 */       conn = getNonManagedTXConnection();
/*      */ 
/* 1337 */       getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/* 1338 */       transOwner = true;
/*      */       try
/*      */       {
/* 1341 */         moreToDo = recoverMisfiredJobs(conn, false);
/*      */       } catch (Exception e) {
/* 1343 */         throw new JobPersistenceException(e.getMessage(), e);
/*      */       }
/*      */ 
/* 1346 */       conn.commit();
/*      */ 
/* 1348 */       e = moreToDo;
/*      */     } catch (JobPersistenceException e) {
/* 1350 */       rollbackConnection(conn);
/* 1351 */       throw e;
/*      */     } catch (Exception e) {
/* 1353 */       rollbackConnection(conn);
/* 1354 */       throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
/*      */     }
/*      */     finally {
/*      */       try {
/* 1358 */         releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
/*      */       } finally {
/* 1360 */         closeConnection(conn);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected boolean doCheckin() throws JobPersistenceException
/*      */   {
/* 1367 */     Connection conn = null;
/*      */ 
/* 1369 */     boolean transOwner = false;
/* 1370 */     boolean transStateOwner = false;
/* 1371 */     boolean recovered = false;
/*      */     try
/*      */     {
/* 1374 */       conn = getNonManagedTXConnection();
/*      */ 
/* 1379 */       List failedRecords = this.firstCheckIn ? null : clusterCheckIn(conn);
/*      */ 
/* 1381 */       if ((this.firstCheckIn) || (failedRecords.size() > 0)) {
/* 1382 */         getLockHandler().obtainLock(conn, LOCK_STATE_ACCESS);
/* 1383 */         transStateOwner = true;
/*      */ 
/* 1387 */         failedRecords = this.firstCheckIn ? clusterCheckIn(conn) : findFailedInstances(conn);
/*      */ 
/* 1389 */         if (failedRecords.size() > 0) {
/* 1390 */           getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
/*      */ 
/* 1392 */           transOwner = true;
/*      */ 
/* 1394 */           clusterRecover(conn, failedRecords);
/* 1395 */           recovered = true;
/*      */         }
/*      */       }
/* 1398 */       conn.commit();
/*      */     } catch (JobPersistenceException e) {
/* 1400 */       rollbackConnection(conn);
/* 1401 */       throw e;
/*      */     } catch (Exception e) {
/* 1403 */       rollbackConnection(conn);
/* 1404 */       throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
/*      */     }
/*      */     finally
/*      */     {
/*      */     }
/*      */ 
/* 1413 */     ret;
/*      */ 
/* 1418 */     this.firstCheckIn = false;
/*      */ 
/* 1420 */     return recovered;
/*      */   }
/*      */ 
/*      */   protected Connection getNonManagedTXConnection()
/*      */     throws JobPersistenceException
/*      */   {
/*      */     try
/*      */     {
/* 1431 */       Connection conn = DBConnectionManager.getInstance().getConnection(getNonManagedTXDataSource());
/*      */ 
/* 1434 */       if (conn == null) throw new SQLException("Could not get connection from DataSource '" + getNonManagedTXDataSource() + "'");
/*      */ 
/*      */       try
/*      */       {
/* 1439 */         if (!isDontSetNonManagedTXConnectionAutoCommitFalse()) {
/* 1440 */           conn.setAutoCommit(false);
/*      */         }
/* 1442 */         if (isTxIsolationLevelReadCommitted())
/* 1443 */           conn.setTransactionIsolation(1);
/*      */       } catch (SQLException ingore) {
/*      */       } catch (Exception e) {
/* 1446 */         if (conn != null) try {
/* 1447 */             conn.close(); } catch (Throwable tt) {
/*      */           } throw new JobPersistenceException("Failure setting up connection.", e);
/*      */       }
/*      */ 
/* 1452 */       return conn;
/*      */     } catch (SQLException sqle) {
/* 1454 */       throw new JobPersistenceException("Failed to obtain DB connection from data source '" + getNonManagedTXDataSource() + "': " + sqle.toString(), sqle);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*      */     }
/* 1459 */     throw new JobPersistenceException("Failed to obtain DB connection from data source '" + getNonManagedTXDataSource() + "': " + e.toString(), e, 499);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.jdbcjobstore.JobStoreCMT
 * JD-Core Version:    0.6.0
 */