package org.quartz.impl.jdbcjobstore;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.utils.Key;
import org.quartz.utils.TriggerStatus;

public abstract interface DriverDelegate
{
  public abstract int updateTriggerStatesFromOtherStates(Connection paramConnection, String paramString1, String paramString2, String paramString3)
    throws SQLException;

  public abstract Key[] selectMisfiredTriggers(Connection paramConnection, long paramLong)
    throws SQLException;

  public abstract Key[] selectMisfiredTriggersInState(Connection paramConnection, String paramString, long paramLong)
    throws SQLException;

  public abstract Key[] selectMisfiredTriggersInGroupInState(Connection paramConnection, String paramString1, String paramString2, long paramLong)
    throws SQLException;

  public abstract Trigger[] selectTriggersForRecoveringJobs(Connection paramConnection)
    throws SQLException, IOException, ClassNotFoundException;

  public abstract int deleteFiredTriggers(Connection paramConnection)
    throws SQLException;

  public abstract int deleteFiredTriggers(Connection paramConnection, String paramString)
    throws SQLException;

  public abstract int deleteVolatileFiredTriggers(Connection paramConnection)
    throws SQLException;

  public abstract Key[] selectVolatileTriggers(Connection paramConnection)
    throws SQLException;

  public abstract Key[] selectVolatileJobs(Connection paramConnection)
    throws SQLException;

  public abstract int insertJobDetail(Connection paramConnection, JobDetail paramJobDetail)
    throws IOException, SQLException;

  public abstract int updateJobDetail(Connection paramConnection, JobDetail paramJobDetail)
    throws IOException, SQLException;

  public abstract Key[] selectTriggerNamesForJob(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract int deleteJobListeners(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract int deleteJobDetail(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract boolean isJobStateful(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract boolean jobExists(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract int updateJobData(Connection paramConnection, JobDetail paramJobDetail)
    throws IOException, SQLException;

  public abstract int insertJobListener(Connection paramConnection, JobDetail paramJobDetail, String paramString)
    throws SQLException;

  public abstract String[] selectJobListeners(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract JobDetail selectJobDetail(Connection paramConnection, String paramString1, String paramString2, ClassLoadHelper paramClassLoadHelper)
    throws ClassNotFoundException, IOException, SQLException;

  public abstract int selectNumJobs(Connection paramConnection)
    throws SQLException;

  public abstract String[] selectJobGroups(Connection paramConnection)
    throws SQLException;

  public abstract String[] selectJobsInGroup(Connection paramConnection, String paramString)
    throws SQLException;

  public abstract int insertTrigger(Connection paramConnection, Trigger paramTrigger, String paramString, JobDetail paramJobDetail)
    throws SQLException, IOException;

  public abstract int insertSimpleTrigger(Connection paramConnection, SimpleTrigger paramSimpleTrigger)
    throws SQLException;

  public abstract int insertBlobTrigger(Connection paramConnection, Trigger paramTrigger)
    throws SQLException, IOException;

  public abstract int insertCronTrigger(Connection paramConnection, CronTrigger paramCronTrigger)
    throws SQLException;

  public abstract int updateTrigger(Connection paramConnection, Trigger paramTrigger, String paramString, JobDetail paramJobDetail)
    throws SQLException, IOException;

  public abstract int updateSimpleTrigger(Connection paramConnection, SimpleTrigger paramSimpleTrigger)
    throws SQLException;

  public abstract int updateCronTrigger(Connection paramConnection, CronTrigger paramCronTrigger)
    throws SQLException;

  public abstract int updateBlobTrigger(Connection paramConnection, Trigger paramTrigger)
    throws SQLException, IOException;

  public abstract boolean triggerExists(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract int updateTriggerState(Connection paramConnection, String paramString1, String paramString2, String paramString3)
    throws SQLException;

  public abstract int updateTriggerStateFromOtherState(Connection paramConnection, String paramString1, String paramString2, String paramString3, String paramString4)
    throws SQLException;

  public abstract int updateTriggerStateFromOtherStates(Connection paramConnection, String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, String paramString6)
    throws SQLException;

  public abstract int updateTriggerStateFromOtherStatesBeforeTime(Connection paramConnection, String paramString1, String paramString2, String paramString3, long paramLong)
    throws SQLException;

  public abstract int updateTriggerGroupStateFromOtherStates(Connection paramConnection, String paramString1, String paramString2, String paramString3, String paramString4, String paramString5)
    throws SQLException;

  public abstract int updateTriggerGroupStateFromOtherState(Connection paramConnection, String paramString1, String paramString2, String paramString3)
    throws SQLException;

  public abstract int updateTriggerStatesForJob(Connection paramConnection, String paramString1, String paramString2, String paramString3)
    throws SQLException;

  public abstract int updateTriggerStatesForJobFromOtherState(Connection paramConnection, String paramString1, String paramString2, String paramString3, String paramString4)
    throws SQLException;

  public abstract int deleteTriggerListeners(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract int insertTriggerListener(Connection paramConnection, Trigger paramTrigger, String paramString)
    throws SQLException;

  public abstract String[] selectTriggerListeners(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract int deleteSimpleTrigger(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract int deleteBlobTrigger(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract int deleteCronTrigger(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract int deleteTrigger(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract int selectNumTriggersForJob(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract JobDetail selectJobForTrigger(Connection paramConnection, String paramString1, String paramString2, ClassLoadHelper paramClassLoadHelper)
    throws ClassNotFoundException, SQLException;

  public abstract List selectStatefulJobsOfTriggerGroup(Connection paramConnection, String paramString)
    throws SQLException;

  public abstract Trigger[] selectTriggersForJob(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException, ClassNotFoundException, IOException;

  public abstract Trigger[] selectTriggersForCalendar(Connection paramConnection, String paramString)
    throws SQLException, ClassNotFoundException, IOException;

  public abstract Trigger selectTrigger(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException, ClassNotFoundException, IOException;

  public abstract JobDataMap selectTriggerJobDataMap(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException, ClassNotFoundException, IOException;

  public abstract String selectTriggerState(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract TriggerStatus selectTriggerStatus(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract int selectNumTriggers(Connection paramConnection)
    throws SQLException;

  public abstract String[] selectTriggerGroups(Connection paramConnection)
    throws SQLException;

  public abstract String[] selectTriggersInGroup(Connection paramConnection, String paramString)
    throws SQLException;

  public abstract Key[] selectTriggersInState(Connection paramConnection, String paramString)
    throws SQLException;

  public abstract int insertPausedTriggerGroup(Connection paramConnection, String paramString)
    throws SQLException;

  public abstract int deletePausedTriggerGroup(Connection paramConnection, String paramString)
    throws SQLException;

  public abstract int deleteAllPausedTriggerGroups(Connection paramConnection)
    throws SQLException;

  public abstract boolean isTriggerGroupPaused(Connection paramConnection, String paramString)
    throws SQLException;

  public abstract Set selectPausedTriggerGroups(Connection paramConnection)
    throws SQLException;

  public abstract boolean isExistingTriggerGroup(Connection paramConnection, String paramString)
    throws SQLException;

  public abstract int insertCalendar(Connection paramConnection, String paramString, Calendar paramCalendar)
    throws IOException, SQLException;

  public abstract int updateCalendar(Connection paramConnection, String paramString, Calendar paramCalendar)
    throws IOException, SQLException;

  public abstract boolean calendarExists(Connection paramConnection, String paramString)
    throws SQLException;

  public abstract Calendar selectCalendar(Connection paramConnection, String paramString)
    throws ClassNotFoundException, IOException, SQLException;

  public abstract boolean calendarIsReferenced(Connection paramConnection, String paramString)
    throws SQLException;

  public abstract int deleteCalendar(Connection paramConnection, String paramString)
    throws SQLException;

  public abstract int selectNumCalendars(Connection paramConnection)
    throws SQLException;

  public abstract String[] selectCalendars(Connection paramConnection)
    throws SQLException;

  public abstract long selectNextFireTime(Connection paramConnection)
    throws SQLException;

  public abstract Key selectTriggerForFireTime(Connection paramConnection, long paramLong)
    throws SQLException;

  public abstract int insertFiredTrigger(Connection paramConnection, Trigger paramTrigger, String paramString, JobDetail paramJobDetail)
    throws SQLException;

  public abstract List selectFiredTriggerRecords(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract List selectFiredTriggerRecordsByJob(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract List selectInstancesFiredTriggerRecords(Connection paramConnection, String paramString)
    throws SQLException;

  public abstract int deleteFiredTrigger(Connection paramConnection, String paramString)
    throws SQLException;

  public abstract int selectJobExecutionCount(Connection paramConnection, String paramString1, String paramString2)
    throws SQLException;

  public abstract int insertSchedulerState(Connection paramConnection, String paramString1, long paramLong1, long paramLong2, String paramString2)
    throws SQLException;

  public abstract int deleteSchedulerState(Connection paramConnection, String paramString)
    throws SQLException;

  public abstract int updateSchedulerState(Connection paramConnection, String paramString1, long paramLong, String paramString2)
    throws SQLException;

  public abstract List selectSchedulerStateRecords(Connection paramConnection, String paramString)
    throws SQLException;
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.jdbcjobstore.DriverDelegate
 * JD-Core Version:    0.6.0
 */